/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.util.integration;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.util.QualifiedFaultEntry;
import com.ibm.etools.fa.pdtclient.ui.util.ReportOpenUtils;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.integration.PDMVSConnection;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.Objects;

public abstract class OpenReportRSE {
    private static final PDLogger logger = PDLogger.get(OpenReportRSE.class);

    public static FATPJob open(PDMVSConnection c, QualifiedFaultEntry qualifiedHFFE) {
        Objects.requireNonNull(c, MessageFormat.format("Please provide a non-null {0}", PDMVSConnection.class.getCanonicalName()));
        logger.info((Object)MessageFormat.format("Opening Report: {0} : {1} / {2}({3})", c.getHostName(), c.getPort(), qualifiedHFFE.getHistoryFile(), qualifiedHFFE.getFaultEntry()));
        return OpenReportRSE.open(c.getHostName(), c.getPort(), c.getAlias(), c.getUser(), c.getPass(), qualifiedHFFE);
    }

    public static FATPJob open(String hostName, String port, String alias, String user, String pass, QualifiedFaultEntry qualifiedHFFE) {
        Objects.requireNonNull(hostName, "Must provide a non-null hostName.");
        Objects.requireNonNull(user, "Must provide a non-null user.");
        Objects.requireNonNull(pass, "Must provide a non-null pass.");
        Objects.requireNonNull(qualifiedHFFE, "Must provide a non-null report to open.");
        PDLogger.get(OpenReportRSE.class).trace((Object)MessageFormat.format("OpenReportRSE.open: {0} {1}", hostName, qualifiedHFFE));
        if (port != null && port.trim().matches("\\d+")) {
            ConnectionUtilities.getConnection((String)alias, (String)hostName, (int)Integer.parseInt(port), (String)user, (String)pass);
            return ReportOpenUtils.openFaultEntry(hostName, port, qualifiedHFFE.getHistoryFile(), qualifiedHFFE.getFaultEntry());
        }
        PDDialogs.openErrorThreadSafe((String)Messages.OpenReportRSE_FaultAnalyzer, (String)Messages.OpenReportRSE_ExceptionWhileExcuting, (String)MessageFormat.format(Messages.OpenReportRSE_PORTNumberNotInIPVConfig, hostName, "PD_SERVER_PORT"));
        if (PDDialogs.openQuestion((String)Messages.OpenReportRSE_Question, (String)Messages.OpenReportRSE_WantToManuallySelectConnection)) {
            return ReportOpenUtils.openWithoutPort(hostName, qualifiedHFFE.getHistoryFile(), qualifiedHFFE.getFaultEntry());
        }
        return null;
    }
}

