/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.util;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.AddHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RefreshHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.report.OpenReportHandler;
import com.ibm.etools.fa.pdtclient.ui.util.QualifiedFaultEntry;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.dialog.SystemLookupDialog;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.AddSystem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ReportOpenUtils {
    INSTANCE;

    private static final PDLogger logger;
    private static final Pattern MATCHER_IDI003;
    private static final Pattern MATCHER_IDI0044;
    private static final Pattern MATCHER_IN_REPORT;
    private static List<Pattern> patterns;

    static {
        logger = PDLogger.get(ReportOpenUtils.class);
        MATCHER_IDI003 = Pattern.compile("IDI0003I Fault ID (\\S+) assigned in history file (\\S+)");
        MATCHER_IDI0044 = Pattern.compile("IDI0044I Current fault is a duplicate of fault ID (\\S+) in history file (\\S+)");
        MATCHER_IN_REPORT = Pattern.compile("Fault ID (\\S+) assigned in history file (\\S+).");
        patterns = new ArrayList<Pattern>();
        patterns.add(MATCHER_IDI003);
        patterns.add(MATCHER_IDI0044);
        patterns.add(MATCHER_IN_REPORT);
    }

    public static QualifiedFaultEntry search(String text2, String faultEntry) {
        try {
            if (text2 != null) {
                for (Pattern p : patterns) {
                    Matcher m = p.matcher(text2);
                    if (!m.find() || m.groupCount() != 2) continue;
                    if (faultEntry == null) {
                        faultEntry = m.group(1);
                    }
                    return new QualifiedFaultEntry(m.group(2), faultEntry);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return null;
    }

    public static FATPJob openFaultEntry(String host, String portNum, String historyFile, String faultEntry) {
        Objects.requireNonNull(host, "Host must not be null.");
        Objects.requireNonNull(portNum, "portNum must not be null.");
        Objects.requireNonNull(historyFile, "Must specify a non-null historyFile.");
        FATPJob addHistoryFileJob = AddHistoryFile.addHistoryFile(null, host, portNum, historyFile);
        RefreshHistoryFile.refresh(true);
        if (faultEntry != null) {
            OpenReportHandler.openReport(null, host, portNum, historyFile, faultEntry);
        }
        return addHistoryFileJob;
    }

    public static void askUserToCreateConnection(String host) {
        Objects.requireNonNull(host, "Must provide a non-null host.");
        PDDialogs.openInfoThreadSafe((String)Messages.ReportOpenUtils_0, (String)MessageFormat.format(Messages.ReportOpenUtils_1, host), (String)MessageFormat.format(Messages.ReportOpenUtils_2, host));
        AddSystem.addNewSystem();
    }

    public static FATPJob openWithoutPort(String host, String historyFile, String faultEntry) {
        Objects.requireNonNull(host, "Please provide a non-null host name string.");
        Objects.requireNonNull(historyFile, "Please provide a non-null historyFile string.");
        PDTreeContentHolder.addNewConnectionsDefined((boolean)false);
        List pdHostList = RegistryLocator.instance().getHostRegistry().all();
        if (pdHostList.isEmpty()) {
            ReportOpenUtils.askUserToCreateConnection(host);
        } else {
            ArrayList<IPDHost> hostsWithJobHostName = new ArrayList<IPDHost>();
            for (IPDHost system : pdHostList) {
                if (!system.getHostName().toUpperCase().equalsIgnoreCase(host)) continue;
                hostsWithJobHostName.add(system);
            }
            if (hostsWithJobHostName.isEmpty()) {
                ReportOpenUtils.askUserToCreateConnection(host);
            } else if (hostsWithJobHostName.size() == 1) {
                if (PDDialogs.openQuestionThreadSafe((String)MessageFormat.format(Messages.ReportOpenUtils_3, host), (String)MessageFormat.format(Messages.ReportOpenUtils_4, ((IPDHost)hostsWithJobHostName.get(0)).getFullHostName()))) {
                    return ReportOpenUtils.openFaultEntry(host, "" + ((IPDHost)hostsWithJobHostName.get(0)).getPort(), historyFile, faultEntry);
                }
            } else {
                if (PDDialogs.openConfirmThreadSafe((String)MessageFormat.format(Messages.ReportOpenUtils_5, host), (String)MessageFormat.format(Messages.ReportOpenUtils_6, ((IPDHost)hostsWithJobHostName.get(0)).getFullHostName()))) {
                    return ReportOpenUtils.openFaultEntry(((IPDHost)hostsWithJobHostName.get(0)).getHostName(), "" + ((IPDHost)hostsWithJobHostName.get(0)).getPort(), historyFile, faultEntry);
                }
                SystemLookupDialog dialog = new SystemLookupDialog();
                dialog.open();
                IPDHost selectedHost = dialog.getSelectedHost();
                if (selectedHost != null && selectedHost.getHostName().equalsIgnoreCase(host)) {
                    return ReportOpenUtils.openFaultEntry(selectedHost.getHostName(), "" + selectedHost.getPort(), historyFile, faultEntry);
                }
            }
        }
        return null;
    }
}

