/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterParser {
    private static final PDLogger logger = PDLogger.get(FilterParser.class);

    public static boolean parseAndEvalInteger(String columnName, String propertyValue, String filterValue) {
        Integer filter_value;
        Integer property_int;
        String exp_operator = null;
        String exp_operand = null;
        boolean flag = false;
        filterValue = filterValue.replace(" ", "").replace("\\", "");
        String regex = "([<>=!]=*)([0-9]{1,4})";
        Pattern exp_pattern = Pattern.compile(regex);
        Matcher filter_match = exp_pattern.matcher(filterValue);
        if (filter_match.matches()) {
            exp_operator = filter_match.group(1);
            exp_operand = filter_match.group(2);
        }
        try {
            property_int = Integer.parseInt(propertyValue);
            filter_value = exp_operand != null ? Integer.valueOf(Integer.parseInt(exp_operand)) : Integer.valueOf(Integer.parseInt(filterValue));
        }
        catch (NumberFormatException e) {
            logger.trace((Object)MessageFormat.format("The field value ({0}) or filter ({1}) for column ({2}) contains non-integer data.", propertyValue, exp_operand == null ? filterValue : exp_operand, columnName));
            return false;
        }
        switch (exp_operator = exp_operator != null ? exp_operator : "") {
            case "<": {
                if (property_int.compareTo(filter_value) >= 0) break;
                flag = true;
                break;
            }
            case "<=": {
                if (property_int.compareTo(filter_value) > 0) break;
                flag = true;
                break;
            }
            case ">": {
                if (property_int.compareTo(filter_value) <= 0) break;
                flag = true;
                break;
            }
            case ">=": {
                if (property_int.compareTo(filter_value) < 0) break;
                flag = true;
                break;
            }
            case "!=": {
                if (property_int.compareTo(filter_value) == 0) break;
                flag = true;
                break;
            }
            default: {
                if (property_int.compareTo(filter_value) != 0) break;
                flag = true;
            }
        }
        return flag;
    }

    public static boolean parseAndEvalHex(String columnName, String propertyValue, String filterValue) {
        Integer filter_value;
        Integer property_int;
        String exp_operator = null;
        String exp_operand = null;
        boolean flag = false;
        filterValue = filterValue.replace(" ", "").replace("\\", "");
        String regex = "([<>=!]=*)([0-9A-F]+$)";
        Pattern exp_pattern = Pattern.compile(regex);
        Matcher filter_match = exp_pattern.matcher(filterValue);
        if (filter_match.matches()) {
            exp_operator = filter_match.group(1);
            exp_operand = filter_match.group(2);
        }
        try {
            property_int = StringUtils.hexStringToInt((String)propertyValue);
            filter_value = exp_operand != null ? Integer.valueOf(StringUtils.hexStringToInt((String)exp_operand)) : Integer.valueOf(StringUtils.hexStringToInt((String)filterValue));
        }
        catch (NumberFormatException e) {
            logger.trace((Object)MessageFormat.format("The field value ({0}) or filter ({1}) for column ({2}) contains data that is not hexadecimal", propertyValue, exp_operand == null ? filterValue : exp_operand, columnName));
            return false;
        }
        switch (exp_operator = exp_operator != null ? exp_operator : "") {
            case "<": {
                if (property_int.compareTo(filter_value) >= 0) break;
                flag = true;
                break;
            }
            case "<=": {
                if (property_int.compareTo(filter_value) > 0) break;
                flag = true;
                break;
            }
            case ">": {
                if (property_int.compareTo(filter_value) <= 0) break;
                flag = true;
                break;
            }
            case ">=": {
                if (property_int.compareTo(filter_value) < 0) break;
                flag = true;
                break;
            }
            case "!=": {
                if (property_int.compareTo(filter_value) == 0) break;
                flag = true;
                break;
            }
            default: {
                if (property_int.compareTo(filter_value) != 0) break;
                flag = true;
            }
        }
        return flag;
    }

    public static boolean parseAndEvalDateField(String columnName, String propertyValue, String filterValue) {
        LocalDate propertyDate;
        String exp_operator = null;
        String exp_operand = null;
        boolean flag = false;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        filterValue = ((String)filterValue).replace(" ", "").replace("\\", "");
        Matcher noOperationMatcher = Pattern.compile("([0-9]{1,4}/[0-9]{1,2}/[0-9]{1,2})").matcher((CharSequence)filterValue);
        if (noOperationMatcher.matches()) {
            filterValue = "=" + (String)filterValue;
        }
        try {
            propertyDate = LocalDate.parse(propertyValue, formatter);
        }
        catch (DateTimeParseException e) {
            logger.trace((Object)MessageFormat.format("The field value ({0}) for column ({2}) contains data that is not in the expected date format: yyyy/MM/dd", propertyValue, columnName));
            return false;
        }
        String date_with_today_regex = "([<>=!]=*)([a-zA-Z]*)(-)*([0-9]{1,4})?";
        String date_regex = "([<>=!]=*)([0-9]{1,4}/[0-9]{1,2}/[0-9]{1,2})";
        Pattern today_date_filter = Pattern.compile(date_with_today_regex);
        Pattern specific_date_filter = Pattern.compile(date_regex);
        LocalDate matchDate = null;
        Matcher today_matcher = today_date_filter.matcher((CharSequence)filterValue);
        Matcher date_matcher = specific_date_filter.matcher((CharSequence)filterValue);
        if (today_matcher.matches()) {
            LocalDate localToday = LocalDate.now();
            exp_operator = today_matcher.group(1);
            exp_operand = today_matcher.group(4);
            if (exp_operand != null) {
                try {
                    localToday = localToday.minusDays(Integer.parseInt(exp_operand));
                }
                catch (DateTimeParseException e) {
                    logger.trace((Object)MessageFormat.format("The filter ({0}) for column ({2}) contains data that is not in the expected date format: yyyy/MM/dd", propertyValue, columnName));
                    return false;
                }
            }
            matchDate = localToday;
        }
        if (date_matcher.matches()) {
            exp_operator = date_matcher.group(1);
            exp_operand = date_matcher.group(2);
            if (exp_operand != null) {
                try {
                    matchDate = LocalDate.parse(exp_operand, formatter);
                }
                catch (DateTimeParseException e) {
                    logger.trace((Object)MessageFormat.format("The filter ({0}) for column ({2}) contains data that is not in the expected date format: yyyy/MM/dd", exp_operand, columnName));
                    return false;
                }
            }
        }
        if (exp_operator == null) {
            try {
                matchDate = LocalDate.parse((CharSequence)filterValue, formatter);
            }
            catch (DateTimeParseException e) {
                logger.trace((Object)MessageFormat.format("The filter ({0}) for column ({2}) contains data that is not in the expected date format: yyyy/MM/dd", exp_operand, columnName));
                return false;
            }
        }
        switch (exp_operator) {
            case "<": {
                if (propertyDate.compareTo(matchDate) >= 0) break;
                flag = true;
                break;
            }
            case "<=": {
                if (propertyDate.compareTo(matchDate) > 0) break;
                flag = true;
                break;
            }
            case ">": {
                if (propertyDate.compareTo(matchDate) <= 0) break;
                flag = true;
                break;
            }
            case ">=": {
                if (propertyDate.compareTo(matchDate) < 0) break;
                flag = true;
                break;
            }
            case "!=": {
                if (propertyDate.isEqual(matchDate)) break;
                flag = true;
                break;
            }
            default: {
                if (!propertyDate.isEqual(matchDate)) break;
                flag = true;
            }
        }
        return flag;
    }
}

