/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.util;

import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public final class EclipseUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String FILTER_SEPARATOR = ";";

    private static Map<String, String> getSpecialRegexCharacters() {
        LinkedHashMap<String, String> specialCharacters = new LinkedHashMap<String, String>();
        specialCharacters.put("\\", "\\\\");
        specialCharacters.put(".", "\\.");
        specialCharacters.put("[", "\\[");
        specialCharacters.put("]", "\\]");
        specialCharacters.put("(", "\\(");
        specialCharacters.put(")", "\\)");
        specialCharacters.put(">", "\\>");
        specialCharacters.put("<", "\\<");
        specialCharacters.put("{", "\\{");
        specialCharacters.put("}", "\\}");
        specialCharacters.put("-", "\\-");
        specialCharacters.put(":", "\\:");
        specialCharacters.put("|", "\\|");
        specialCharacters.put("!", "\\!");
        specialCharacters.put("=", "\\=");
        specialCharacters.put("$", "\\$");
        specialCharacters.put("^", "\\^");
        specialCharacters.put("?", "\\?");
        specialCharacters.put("+", "\\+");
        return specialCharacters;
    }

    public static String sanitiseRegexInput(String inputString) {
        String result = inputString;
        for (Map.Entry<String, String> entry : EclipseUtils.getSpecialRegexCharacters().entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        result = result.replace("*", ".*");
        result = result.replace("%", ".?");
        return result;
    }

    public static String sanitiseRegexOutput(String inputString) {
        String result = inputString;
        result = result.replace(".*", "*");
        result = result.replace(".?", "%");
        for (Map.Entry<String, String> entry : EclipseUtils.getSpecialRegexCharacters().entrySet()) {
            result = result.replace(entry.getValue(), entry.getKey());
        }
        return result;
    }

    private EclipseUtils() {
    }

    public static String[] splitFilter(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            return new String[0];
        }
        return value.split(FILTER_SEPARATOR);
    }
}

