/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.usermessages;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.FATPUtils;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.lookup.view.LookupView;
import com.ibm.pdtools.common.component.lookup.view.LookupViewListener;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.UserMessageSerializer;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.progress.UIJob;

public class UserMessageManager {
    private static final PDLogger logger = PDLogger.get(UserMessageManager.class);
    private static final UserMessageManager instance = new UserMessageManager();
    private boolean userMessagesLoaded = false;
    private boolean loadingUserMessages = false;
    private IFile cachedMessageFile;
    private Set<String> triedAndFailedSet = new HashSet<String>();

    public static UserMessageManager getInstance() {
        return instance;
    }

    private UserMessageManager() {
        this.cachedMessageFile = FACorePlugin.getRoot().getFile("idihusrm.xml");
    }

    public void startup() {
        UIJob job = new UIJob("User message code explanation load"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                LookupView.getView().addLookupViewListener(new LookupViewListener(){

                    public void explanationsLoaded() {
                        UserMessageManager.this.loadCachedMessageFile();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void reloadCachedMessageFileFromHost(IPDHost host, boolean force) {
        this.reloadCachedMessageFile(host.getHostID(), host.getHostName(), host.getPort(), force, false);
    }

    public void reloadCachedMessageFile(HostDetails host, boolean silentFail) {
        this.reloadCachedMessageFile(host.getHostID(), host.getHostname(), host.getPortNumber(), false, silentFail);
    }

    public boolean isHandled() {
        return this.userMessagesLoaded;
    }

    public boolean isLoadingUserMessages() {
        return this.loadingUserMessages;
    }

    public void setLoadingUserMessages(boolean loadingUserMessages) {
        this.loadingUserMessages = loadingUserMessages;
    }

    private void loadCachedMessageFile() {
        if (this.cachedMessageFile.getRawLocation().toFile().exists()) {
            final LookupView lookupView = LookupView.showView();
            PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (lookupView.addUserExplanationsFromCachedFile(UserMessageManager.this.cachedMessageFile)) {
                        UserMessageManager.this.userMessagesLoaded = true;
                    }
                }
            });
        }
    }

    private void reloadCachedMessageFile(final String hostId, String hostname, int port, boolean force, final boolean silentFail) {
        final String hostAndPort = hostname + ":" + port;
        if (!force && this.triedAndFailedSet.contains(hostId)) {
            logger.debug((Object)MessageFormat.format("Skipping attempt to load user messages for because it already failed once {0}", hostAndPort));
            return;
        }
        URI hostUri = FARL.getFARLURI((String)hostname, (String)Integer.toString(port));
        FATP farl = FARL.loadUserMessages((URI)hostUri);
        FATPJob job = new FATPJob(Messages.LoadUserMessages, farl){

            @Override
            protected void finalize_responses(IProgressMonitor monitor) {
                logger.debug((Object)("Attempted to download user messages for connection: " + hostAndPort));
                for (FATP[] request_response : this.responses) {
                    try {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (FATP response = request_response[1];){
                            if (response.is_successful_response() && response.get_status_code().equals("200")) {
                                XMLMemento hostMemento = UserMessageManager.parseServerResponse(response);
                                if (hostMemento == null) continue;
                                int count = new UserMessageSerializer().serialize(hostMemento, UserMessageManager.this.cachedMessageFile);
                                UserMessageManager.this.loadCachedMessageFile();
                                PDDialogs.openInfoThreadSafe((String)Messages.LoadUserMessagesTitle, (String)MessageFormat.format(Messages.LoadUserMessagesSuccess, count));
                                continue;
                            }
                            if (response.get_status_code().equals("204")) {
                                logger.info((Object)MessageFormat.format(Messages.UserMessageManager_noContent, hostAndPort));
                                UserMessageManager.this.triedAndFailedSet.add(hostId);
                                if (silentFail) continue;
                                PDDialogs.openInfoThreadSafe((String)Messages.LoadUserMessagesTitle, (String)MessageFormat.format(Messages.LoadUserMessagesEmpty, response.get_status_line()));
                                continue;
                            }
                            if (response.get_status_code().equals("501")) {
                                logger.info((Object)MessageFormat.format(Messages.UserMessageManager_notFound, hostAndPort));
                                UserMessageManager.this.triedAndFailedSet.add(hostId);
                                if (silentFail) continue;
                                PDDialogs.openInfoThreadSafe((String)Messages.LoadUserMessagesTitle, (String)MessageFormat.format(Messages.UserMessageManager_notFound, hostAndPort));
                                continue;
                            }
                            String message = MessageFormat.format(Messages.UserMessageManager_genericError, hostAndPort, response.get_status_line());
                            logger.error((Object)message);
                            UserMessageManager.this.triedAndFailedSet.add(hostId);
                            if (silentFail) continue;
                            PDDialogs.openInfoThreadSafe((String)Messages.LoadUserMessagesTitle, (String)message);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable e) {
                        UserMessageManager.this.triedAndFailedSet.add(hostId);
                        String message = MessageFormat.format(Messages.UserMessageManager_genericError, hostAndPort, e.getLocalizedMessage());
                        logger.error((Object)message, e);
                        if (silentFail) continue;
                        PDDialogs.openInfoThreadSafe((String)Messages.LoadUserMessagesTitle, (String)message);
                    }
                }
            }
        };
        job.schedule();
    }

    private static XMLMemento parseServerResponse(FATP response) {
        String content_encoding = response.get_entity_header("Content-Encoding");
        if (!content_encoding.equals("identity") && !content_encoding.equals("")) {
            return null;
        }
        String media_type = FATPUtils.getMediaTypeFromResponse(response);
        if (media_type == null || !media_type.isEmpty() && !media_type.equals("text/xml") && !media_type.equals("text/plain")) {
            return null;
        }
        Charset charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.get_entity_header("Content-Type"));
        String contents = response.get_body(charset).replaceAll("\u0000", " ");
        if (contents.isEmpty()) {
            return null;
        }
        try {
            XMLMemento root = XMLMemento.createReadRoot((Reader)new StringReader(contents));
            if (root.getType().equals("DATA")) {
                return root;
            }
        }
        catch (WorkbenchException e) {
            logger.error((Object)Messages.UserMessageManager_wbException, (Throwable)e);
        }
        return null;
    }
}

