/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report.psw;

import com.ibm.etools.fa.pdtclient.ui.report.psw.ProgramStatusWord64;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;

public class ProgramStatusWord {
    private String rawPSW;
    protected String numericPartOfPsw;
    protected String firstByte;
    protected String secondByte;

    public ProgramStatusWord(String rawPSW) {
        this.rawPSW = Objects.requireNonNull(rawPSW).replace('_', ' ');
        this.numericPartOfPsw = this.getNumericPartOfRawPSW();
        this.firstByte = this.getByte(0);
        this.secondByte = this.getByte(1);
    }

    protected String getNumericPartOfRawPSW() {
        if (this.rawPSW != null && this.rawPSW.contains(":")) {
            return this.rawPSW.trim().split(":")[1].trim();
        }
        return null;
    }

    protected String getByte(int requiredByte) {
        String[] numbers;
        String string;
        if (requiredByte >= 0 && requiredByte < 4 && (string = this.getNumericPartOfRawPSW()).contains(" ") && (numbers = string.split(" ")).length > requiredByte) {
            Object aByte = new BigInteger(numbers[requiredByte], 16).toString(2);
            int padding = 32 - ((String)aByte).length();
            if (padding > 0) {
                Object frontPadding = "";
                int i = 0;
                while (i < padding) {
                    frontPadding = (String)frontPadding + "0";
                    ++i;
                }
                aByte = (String)frontPadding + (String)aByte;
            }
            return aByte;
        }
        return null;
    }

    public String getPerMask() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(1);
        }
        return null;
    }

    public String getDATMode() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(5);
        }
        return null;
    }

    public String getIOMask() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(6);
        }
        return null;
    }

    public String getExternalMask() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(7);
        }
        return null;
    }

    public String getPSWKey() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(8) + this.firstByte.charAt(9) + this.firstByte.charAt(10) + this.firstByte.charAt(11);
        }
        return null;
    }

    public String getIsESA390() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(12);
        }
        return null;
    }

    public String getMachineCheckMask() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(13);
        }
        return null;
    }

    public String getWaitState() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(14);
        }
        return null;
    }

    public String getProblemState() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(15);
        }
        return null;
    }

    public String getAddressSpaceControl() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(16) + this.firstByte.charAt(17);
        }
        return null;
    }

    public String getConditionCode() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(18) + this.firstByte.charAt(19);
        }
        return null;
    }

    public String getProgramMask() {
        if (this.firstByte != null) {
            return "" + this.firstByte.charAt(20) + this.firstByte.charAt(21) + this.firstByte.charAt(22) + this.firstByte.charAt(23);
        }
        return null;
    }

    public String getAddressingMode() {
        if (this.secondByte != null) {
            return "" + this.secondByte.charAt(0);
        }
        return null;
    }

    public String getPSWRawString() {
        return this.numericPartOfPsw;
    }

    public String getPSWType() {
        return "(ESA/390)";
    }

    public String getPSWFormatString() {
        Object out = "";
        out = (String)out + "\u250f\u2501\u2533\u2501\u2533\u2501\u2501\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2501\u2533\u2501\u2501\u2533\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2533\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n";
        out = (String)out + "\u25030\u2503R\u2503000\u2503T\u2503I\u2503E\u2503PSW KEY\u25030\u2503M\u2503W\u2503P\u2503AS\u2503CC\u2503PGM MASK\u25030000000   \u2503\n";
        out = (String)out + "\u2517\u2501\u253b\u2501\u253b\u2501\u2501\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u2501\u253b\u2501\u2501\u253b\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u253b\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n";
        out = (String)out + " 0       5     8       12      16 18 20       24      31 \n";
        out = (String)out + "\u250f\u2501\u2533\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n";
        out = (String)out + "\u2503A\u2503Instruction Address                                  \u2503\n";
        out = (String)out + "\u2517\u2501\u253b\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n";
        out = (String)out + " 32 33                                                63 ";
        return out;
    }

    public String getPSWActualString() {
        Object out = "";
        out = (String)out + "\u250f\u2501\u2533\u2501\u2533\u2501\u2501\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2533\u2501\u2501\u2533\u2501\u2501\u2533\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2533\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n";
        out = (String)out + MessageFormat.format("\u25030\u2503{0}\u2503000\u2503{1}\u2503{2}\u2503{3}\u2503{4}   \u2503{5}\u2503{6}\u2503{7}\u2503{8}\u2503{9}\u2503{10}\u2503{11}    \u25030000000   \u2503\n", this.getPerMask(), this.getDATMode(), this.getIOMask(), this.getExternalMask(), this.getPSWKey(), this.getIsESA390(), this.getMachineCheckMask(), this.getWaitState(), this.getProblemState(), this.getAddressSpaceControl(), this.getConditionCode(), this.getProgramMask());
        out = (String)out + "\u2517\u2501\u253b\u2501\u253b\u2501\u2501\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u253b\u2501\u2501\u253b\u2501\u2501\u253b\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u253b\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n";
        out = (String)out + " 0       5     8       12      16 18 20       24      31 \n";
        out = (String)out + "\u250f\u2501\u2533\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n";
        out = (String)out + String.format("\u2503%s\u2503%08X                                             \u2503\n", this.getAddressingMode(), new BigInteger(this.secondByte, 2).longValue() & Integer.MAX_VALUE);
        out = (String)out + "\u2517\u2501\u253b\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n";
        out = (String)out + " 32 33                                                63 ";
        return out;
    }

    public String getPSWLegend() {
        String out = "1      Program-Event-Recording Mask         (R) \n5      DAT Mode                             (T = 1)  \n6      Input/Output Mask                    (I)    \n7      External Mask                        (E) \n12     One indicates ESA/390                   \n13     Machine-Check Mask                   (M)        \n14     Wait State                           (W = 1)         \n15     Problem State                        (P = 1)    \n16-17  Address Space Control                (AS)       \n       xx Real Mode                         (T = 0)\n       00 Primary-Space Mode                (T = 1)   \n       01 Access-Register Mode              (T = 1)    \n       10 Secondary-Space Mode              (T = 1)  \n       11 Home-Space Mode                   (T = 1)     \n18-19  Condition Code                       (CC)      \n20     Fixed-Point-Overflow Mask  \n21     Decimal-Overflow Mask      \n22     HFP-Exponent-Overflow Mask     \n23     HFP-Signficance Mask            \n32     31-Bit Addressing Mode               (A = 1)       \n33-63  Instruction Address                  (Hexadecimal)       ";
        return out;
    }

    public static void openPSW(IDocument document, String text2, IRegion region) {
        if (document != null) {
            try {
                ProgramStatusWord.openProgramStatusWord(text2.contains("64"), document.get(region.getOffset(), region.getLength()));
            }
            catch (BadLocationException e) {
                PDLogger.get(ProgramStatusWord.class).error((Throwable)e);
            }
        }
    }

    public static void openProgramStatusWord(final boolean is64bitPSW, final String sectionText) {
        if (sectionText != null && sectionText.contains(":")) {
            new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    BaseTitleAreaDialog dialog2 = new BaseTitleAreaDialog(){

                        protected void setShellStyle(int newShellStyle) {
                            super.setShellStyle(2144);
                            this.setBlockOnOpen(false);
                        }

                        protected Control createDialogArea(Composite parent) {
                            ProgramStatusWord programStatusWord = null;
                            programStatusWord = is64bitPSW ? new ProgramStatusWord64(sectionText) : new ProgramStatusWord(sectionText);
                            this.setTitle("Program Status Word");
                            this.setMessage("Program Status Word Breakdown Table");
                            GridData gridData = new GridData(4, 4, true, true);
                            gridData.minimumWidth = 480;
                            gridData.minimumHeight = 100;
                            Composite pswRaw = GUI.composite((Composite)parent, (Layout)GridLayoutFactory.fillDefaults().numColumns(3).create(), (Object)GridDataFactory.fillDefaults().create());
                            GUI.label.left((Composite)pswRaw, (String)"PSW", (Object)GridDataFactory.fillDefaults().create());
                            GUI.text((Composite)pswRaw, (Object)GridDataFactory.fillDefaults().create(), (int)0).setText(programStatusWord.getPSWRawString());
                            GUI.text((Composite)pswRaw, (Object)GridDataFactory.fillDefaults().create(), (int)0).setText(programStatusWord.getPSWType());
                            Group pswFormatGroup = GUI.group((Composite)parent, (String)"PSW Format", (Layout)GridLayoutFactory.fillDefaults().create(), (Object)GridDataFactory.fillDefaults().grab(true, true).create());
                            StyledText formatText = new StyledText((Composite)pswFormatGroup, 2570);
                            String pswFormatString = programStatusWord.getPSWFormatString();
                            formatText.setText(pswFormatString);
                            formatText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                            formatText.setBackground(parent.getDisplay().getSystemColor(1));
                            formatText.setFont(JFaceResources.getTextFont());
                            StyleRange styleRange = new StyleRange();
                            styleRange.start = 174;
                            styleRange.length = 56;
                            styleRange.fontStyle = 1;
                            styleRange.foreground = this.getDisplay().getSystemColor(10);
                            formatText.setStyleRange(styleRange);
                            StyleRange styleRange2 = new StyleRange();
                            styleRange2.start = 407;
                            styleRange2.length = 56;
                            styleRange2.fontStyle = 1;
                            styleRange2.foreground = this.getDisplay().getSystemColor(10);
                            formatText.setStyleRange(styleRange2);
                            StyleRange styleRange3 = new StyleRange();
                            styleRange3.start = 638;
                            styleRange3.length = 56;
                            styleRange3.fontStyle = 1;
                            styleRange3.foreground = this.getDisplay().getSystemColor(10);
                            if (is64bitPSW) {
                                formatText.setStyleRange(styleRange3);
                            }
                            StyleRange styleRange4 = new StyleRange();
                            styleRange4.start = 871;
                            styleRange4.length = 56;
                            styleRange4.fontStyle = 1;
                            styleRange4.foreground = this.getDisplay().getSystemColor(10);
                            if (is64bitPSW) {
                                formatText.setStyleRange(styleRange4);
                            }
                            Group actuals = GUI.group((Composite)parent, (String)"Actual values", (Layout)GridLayoutFactory.fillDefaults().create(), (Object)GridDataFactory.fillDefaults().grab(true, true).create());
                            StyledText actualText = new StyledText((Composite)actuals, 2570);
                            actualText.setText(programStatusWord.getPSWActualString());
                            actualText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                            actualText.setFont(JFaceResources.getTextFont());
                            actualText.setBackground(parent.getDisplay().getSystemColor(1));
                            actualText.setStyleRange(styleRange);
                            actualText.setStyleRange(styleRange2);
                            if (is64bitPSW) {
                                actualText.setStyleRange(styleRange3);
                                actualText.setStyleRange(styleRange4);
                            }
                            Group meanings = GUI.group((Composite)parent, (String)"Bit Meanings", (Layout)GridLayoutFactory.fillDefaults().create(), (Object)GridDataFactory.fillDefaults().grab(true, true).create());
                            StyledText meaningText = new StyledText((Composite)meanings, 2570);
                            meaningText.setFont(JFaceResources.getTextFont());
                            meaningText.setText(programStatusWord.getPSWLegend());
                            meaningText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                            meaningText.setBackground(parent.getDisplay().getSystemColor(1));
                            return parent;
                        }
                    };
                    dialog2.open();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

