/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report.markers;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.report.Markers;
import com.ibm.etools.fa.pdtclient.ui.report.markers.MarkerCategory;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class MarkerLoader {
    private static final PDLogger logger = PDLogger.get(Markers.class);
    private List<IMarker> markers;
    private static final MarkerCategory[] types = new MarkerCategory[]{new MarkerCategory(Messages.Markers_Bookmarks){

        @Override
        public boolean test(IMarker marker) {
            return MarkerLoader.check(marker, "org.eclipse.core.resources.bookmark") && !MarkerLoader.hasMDMLExtension(marker);
        }
    }, new MarkerCategory(Messages.Markers_Tasks){

        @Override
        public boolean test(IMarker marker) {
            return MarkerLoader.check(marker, "org.eclipse.core.resources.taskmarker") && !MarkerLoader.hasMDMLExtension(marker);
        }
    }, new MarkerCategory(Messages.Markers_UsernoteBookmarks){

        @Override
        public boolean test(IMarker marker) {
            return MarkerLoader.check(marker, "org.eclipse.core.resources.bookmark") && MarkerLoader.hasMDMLExtension(marker);
        }
    }, new MarkerCategory(Messages.Markers_UsernoteTasks){

        @Override
        public boolean test(IMarker marker) {
            return MarkerLoader.check(marker, "org.eclipse.core.resources.taskmarker") && MarkerLoader.hasMDMLExtension(marker);
        }
    }, new MarkerCategory(Messages.Markers_HostUsernotes){

        @Override
        public boolean test(IMarker marker) {
            return MarkerLoader.check(marker, "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.usernote.marker");
        }
    }};

    private static boolean check(IMarker marker, String type) {
        try {
            return marker.exists() && type.equals(marker.getType());
        }
        catch (CoreException e) {
            logger.warn((Throwable)e);
            return false;
        }
    }

    private static boolean hasMDMLExtension(IMarker marker) {
        return FAResourceUtils.isFileExtension((IPath)marker.getResource().getProjectRelativePath(), (String)"mdml");
    }

    public MarkerLoader(IContainer file) {
        if (FACorePlugin.getRoot().exists(file.getProjectRelativePath())) {
            try {
                this.markers = Arrays.asList(file.findMarkers("org.eclipse.core.resources.marker", true, 2));
            }
            catch (CoreException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public Object[] getChildren(Object o) {
        if (o instanceof MarkerCategory) {
            return ((MarkerCategory)o).getChildren(this.markers);
        }
        return new Object[0];
    }

    public boolean hasChildren(Object o) {
        if (o instanceof MarkerCategory) {
            return ((MarkerCategory)o).hasChildren(this.markers);
        }
        return false;
    }

    public MarkerCategory getParent(Object o) {
        if (o instanceof IMarker) {
            IMarker marker = (IMarker)o;
            MarkerCategory[] markerCategoryArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                MarkerCategory c = markerCategoryArray[n2];
                if (c.test(marker)) {
                    return c;
                }
                ++n2;
            }
        }
        return null;
    }

    public Object[] getElements() {
        return types;
    }
}

