/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report.impl.model.cicsstg;

import java.text.MessageFormat;
import java.util.Objects;

public class CICSTransactionStorage
implements Comparable<CICSTransactionStorage> {
    private final int offset;
    private final int length;
    private final String type;
    private final long storageAddress;
    private final long storageLength;
    private final String hexDumpedStorage;

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getType() {
        return this.type;
    }

    public String getStorageAddress() {
        return "" + this.storageAddress;
    }

    public String getStorageAddressHex() {
        return CICSTransactionStorage.zeroPad(Long.toHexString(this.storageAddress)).toUpperCase();
    }

    public long getStorageLength() {
        return this.storageLength;
    }

    public String getStorageLengthHex() {
        return Long.toHexString(this.storageLength).toUpperCase();
    }

    private static String zeroPad(String hexString) {
        int toPad = 0;
        if (((String)hexString).length() < 8) {
            toPad = 8 - ((String)hexString).length();
        } else if (((String)hexString).length() == 8) {
            toPad = 0;
        } else if (((String)hexString).length() < 16) {
            toPad = 16 - ((String)hexString).length();
        }
        int i = 0;
        while (i < toPad) {
            hexString = "0" + (String)hexString;
            ++i;
        }
        if (((String)hexString).length() == 16) {
            long firstWord = Long.parseLong(((String)hexString).substring(0, 8), 16);
            String secondWord = ((String)hexString).substring(9);
            return Long.toHexString(firstWord) + "_" + secondWord;
        }
        return hexString;
    }

    public String getHexDumpedStorage() {
        return this.hexDumpedStorage;
    }

    public CICSTransactionStorage(int offset, int length, String type, String storageAddress, String storageLength, String hexDumpedStorage) {
        this.offset = offset;
        this.length = length;
        this.type = Objects.requireNonNull(type, "Must provide a non-null type.");
        this.storageAddress = Long.parseLong(Objects.requireNonNull(storageAddress, "Must provide a non-null storageAddress."));
        this.storageLength = Long.parseLong(Objects.requireNonNull(storageLength, "Must provide a non-null storageLength."));
        this.hexDumpedStorage = Objects.requireNonNull(hexDumpedStorage, "Must provide a non-null hexDumpedStorage.").trim();
    }

    public String toString() {
        return MessageFormat.format("CICSTransactionStorage [offset={0}, length={1}, type={2}, storageAddress={3}, storageLength={4}]\n", this.offset, this.length, this.type, this.storageAddress, this.storageLength);
    }

    @Override
    public int compareTo(CICSTransactionStorage o) {
        return Integer.compare(this.offset, o.offset);
    }
}

