/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report.impl.model.cicslink;

import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.report.impl.model.cicslink.CICSExecInstance;
import com.ibm.etools.fa.pdtclient.ui.report.impl.model.cicslink.CICSStorageViolation;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class CICSNode
implements Comparable<CICSNode> {
    public static final String ACTION_ABEND = "Abend";
    public static final String ACTION_PERCOLATE = "Percolate";
    public static final String ACTION_HANDLE_ABEND = "Handle Abend";
    public static final String ACTION_LINK = "Link";
    public static final String ACTION_RETURN = "Return";
    public static final String ACTION_REGISTER_HANDLER = "Register Handler";
    private static final String ELEMENT_CICSNODE = "cicsnode";
    private static final String ELEMENT_STORAGEVIOLATIONS = "storageviolations";
    private static final String ELEMENT_EXECLIST = "execlist";
    private static final String ELEMENT_LENGTH = "length";
    private static final String ELEMENT_ADDRESS = "address";
    private static final String ELEMENT_DSN = "dsn";
    private static final String ELEMENT_DDNAME = "ddname";
    private static final String ELEMENT_ELAPSEDTIME = "elapsedtime";
    private static final String ELEMENT_CALLLEVEL = "calllevel";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_ACTION = "action";
    private static final PDLogger logger = PDLogger.get(CICSNode.class);
    private final String action;
    private final String moduleName;
    private final int callLevel;
    private final String elapsedTime;
    private final String ddname;
    private final String dsn;
    private final String address;
    private final String length;
    private final List<CICSExecInstance> execList = new ArrayList<CICSExecInstance>();
    private final int index;
    private CICSNode parent;
    private final List<CICSNode> children = new ArrayList<CICSNode>();
    private final List<CICSStorageViolation> violations = new ArrayList<CICSStorageViolation>();

    public int hashCode() {
        return Objects.hash(this.action, this.callLevel, this.moduleName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CICSNode other = (CICSNode)obj;
        return Objects.equals(this.action, other.action) && this.callLevel == other.callLevel && Objects.equals(this.moduleName, other.moduleName);
    }

    public CICSNode(int index) {
        this.action = ACTION_LINK;
        this.callLevel = -1;
        this.elapsedTime = "";
        this.moduleName = "CICS";
        this.ddname = "";
        this.dsn = "";
        this.address = "";
        this.length = "";
        this.parent = this;
        this.index = index;
        logger.trace((Object)"Create Root CICS Node");
    }

    private static String getValue(IMemento m, String name) {
        IMemento actionM = m.getChild(name);
        if (actionM != null) {
            String textData = actionM.getTextData();
            if (textData != null) {
                return textData.trim();
            }
            return "";
        }
        return "";
    }

    public CICSNode(int index, IMemento cicsNode) {
        IMemento[] violationsM;
        int n;
        IMemento[] execM;
        this.action = CICSNode.getValue(cicsNode, ELEMENT_ACTION);
        this.moduleName = CICSNode.getValue(cicsNode, ELEMENT_NAME);
        this.callLevel = Integer.parseInt(CICSNode.getValue(cicsNode, ELEMENT_CALLLEVEL));
        this.elapsedTime = CICSNode.getValue(cicsNode, ELEMENT_ELAPSEDTIME);
        this.ddname = CICSNode.getValue(cicsNode, ELEMENT_DDNAME);
        this.dsn = CICSNode.getValue(cicsNode, ELEMENT_DSN);
        this.address = CICSNode.getValue(cicsNode, ELEMENT_ADDRESS);
        this.length = CICSNode.getValue(cicsNode, ELEMENT_LENGTH);
        IMemento execlist = cicsNode.getChild(ELEMENT_EXECLIST);
        if (execlist != null && (execM = execlist.getChildren()) != null) {
            IMemento[] iMementoArray = execM;
            n = execM.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento row = iMementoArray[n2];
                CICSExecInstance e = new CICSExecInstance(row);
                this.getExecList().add(e);
                ++n2;
            }
        }
        Collections.sort(this.getExecList());
        IMemento storageViolations = cicsNode.getChild(ELEMENT_STORAGEVIOLATIONS);
        if (storageViolations != null && (violationsM = storageViolations.getChildren()) != null) {
            IMemento[] iMementoArray = violationsM;
            int n3 = violationsM.length;
            n = 0;
            while (n < n3) {
                IMemento row = iMementoArray[n];
                CICSStorageViolation e = new CICSStorageViolation(row);
                this.getViolations().add(e);
                ++n;
            }
        }
        Collections.sort(this.getViolations());
        this.index = index;
        logger.trace((Object)MessageFormat.format("Create  CICS Node: {0}", this.moduleName));
    }

    public String toString() {
        Object str = "";
        int i = 0;
        while (i < this.callLevel) {
            str = (String)str + "  ";
            ++i;
        }
        str = (String)str + MessageFormat.format("{0} {1} {2} (time = {3}) execs: ({4})", this.callLevel, this.action, this.moduleName, this.elapsedTime, this.getExecList());
        if (!this.getChildren().isEmpty()) {
            str = (String)str + "\n";
        }
        for (CICSNode child : this.children) {
            str = (String)str + String.valueOf(child) + "\n";
        }
        return str;
    }

    public List<CICSNode> getChildren() {
        ArrayList<CICSNode> filtered = new ArrayList<CICSNode>();
        for (CICSNode n : this.children) {
            filtered.add(n);
        }
        return filtered;
    }

    public static CICSNode getNodes(IFile cicsTraceFile, IProgressMonitor monitor, Map<String, CICSNode> outNodes) {
        XMLMemento cicsTrace = MementoUtils.loadXMLMementoFromIFile((IFile)cicsTraceFile, (boolean)true, (Charset)StandardCharsets.UTF_8, (IProgressMonitor)monitor);
        String textData = cicsTrace.getTextData();
        if (textData != null) {
            textData = textData.trim();
        }
        if (textData != null && !textData.isEmpty()) {
            throw new IllegalArgumentException(textData);
        }
        int totalNodes = 0;
        CICSNode rootNode = new CICSNode(totalNodes++);
        outNodes.put(rootNode.moduleName + "." + rootNode.action + "." + rootNode.index, rootNode);
        Stack<CICSNode> stack = new Stack<CICSNode>();
        IMemento[] iMementoArray = cicsTrace.getChildren(ELEMENT_CICSNODE);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento cicsNode = iMementoArray[n2];
            CICSNode node = new CICSNode(totalNodes++, cicsNode);
            outNodes.put(node.moduleName + "." + node.action + "." + node.index, node);
            if (stack.isEmpty()) {
                if (node.action.equals(ACTION_LINK) || node.action.equals(ACTION_HANDLE_ABEND) || node.action.equals(ACTION_ABEND)) {
                    logger.trace((Object)("PUSH : " + String.valueOf(node)));
                    stack.push(node);
                    rootNode.children.add(node);
                    node.parent = rootNode;
                }
            } else {
                CICSNode stackNode = (CICSNode)stack.peek();
                if (stackNode.callLevel < node.callLevel) {
                    stackNode.children.add(node);
                    node.parent = stackNode;
                    if (node.action.equals(ACTION_LINK) || node.action.equals(ACTION_HANDLE_ABEND)) {
                        logger.trace((Object)("PUSH : " + String.valueOf(node)));
                        stack.push(node);
                    }
                } else if (stackNode.callLevel == node.callLevel) {
                    if (node.action.equals(ACTION_RETURN) || node.action.equals(ACTION_PERCOLATE)) {
                        CICSNode popped = (CICSNode)stack.pop();
                        logger.trace((Object)("POP : " + String.valueOf(popped)));
                        if (!stack.isEmpty()) {
                            ((CICSNode)stack.peek()).children.add(node);
                            node.parent = (CICSNode)stack.peek();
                        } else {
                            rootNode.children.add(node);
                            node.parent = rootNode;
                        }
                    } else {
                        logger.error((Object)("TODO: what is this --> " + String.valueOf(node)));
                    }
                } else {
                    stack.pop();
                    stack.push(node);
                }
            }
            ++n2;
        }
        if (!stack.isEmpty()) {
            logger.trace((Object)("Nodes still on stack... " + String.valueOf(stack)));
        }
        logger.trace((Object)rootNode);
        return rootNode;
    }

    public String getAction() {
        return this.action;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public int getCallLevel() {
        return this.callLevel;
    }

    public String getElapsedTime() {
        return this.elapsedTime;
    }

    public String getDdname() {
        return this.ddname;
    }

    public String getDsn() {
        return this.dsn;
    }

    public String getAddress() {
        return this.address;
    }

    public String getLength() {
        return this.length;
    }

    public CICSNode getParent() {
        return this.parent;
    }

    public List<CICSStorageViolation> getViolations() {
        return this.violations;
    }

    public List<CICSExecInstance> getExecList() {
        return this.execList;
    }

    @Override
    public int compareTo(CICSNode o) {
        int name = this.moduleName.compareTo(this.moduleName);
        if (name != 0) {
            return name;
        }
        return Integer.compare(this.callLevel, o.callLevel);
    }

    public String buildTooltop() {
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.CICSNode_Module).append(this.moduleName).append("\n\n");
        if (!this.getElapsedTime().isEmpty()) {
            sb.append(Messages.CICSNode_ElapsedTime).append(this.getElapsedTime()).append("\n");
        }
        if (!this.getAddress().isEmpty()) {
            sb.append(Messages.CICSNode_Address).append(this.getAddress()).append("\n");
        }
        if (!this.getLength().isEmpty()) {
            sb.append(Messages.CICSNode_Length).append(this.getLength()).append("\n");
        }
        if (!this.getDdname().isEmpty()) {
            sb.append(Messages.CICSNode_DD).append(this.getDdname()).append("\n");
            sb.append(Messages.CICSNode_DSN + this.getDsn()).append("\n");
        }
        if (!this.getExecList().isEmpty()) {
            sb.append(Messages.CICSNode_EXECs);
            for (CICSExecInstance cICSExecInstance : this.getExecList()) {
                sb.append(cICSExecInstance.getNameString()).append(" ").append(cICSExecInstance.getCount()).append("\n");
            }
        }
        if (!this.getViolations().isEmpty()) {
            sb.append(Messages.CICSNode_StorageViolations);
            for (CICSStorageViolation cICSStorageViolation : this.getViolations()) {
                sb.append(cICSStorageViolation.getName()).append(" ").append(cICSStorageViolation.getCount()).append("\n");
            }
        }
        String string = sb.toString();
        return string;
    }

    public int getIndex() {
        return this.index;
    }
}

