/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report.impl;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.report.impl.model.cicsstg.CICSTransactionStorage;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class CICSTransactionStorageFilterDialog
extends BaseTitleAreaDialog {
    private static final String CICS64 = "CICS64";
    private static final String CICS31 = "CICS31";
    private static final String CICS24 = "CICS24";
    private static final String USER64 = "USER64";
    private static final String USER31 = "USER31";
    private static final String USER24 = "USER24";
    private final List<CICSTransactionStorage> transactionStorage;

    public CICSTransactionStorageFilterDialog(List<CICSTransactionStorage> transactionStorage) {
        this.transactionStorage = Objects.requireNonNull(transactionStorage);
    }

    private Button createStorageSelectionButton(Composite parent, String type, String tooltip) {
        int occurances = 0;
        for (CICSTransactionStorage cicsTransactionStorage : this.transactionStorage) {
            if (!cicsTransactionStorage.getType().equals(type)) continue;
            ++occurances;
        }
        Button button2 = GUI.button.checkbox((Composite)parent, (String)MessageFormat.format("{0} ({1})", type, occurances), (Object)GridDataFactory.fillDefaults().create());
        button2.setToolTipText(tooltip);
        if (occurances == 0) {
            button2.setEnabled(false);
        } else {
            button2.setSelection(true);
        }
        return button2;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setMinimumSize(950, 600);
        this.setTitle(Messages.CICSTransactionStorageFilterDialog_CICSTransactionStorage);
        this.setMessage(Messages.CICSTransactionStorageFilterDialog_SpecifyRequiredFields);
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).create());
        Composite filterControls = GUI.composite((Composite)parent, (Layout)GridLayoutFactory.fillDefaults().create(), (Object)GridDataFactory.fillDefaults().grab(false, true).create());
        Group storageClasses = GUI.group((Composite)filterControls, (String)Messages.CICSTransactionStorageFilterDialog_CICSClassToDisplay, (Layout)GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).create(), (Object)GridDataFactory.fillDefaults().create());
        Button user24Button = this.createStorageSelectionButton((Composite)storageClasses, USER24, Messages.CICSTransactionStorageFilterDialog_user24Tooltip);
        Button user31Button = this.createStorageSelectionButton((Composite)storageClasses, USER31, Messages.CICSTransactionStorageFilterDialog_user31tooltip);
        Button user64Button = this.createStorageSelectionButton((Composite)storageClasses, USER64, Messages.CICSTransactionStorageFilterDialog_user64Tooltip);
        Button cics24Button = this.createStorageSelectionButton((Composite)storageClasses, CICS24, Messages.CICSTransactionStorageFilterDialog_cics24Tooltip);
        Button cics31Button = this.createStorageSelectionButton((Composite)storageClasses, CICS31, Messages.CICSTransactionStorageFilterDialog_cics31tooltip);
        Button cics64Button = this.createStorageSelectionButton((Composite)storageClasses, CICS64, Messages.CICSTransactionStorageFilterDialog_cics64Tooltip);
        Composite lengthComposite = GUI.composite((Composite)filterControls, (Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).create(), (Object)GridDataFactory.fillDefaults().create());
        GUI.label((Composite)lengthComposite, (String)Messages.CICSTransactionStorageFilterDialog_minLengthHex, (Object)GridDataFactory.fillDefaults().create(), (int)0);
        Text minLength = GUI.text.field((Composite)lengthComposite, (Object)GridDataFactory.fillDefaults().grab(true, false).create());
        minLength.setToolTipText(Messages.CICSTransactionStorageFilterDialog_minLengthToolip);
        minLength.setTextLimit(17);
        minLength.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.replaceAll("[^A-Fa-f0-9]", "").toUpperCase();
            }
        });
        GUI.label((Composite)lengthComposite, (String)Messages.CICSTransactionStorageFilterDialog_maxLengthHex, (Object)GridDataFactory.fillDefaults().create(), (int)0);
        Text maxLength = GUI.text.field((Composite)lengthComposite, (Object)GridDataFactory.fillDefaults().grab(true, false).create());
        maxLength.setToolTipText(Messages.CICSTransactionStorageFilterDialog_maxLengthTooltip);
        maxLength.setTextLimit(17);
        maxLength.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.replaceAll("[^A-Za-f0-9]", "").toUpperCase();
            }
        });
        final TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        StorageSummaryFilter filter = new StorageSummaryFilter(user24Button, maxLength, minLength, user31Button, cics24Button, cics31Button, cics64Button, user64Button);
        filter.setIncludeLeadingWildcard(true);
        final FilteredTree filteredTree = new FilteredTree(filterControls, 0x10010B00, filter, true){

            protected Control createTreeControl(Composite parent, int style) {
                Control c = super.createTreeControl(parent, style);
                c.setLayoutData(null);
                c.getParent().setLayout((Layout)treeColumnLayout);
                return c;
            }
        };
        final TreeViewer tv = filteredTree.getViewer();
        tv.getTree().setHeaderVisible(true);
        tv.getTree().setLinesVisible(true);
        tv.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object element) {
                return CICSTransactionStorageFilterDialog.this.transactionStorage.toArray();
            }

            public Object[] getChildren(Object element) {
                return null;
            }
        });
        TreeViewerColumn typeColumn = new TreeViewerColumn(tv, 0);
        typeColumn.getColumn().setResizable(false);
        typeColumn.getColumn().setMoveable(false);
        typeColumn.getColumn().setText(Messages.CICSTransactionStorageFilterDialog_Class);
        typeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CICSTransactionStorage) {
                    CICSTransactionStorage stg = (CICSTransactionStorage)element;
                    return stg.getType();
                }
                return "";
            }
        });
        treeColumnLayout.setColumnData((Widget)typeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TreeViewerColumn addressColumn = new TreeViewerColumn(tv, 0);
        addressColumn.getColumn().setResizable(false);
        addressColumn.getColumn().setMoveable(false);
        addressColumn.getColumn().setText(Messages.CICSTransactionStorageFilterDialog_Address);
        addressColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CICSTransactionStorage) {
                    CICSTransactionStorage stg = (CICSTransactionStorage)element;
                    return stg.getStorageAddressHex();
                }
                return "";
            }
        });
        treeColumnLayout.setColumnData((Widget)addressColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TreeViewerColumn lengthColumn = new TreeViewerColumn(tv, 0);
        lengthColumn.getColumn().setResizable(false);
        lengthColumn.getColumn().setMoveable(false);
        lengthColumn.getColumn().setText(Messages.CICSTransactionStorageFilterDialog_Length);
        lengthColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CICSTransactionStorage) {
                    CICSTransactionStorage stg = (CICSTransactionStorage)element;
                    return stg.getStorageLengthHex();
                }
                return "";
            }
        });
        treeColumnLayout.setColumnData((Widget)lengthColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        tv.setInput(this.transactionStorage);
        CICSTransactionStorageFilterDialog.addUpdateTableOnSelectionListener(user24Button, tv);
        CICSTransactionStorageFilterDialog.addUpdateTableOnSelectionListener(user31Button, tv);
        CICSTransactionStorageFilterDialog.addUpdateTableOnSelectionListener(user64Button, tv);
        CICSTransactionStorageFilterDialog.addUpdateTableOnSelectionListener(cics24Button, tv);
        CICSTransactionStorageFilterDialog.addUpdateTableOnSelectionListener(cics31Button, tv);
        CICSTransactionStorageFilterDialog.addUpdateTableOnSelectionListener(cics64Button, tv);
        Composite storageDisplay = GUI.composite((Composite)parent, (Layout)GridLayoutFactory.fillDefaults().create(), (Object)GridDataFactory.fillDefaults().grab(true, true).create());
        final StyledText hexStorage = new StyledText(storageDisplay, 778);
        hexStorage.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
        hexStorage.setBackground(Display.getCurrent().getSystemColor(1));
        hexStorage.setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.pdtclient.ui.font"));
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection ss;
                Object selectedElement;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof CICSTransactionStorage) {
                    CICSTransactionStorage storage = (CICSTransactionStorage)selectedElement;
                    String hexDumpedStorage = storage.getHexDumpedStorage();
                    hexStorage.setText(hexDumpedStorage);
                }
            }
        });
        filteredTree.getFilterControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CICSTransactionStorageFilterDialog.this.highlightMatches(filteredTree, hexStorage);
            }
        });
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (!e.getSelection().isEmpty()) {
                    CICSTransactionStorageFilterDialog.this.highlightMatches(filteredTree, hexStorage);
                }
            }
        });
        if (!this.transactionStorage.isEmpty()) {
            tv.setSelection((ISelection)new StructuredSelection((Object)this.transactionStorage.get(0)));
        }
        minLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                tv.refresh(false);
            }
        });
        maxLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                tv.refresh(false);
            }
        });
        return parent;
    }

    private void highlightMatches(FilteredTree filteredTree, StyledText hexStorage) {
        String currentText = hexStorage.getText();
        if (currentText != null) {
            currentText = currentText.toUpperCase();
            Color green = Display.getDefault().getSystemColor(5);
            String filterString = filteredTree.getFilterControl().getText();
            if ((filterString = filterString.toUpperCase()).trim().length() > 1) {
                ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
                int offset = 0;
                while ((offset = currentText.indexOf(filterString, offset)) != -1) {
                    StyleRange style = new StyleRange();
                    style.start = offset;
                    style.length = filterString.length();
                    style.background = green;
                    styles.add(style);
                    offset += filterString.length();
                    if (styles.size() == 1) {
                        hexStorage.setSelection(((StyleRange)styles.get((int)0)).start, ((StyleRange)styles.get((int)0)).start + ((StyleRange)styles.get((int)0)).length);
                    }
                    if (offset != -1) continue;
                }
                hexStorage.setStyleRanges(styles.toArray(new StyleRange[0]));
            } else {
                hexStorage.setStyleRanges(new StyleRange[0]);
                hexStorage.setSelection(0, 0);
            }
        }
    }

    private static void addUpdateTableOnSelectionListener(Button button2, final TreeViewer tv) {
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tv.refresh(false);
            }
        });
    }

    private final class StorageSummaryFilter
    extends PatternFilter {
        private final Button user24Button;
        private final Text maxLength;
        private final Text minLength;
        private final Button user31Button;
        private final Button cics24Button;
        private final Button cics31Button;
        private final Button cics64Button;
        private final Button user64Button;

        private StorageSummaryFilter(Button user24Button, Text maxLength, Text minLength, Button user31Button, Button cics24Button, Button cics31Button, Button cics64Button, Button user64Button) {
            this.user24Button = user24Button;
            this.maxLength = maxLength;
            this.minLength = minLength;
            this.user31Button = user31Button;
            this.cics24Button = cics24Button;
            this.cics31Button = cics31Button;
            this.cics64Button = cics64Button;
            this.user64Button = user64Button;
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            Object[] filter = super.filter(viewer, parent, elements);
            ArrayList<Object> out = new ArrayList<Object>();
            Object[] objectArray = filter;
            int n = filter.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof CICSTransactionStorage) {
                    String maxLengthString;
                    String minLengthString;
                    CICSTransactionStorage stg = (CICSTransactionStorage)o;
                    boolean select = false;
                    if (CICSTransactionStorageFilterDialog.USER24.equals(stg.getType()) && this.user24Button.getSelection()) {
                        select |= true;
                    } else if (CICSTransactionStorageFilterDialog.USER31.equals(stg.getType()) && this.user31Button.getSelection()) {
                        select |= true;
                    } else if (CICSTransactionStorageFilterDialog.USER64.equals(stg.getType()) && this.user64Button.getSelection()) {
                        select |= true;
                    } else if (CICSTransactionStorageFilterDialog.CICS24.equals(stg.getType()) && this.cics24Button.getSelection()) {
                        select |= true;
                    } else if (CICSTransactionStorageFilterDialog.CICS31.equals(stg.getType()) && this.cics31Button.getSelection()) {
                        select |= true;
                    } else if (CICSTransactionStorageFilterDialog.CICS64.equals(stg.getType()) && this.cics64Button.getSelection()) {
                        select |= true;
                    }
                    if (select && (minLengthString = this.minLength.getText()).length() > 0) {
                        select = stg.getStorageLength() >= Long.parseLong(minLengthString, 16) ? (select |= true) : false;
                    }
                    if (select && (maxLengthString = this.maxLength.getText()).length() > 0) {
                        select = stg.getStorageLength() <= Long.parseLong(maxLengthString, 16) ? (select |= true) : false;
                    }
                    if (select) {
                        out.add(o);
                    }
                }
                ++n2;
            }
            return out.toArray();
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            TreeViewer treeViewer = (TreeViewer)viewer;
            int numberOfColumns = treeViewer.getTree().getColumnCount();
            boolean isMatch = false;
            int columnIndex = 0;
            while (columnIndex < numberOfColumns) {
                ColumnLabelProvider labelProvider = (ColumnLabelProvider)treeViewer.getLabelProvider(columnIndex);
                String labelText = labelProvider.getText(element);
                isMatch |= this.wordMatches(labelText);
                ++columnIndex;
            }
            if (element instanceof CICSTransactionStorage) {
                CICSTransactionStorage stg = (CICSTransactionStorage)element;
                isMatch |= this.wordMatches(stg.getHexDumpedStorage());
            }
            return isMatch;
        }
    }
}

