/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report.impl;

import com.ibm.etools.fa.pdtclient.ui.report.impl.CICSTransactionStorageFilterDialog;
import com.ibm.etools.fa.pdtclient.ui.report.impl.model.cicsstg.CICSTransactionStorage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;

public class CICSTransactionStorageFilter {
    private static final PDLogger logger = PDLogger.get(CICSTransactionStorageFilter.class);

    private static String getHexDumpedStorage(IDocument document, Position position) {
        try {
            return document.get(position.getOffset(), position.getLength());
        }
        catch (BadLocationException e) {
            logger.error((Throwable)e);
            return "";
        }
    }

    public static void filterStorage(IDocument document, IAnnotationModel model) {
        final List<CICSTransactionStorage> transactionStorage = CICSTransactionStorageFilter.getCICSTransactionStorageSections(document, model);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CICSTransactionStorageFilterDialog dialog = new CICSTransactionStorageFilterDialog(transactionStorage);
                dialog.open();
            }
        });
    }

    private static List<CICSTransactionStorage> getCICSTransactionStorageSections(IDocument document, IAnnotationModel model) {
        Pattern pattern = Pattern.compile("<section4 id=\"transaction.storage.(\\S+)\" title=\".+\" address=\"(\\d+)\" length=\"(\\d+)\">");
        ArrayList<CICSTransactionStorage> transactionStorage = new ArrayList<CICSTransactionStorage>();
        Iterator annotationIterator = model.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Position position;
            Matcher matcher;
            Annotation annotation = (Annotation)annotationIterator.next();
            if (!annotation.getType().equals("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsubsection.annotation") || annotation.getText() == null || !annotation.getText().contains("id=\"transaction.storage.") || !(matcher = pattern.matcher(annotation.getText())).find() || (position = model.getPosition(annotation)).getLength() <= 0) continue;
            transactionStorage.add(new CICSTransactionStorage(position.getOffset(), position.getLength(), matcher.group(1), matcher.group(2), matcher.group(3), CICSTransactionStorageFilter.getHexDumpedStorage(document, position)));
        }
        Collections.sort(transactionStorage);
        return transactionStorage;
    }
}

