/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report.impl;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.report.impl.model.cicslink.CICSExecInstance;
import com.ibm.etools.fa.pdtclient.ui.report.impl.model.cicslink.CICSNode;
import com.ibm.etools.fa.pdtclient.ui.report.impl.model.cicslink.CICSStorageViolation;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CICSTraceLinkAnalysisDialog
extends BaseTitleAreaDialog {
    private static final PDLogger logger = PDLogger.get(CICSTraceLinkAnalysisDialog.class);
    private final CICSNode root;
    private final Map<String, CICSNode> cicsNodes;
    private final Color lightGray = new Color(null, 210, 210, 210);
    private final Color lightBlue = new Color(null, 68, 124, 196);

    CICSTraceLinkAnalysisDialog(CICSNode root, Map<String, CICSNode> cicsNodes) {
        this.root = root;
        this.cicsNodes = cicsNodes;
    }

    public boolean close() {
        this.lightGray.dispose();
        this.lightBlue.dispose();
        return super.close();
    }

    /*
     * WARNING - void declaration
     */
    private static DirectedGraph simpleGraph(Map<String, CICSNode> cicsNodes) {
        void var5_10;
        Objects.requireNonNull(cicsNodes, "Must provide a non-null map of CICSNode.");
        logger.trace((Object)MessageFormat.format("Total nodes to render = {0}", cicsNodes.size()));
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        HashMap<CICSNode, Node> mappings = new HashMap<CICSNode, Node>();
        int rowOrder = 0;
        for (CICSNode cICSNode : cicsNodes.values()) {
            Node node = new Node((Object)cICSNode);
            node.setSize(new Dimension(80, 80));
            node.setPadding(new Insets(20, 20, 20, 20));
            mappings.put(cICSNode, node);
            if (cICSNode.getAction().equals("Return")) continue;
            node.setRowConstraint(rowOrder++);
            CICSTraceLinkAnalysisDialog.addNodeUnchecked(nodes, node);
        }
        logger.trace((Object)MessageFormat.format("Total mappings = {0}", mappings.size()));
        for (Map.Entry entry : mappings.entrySet()) {
            CICSNode cicsNode = (CICSNode)entry.getKey();
            logger.trace((Object)MessageFormat.format("Creating edges from: {0} ( {1})", cicsNode.getModuleName(), cicsNode.getAction()));
            for (CICSNode cICSNode : cicsNode.getChildren()) {
                if (cICSNode.getAction().equals("Percolate") || cICSNode.getAction().equals("Handle Abend")) continue;
                if (cICSNode.getAction().equals("Return")) {
                    String moduleReturnedFrom = cICSNode.getModuleName();
                    String elapsed = cICSNode.getElapsedTime();
                    for (CICSNode sibling : cICSNode.getParent().getChildren()) {
                        if (!sibling.getModuleName().equals(moduleReturnedFrom) || !sibling.getElapsedTime().equals(elapsed) || !sibling.getAction().equals("Link")) continue;
                        Node siblingNode = (Node)mappings.get(sibling);
                        Node parentNode = (Node)mappings.get(cICSNode.getParent());
                        if (siblingNode == null || parentNode == null) continue;
                        Edge e = new Edge(siblingNode, parentNode);
                        e.setDelta(1);
                        CICSTraceLinkAnalysisDialog.addEdgeUnchecked(edges, e);
                        logger.trace((Object)MessageFormat.format("Edge from {0} ({1}) to {2} ({3})", sibling.getModuleName(), sibling.getAction(), cICSNode.getParent().getModuleName(), cICSNode.getParent().getAction()));
                    }
                    continue;
                }
                Node nodeForChild = (Node)mappings.get(cICSNode);
                if (nodeForChild != null) {
                    logger.trace((Object)MessageFormat.format("Edge from {0} ({1}) to {2} ({3})", cicsNode.getModuleName(), cicsNode.getAction(), cICSNode.getModuleName(), cICSNode.getAction()));
                    Edge e = new Edge((Node)entry.getValue(), nodeForChild);
                    e.setDelta(1);
                    e.setSourceOffset(20);
                    e.setTargetOffset(20);
                    e.setPadding(40);
                    CICSTraceLinkAnalysisDialog.addEdgeUnchecked(edges, e);
                    continue;
                }
                logger.error((Object)MessageFormat.format("No mapping for {0}", cICSNode));
            }
        }
        boolean bl = false;
        while (var5_10 < mappings.size()) {
            for (Map.Entry m : mappings.entrySet()) {
                if (((CICSNode)m.getKey()).getIndex() != var5_10 || ((CICSNode)m.getKey()).getAction().equals("Return") || ((CICSNode)m.getKey()).getAction().equals("Register Handler")) continue;
                for (Map.Entry entry : mappings.entrySet()) {
                    if (((CICSNode)entry.getKey()).getIndex() != ((CICSNode)m.getKey()).getIndex() + 1 || ((CICSNode)entry.getKey()).getAction().equals("Return")) continue;
                    System.out.println("Edge from " + ((CICSNode)m.getKey()).getModuleName() + " " + ((CICSNode)m.getKey()).getAction() + " to " + ((CICSNode)entry.getKey()).getModuleName() + " " + ((CICSNode)entry.getKey()).getAction());
                    Edge e = new Edge((Node)m.getValue(), (Node)entry.getValue());
                    e.setDelta(1);
                    e.setSourceOffset(20);
                    e.setTargetOffset(20);
                    e.setPadding(40);
                    CICSTraceLinkAnalysisDialog.addEdgeUnchecked(edges, e);
                }
            }
            ++var5_10;
        }
        DirectedGraph directedGraph = new DirectedGraph();
        directedGraph.setDefaultPadding(new Insets(20, 20, 20, 20));
        directedGraph.setMargin(new Insets(20, 20, 20, 20));
        directedGraph.setDirection(4);
        directedGraph.nodes = nodes;
        directedGraph.edges = edges;
        new DirectedGraphLayout().visit(directedGraph);
        return directedGraph;
    }

    private static void addEdgeUnchecked(EdgeList edges, Edge e) {
        edges.add((Object)e);
    }

    private static void addNodeUnchecked(NodeList nodes, Node node) {
        nodes.add((Object)node);
    }

    private Figure buildGraph(DirectedGraph graph) {
        Panel contents = new Panel();
        contents.setBackgroundColor(ColorConstants.white);
        contents.setLayoutManager((LayoutManager)new XYLayout());
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = graph.nodes.getNode(i);
            Label label2 = new Label();
            label2.setTextAlignment(2);
            if ("Abend".equals(((CICSNode)node.data).getAction())) {
                label2.setBackgroundColor(ColorConstants.red);
            } else if ("Percolate".equals(((CICSNode)node.data).getAction())) {
                label2.setBackgroundColor(ColorConstants.orange);
            } else if ("Handle Abend".equals(((CICSNode)node.data).getAction())) {
                label2.setBackgroundColor(ColorConstants.lightBlue);
            } else if (1 == ((CICSNode)node.data).getIndex()) {
                label2.setBackgroundColor(ColorConstants.green);
            } else {
                label2.setBackgroundColor(this.lightGray);
            }
            label2.setOpaque(true);
            label2.setBorder((Border)new LineBorder());
            if (node.incoming.isEmpty()) {
                label2.setBorder((Border)new LineBorder(2));
                label2.setBackgroundColor(ColorConstants.lightBlue);
            }
            Object origData = node.data;
            CICSNode aNode = (CICSNode)origData;
            String text = i + " " + aNode.getModuleName();
            if (!aNode.getAction().equals("Link")) {
                text = text + MessageFormat.format("\n({0})", aNode.getAction());
            }
            label2.setText(text);
            label2.setToolTip((IFigure)new Label(aNode.buildTooltop()));
            node.data = label2;
            contents.add((IFigure)label2, (Object)new Rectangle(node.x, node.y, node.width, node.height));
            label2.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent arg0) {
                }

                public void mouseEntered(MouseEvent me) {
                    IFigure figure = (IFigure)me.getSource();
                    figure.setOpaque(false);
                }

                public void mouseExited(MouseEvent me) {
                    IFigure figure = (IFigure)me.getSource();
                    figure.setOpaque(true);
                }

                public void mouseHover(MouseEvent me) {
                }

                public void mouseMoved(MouseEvent arg0) {
                }
            });
            label2.setSize(node.width, node.height);
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            PolylineConnection conn = new PolylineConnection();
            conn.setForegroundColor(this.lightBlue);
            conn.setAntialias(1);
            conn.setConnectionRouter((ConnectionRouter)new FanRouter());
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            NodeList nodes = edge.vNodes;
            if (nodes != null) {
                int j = 0;
                while (j < nodes.size()) {
                    Node node = nodes.getNode(j);
                    int x = node.x;
                    int y = node.y;
                    bends.add(new AbsoluteBendpoint(x, y));
                    bends.add(new AbsoluteBendpoint(x, y + node.height));
                    ++j;
                }
            }
            conn.setRoutingConstraint(bends);
            PolygonDecoration dec = new PolygonDecoration();
            dec.setAntialias(1);
            conn.setTargetDecoration((RotatableDecoration)dec);
            conn.setPoints(edge.getPoints());
            contents.add((IFigure)conn);
            ++i;
        }
        return contents;
    }

    protected Composite createDialogContent(Composite parent) {
        this.getShell().setMinimumSize(800, 600);
        this.setTitle(Messages.CICSTraceLinkAnalysisDialog_InternalCICSTraceLinkAnalysis);
        parent.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        TabItem graphicalView = new TabItem(folder, 0);
        graphicalView.setText(Messages.CICSAsyncInfo_GraphicalView);
        Composite graphicalCom = GUI.composite((Composite)folder, (Layout)GridLayoutFactory.fillDefaults().create(), (Object)GridDataFactory.fillDefaults().create());
        graphicalView.setControl((Control)graphicalCom);
        FigureCanvas fc = new FigureCanvas(graphicalCom);
        DirectedGraph graph = CICSTraceLinkAnalysisDialog.simpleGraph(this.cicsNodes);
        fc.setContents((IFigure)this.buildGraph(graph));
        fc.getViewport().setContentsTracksHeight(true);
        fc.getViewport().setContentsTracksWidth(true);
        fc.setLayoutData((Object)new GridData(1808));
        TabItem accessibleTab = new TabItem(folder, 0);
        accessibleTab.setText(Messages.CICSAsyncInfo_TextView);
        Composite acc = GUI.composite((Composite)folder, (Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).create(), (Object)GridDataFactory.fillDefaults().grab(true, true).create());
        accessibleTab.setControl((Control)acc);
        this.createAccessibleView(this.root, acc);
        return parent;
    }

    private void createAccessibleView(CICSNode nodes, Composite acc) {
        Composite composite = GUI.composite((Composite)acc, (Layout)GridLayoutFactory.fillDefaults().create(), (Object)GridDataFactory.fillDefaults().grab(true, true).create());
        TreeViewer modulesTree = this.createModulesTree(nodes, composite);
        Composite detail = GUI.composite((Composite)acc, (Layout)GridLayoutFactory.fillDefaults().numColumns(1).create(), (Object)GridDataFactory.fillDefaults().grab(true, true).span(2, 1).create());
        final TableViewer propertiesTable = CICSTraceLinkAnalysisDialog.createPropertiesTable(detail);
        final TableViewer execsTable = CICSTraceLinkAnalysisDialog.createExecsTable(detail);
        final TableViewer storageViolations = CICSTraceLinkAnalysisDialog.createStorageViolationsTable(detail);
        modulesTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection ss;
                if (e.getSelection() instanceof IStructuredSelection && (ss = (IStructuredSelection)e.getSelection()).getFirstElement() instanceof CICSNode) {
                    CICSNode c = (CICSNode)ss.getFirstElement();
                    execsTable.setInput(c.getExecList());
                    propertiesTable.setInput((Object)new CICSNode[]{c});
                    storageViolations.setInput(c.getViolations());
                }
            }
        });
        if (!nodes.getChildren().isEmpty()) {
            modulesTree.setSelection((ISelection)new StructuredSelection((Object)nodes.getChildren().get(0)));
        }
    }

    private TreeViewer createModulesTree(CICSNode nodes, Composite acc) {
        CoolBar bar = new CoolBar(acc, 2048);
        CoolItem item = new CoolItem(bar, 0);
        Button collapseAll = GUI.button.push((Composite)bar, (Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_COLLAPSEALL"), (String)Messages.CICSTraceLinkAnalysisDialog_CollapseAll, (Object)GridDataFactory.fillDefaults().create());
        Point size = collapseAll.computeSize(-1, -1);
        item.setPreferredSize(item.computeSize(size.x, size.y));
        item.setControl((Control)collapseAll);
        Composite container = new Composite(acc, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)container);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        container.setLayout((Layout)treeColumnLayout);
        final TreeViewer modulesTree = new TreeViewer(container, 268438274);
        modulesTree.setAutoExpandLevel(5);
        modulesTree.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().create());
        modulesTree.getTree().setHeaderVisible(true);
        modulesTree.getTree().setLinesVisible(true);
        modulesTree.setUseHashlookup(true);
        modulesTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object o) {
                if (o instanceof CICSNode) {
                    return !((CICSNode)o).getChildren().isEmpty();
                }
                return false;
            }

            public Object getParent(Object o) {
                if (o instanceof CICSNode) {
                    return ((CICSNode)o).getParent();
                }
                return null;
            }

            public Object[] getElements(Object o) {
                return this.getChildren(o);
            }

            public Object[] getChildren(Object o) {
                if (o instanceof CICSNode) {
                    return ((CICSNode)o).getChildren().toArray();
                }
                return null;
            }
        });
        TreeViewerColumn column = new TreeViewerColumn(modulesTree, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return element instanceof CICSNode ? ((CICSNode)element).getAction() + " " + ((CICSNode)element).getModuleName() : "";
            }
        });
        column.getColumn().setText(Messages.CICSTraceLinkAnalysisDialog_Module);
        treeColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        modulesTree.setInput((Object)nodes);
        collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                modulesTree.collapseAll();
            }
        });
        return modulesTree;
    }

    private static TableViewer createExecsTable(Composite detail) {
        Composite tableComposite = new Composite(detail, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewer execsTable = new TableViewer(tableComposite);
        execsTable.getTable().setLinesVisible(true);
        execsTable.getTable().setHeaderVisible(true);
        execsTable.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().create());
        execsTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn execName = new TableViewerColumn(execsTable, 0);
        execName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CICSExecInstance) {
                    CICSExecInstance ci = (CICSExecInstance)element;
                    return ci.getNameString();
                }
                return "";
            }
        });
        execName.getColumn().setText(Messages.CICSTraceLinkAnalysisDialog_EXECs);
        tableColumnLayout.setColumnData((Widget)execName.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn count = new TableViewerColumn(execsTable, 0);
        count.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CICSExecInstance) {
                    CICSExecInstance ci = (CICSExecInstance)element;
                    return ci.getCount();
                }
                return "";
            }
        });
        count.getColumn().setText(Messages.CICSTraceLinkAnalysisDialog_Count);
        tableColumnLayout.setColumnData((Widget)count.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        return execsTable;
    }

    private static <T> void createColumn(TableViewer tv, final String name, final ValueGetter<String> getter, TableColumnLayout tableColumnLayout) {
        Objects.requireNonNull(tv);
        Objects.requireNonNull(name);
        Objects.requireNonNull(getter);
        TableViewerColumn column = new TableViewerColumn(tv, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return element instanceof CICSNode ? getter.getValue((CICSNode)element, name) : "";
            }
        });
        column.getColumn().setText(name);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
    }

    private static TableViewer createPropertiesTable(Composite detail) {
        Composite tableComposite = new Composite(detail, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewer propertiesTable = new TableViewer(tableComposite, 68354);
        propertiesTable.getTable().setLinesVisible(true);
        propertiesTable.getTable().setHeaderVisible(true);
        propertiesTable.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        propertiesTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        CICSTraceLinkAnalysisDialog.createColumn(propertiesTable, Messages.CICSTraceLinkAnalysisDialog_DDName, new ValueGetter<String>(){

            @Override
            public String getValue(CICSNode node, String name) {
                return node.getDdname();
            }
        }, tableColumnLayout);
        CICSTraceLinkAnalysisDialog.createColumn(propertiesTable, Messages.CICSTraceLinkAnalysisDialog_DSN, new ValueGetter<String>(){

            @Override
            public String getValue(CICSNode node, String name) {
                return node.getDsn();
            }
        }, tableColumnLayout);
        CICSTraceLinkAnalysisDialog.createColumn(propertiesTable, Messages.CICSTraceLinkAnalysisDialog_ModuleAddress, new ValueGetter<String>(){

            @Override
            public String getValue(CICSNode node, String name) {
                return node.getAddress();
            }
        }, tableColumnLayout);
        CICSTraceLinkAnalysisDialog.createColumn(propertiesTable, Messages.CICSTraceLinkAnalysisDialog_ModuleLength, new ValueGetter<String>(){

            @Override
            public String getValue(CICSNode node, String name) {
                return node.getLength();
            }
        }, tableColumnLayout);
        CICSTraceLinkAnalysisDialog.createColumn(propertiesTable, Messages.CICSTraceLinkAnalysisDialog_ElapsedTime, new ValueGetter<String>(){

            @Override
            public String getValue(CICSNode node, String name) {
                return node.getElapsedTime();
            }
        }, tableColumnLayout);
        return propertiesTable;
    }

    private static TableViewer createStorageViolationsTable(Composite detail) {
        Composite tableComposite = new Composite(detail, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewer violationsTable = new TableViewer(tableComposite, 68354);
        violationsTable.getTable().setLinesVisible(true);
        violationsTable.getTable().setHeaderVisible(true);
        violationsTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn name = new TableViewerColumn(violationsTable, 0);
        name.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CICSStorageViolation) {
                    CICSStorageViolation ci = (CICSStorageViolation)element;
                    return ci.getName();
                }
                return "";
            }
        });
        name.getColumn().setText(Messages.CICSTraceLinkAnalysisDialog_Type);
        tableColumnLayout.setColumnData((Widget)name.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn count = new TableViewerColumn(violationsTable, 0);
        count.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CICSStorageViolation) {
                    CICSStorageViolation ci = (CICSStorageViolation)element;
                    return ci.getCount();
                }
                return "";
            }
        });
        count.getColumn().setText(Messages.CICSTraceLinkAnalysisDialog_Count);
        tableColumnLayout.setColumnData((Widget)count.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        return violationsTable;
    }

    private static interface ValueGetter<T> {
        public String getValue(CICSNode var1, T var2);
    }
}

