/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report.impl;

import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.SimpleLoweredBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class CICSAsyncInfo {
    public static void showAsyncInfo(IFile asyncInfoFile, IProgressMonitor monitor) {
        if (!asyncInfoFile.exists()) {
            PDDialogs.openErrorThreadSafe((String)Messages.CICSAsyncInfo_AsyncInfoNotFound);
        }
        XMLMemento asyncInfo = MementoUtils.loadXMLMementoFromIFile((IFile)asyncInfoFile, (boolean)true, (Charset)StandardCharsets.UTF_8, (IProgressMonitor)monitor);
        final LinkedHashMap<String, AsyncNode> nodes = new LinkedHashMap<String, AsyncNode>();
        final AsyncNode topLevelTreeNode = new AsyncNode("", "");
        String rootTaskName = asyncInfo.getString("rootTaskName");
        final String rootTask = asyncInfo.getString("root");
        AsyncNode rootNode = new AsyncNode(rootTask, rootTaskName);
        topLevelTreeNode.children.add(rootNode);
        nodes.put(rootTask, rootNode);
        IMemento[] iMementoArray = asyncInfo.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            String parent = child.getString("parent");
            AsyncNode parentNode = (AsyncNode)nodes.get(parent);
            if (parentNode != null) {
                AsyncNode childNode = new AsyncNode(parentNode, child.getString("state"), child.getString("task"), child.getString("tranId"));
                parentNode.children.add(childNode);
                nodes.put(childNode.task, childNode);
            }
            ++n2;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BaseTitleAreaDialog dialog = new BaseTitleAreaDialog(){

                    protected Composite createDialogContent(Composite parent) {
                        this.setTitle(Messages.CICSAsyncInfo_CICSAsyncInfo);
                        this.setMessage(Messages.CICSAsyncInfo_AsyncTransactionMap + rootTask);
                        TabFolder folder = new TabFolder(parent, 0);
                        TabItem graphicalView = new TabItem(folder, 0);
                        graphicalView.setText(Messages.CICSAsyncInfo_GraphicalView);
                        Composite graphicalCom = GUI.composite((Composite)folder, (Layout)GridLayoutFactory.fillDefaults().create(), (Object)GridDataFactory.fillDefaults().create());
                        graphicalView.setControl((Control)graphicalCom);
                        FigureCanvas fc = new FigureCanvas(graphicalCom);
                        DirectedGraph graph = CICSAsyncInfo.simpleGraph(nodes);
                        fc.setContents((IFigure)CICSAsyncInfo.buildGraph(graph));
                        fc.getViewport().setContentsTracksHeight(true);
                        fc.getViewport().setContentsTracksWidth(true);
                        fc.setLayoutData((Object)new GridData(1808));
                        TabItem accessibleTab = new TabItem(folder, 0);
                        accessibleTab.setText(Messages.CICSAsyncInfo_TextView);
                        Composite acc = GUI.composite((Composite)folder, (Layout)GridLayoutFactory.fillDefaults().create(), (Object)GridDataFactory.fillDefaults().create());
                        accessibleTab.setControl((Control)acc);
                        TreeViewer tv = new TreeViewer(acc, 268438274);
                        tv.setAutoExpandLevel(5);
                        tv.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                        tv.getTree().setHeaderVisible(true);
                        tv.getTree().setLinesVisible(true);
                        tv.setUseHashlookup(true);
                        tv.setContentProvider((IContentProvider)new ITreeContentProvider(){

                            public boolean hasChildren(Object o) {
                                if (o instanceof AsyncNode) {
                                    return !((AsyncNode)o).children.isEmpty();
                                }
                                return false;
                            }

                            public Object getParent(Object o) {
                                if (o instanceof AsyncNode) {
                                    AsyncNode node = (AsyncNode)o;
                                    return node.parent;
                                }
                                return null;
                            }

                            public Object[] getElements(Object o) {
                                return this.getChildren(o);
                            }

                            public Object[] getChildren(Object o) {
                                if (o instanceof AsyncNode) {
                                    AsyncNode node = (AsyncNode)o;
                                    return node.children.toArray();
                                }
                                return null;
                            }
                        });
                        TreeViewerColumn col1 = new TreeViewerColumn(tv, 0);
                        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
                        col1.getColumn().setText(Messages.CICSAsyncInfo_Task);
                        col1.getColumn().setWidth(600);
                        tv.setInput((Object)topLevelTreeNode);
                        return parent;
                    }
                };
                dialog.open();
            }
        });
    }

    private static DirectedGraph simpleGraph(Map<String, AsyncNode> asyncNodes) {
        Objects.requireNonNull(asyncNodes, "Must provide a non-null asyncNodes.");
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        HashMap<AsyncNode, Node> mappings = new HashMap<AsyncNode, Node>();
        for (Map.Entry<String, AsyncNode> asyncNode : asyncNodes.entrySet()) {
            Node n = new Node((Object)asyncNode.getValue());
            nodes.add((Object)n);
            mappings.put(asyncNode.getValue(), n);
        }
        for (Map.Entry<String, AsyncNode> asyncNode : asyncNodes.entrySet()) {
            Node parent = (Node)mappings.get(asyncNode.getValue());
            for (AsyncNode asyncChild : asyncNode.getValue().children) {
                Node child = (Node)mappings.get(asyncChild);
                edges.add((Object)new Edge(parent, child));
            }
        }
        DirectedGraph graph = new DirectedGraph();
        graph.setDefaultPadding(new Insets(20, 20, 20, 20));
        graph.setMargin(new Insets(10, 10, 10, 10));
        graph.setDirection(4);
        graph.nodes = nodes;
        graph.edges = edges;
        new DirectedGraphLayout().visit(graph);
        return graph;
    }

    private static Figure buildGraph(DirectedGraph graph) {
        Panel contents = new Panel();
        contents.setBackgroundColor(ColorConstants.white);
        contents.setLayoutManager((LayoutManager)new XYLayout());
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = graph.nodes.getNode(i);
            Label label2 = new Label();
            if ("3".equals(((AsyncNode)node.data).state)) {
                label2.setBackgroundColor(ColorConstants.red);
            } else if ("1".equals(((AsyncNode)node.data).state)) {
                label2.setBackgroundColor(ColorConstants.green);
            } else {
                label2.setBackgroundColor(ColorConstants.lightGray);
            }
            label2.setOpaque(true);
            if ("3".equals(((AsyncNode)node.data).state)) {
                label2.setBorder((Border)new SimpleLoweredBorder(4));
            } else {
                label2.setBorder((Border)new LineBorder());
            }
            if (node.incoming.isEmpty()) {
                label2.setBorder((Border)new LineBorder(2));
                label2.setBackgroundColor(ColorConstants.lightBlue);
            }
            Object origData = node.data;
            AsyncNode asyncNode = (AsyncNode)origData;
            String text = asyncNode.tranId.toString();
            label2.setText(text);
            label2.setToolTip((IFigure)new Label(MessageFormat.format(Messages.CICSAsyncInfo_TaskState, asyncNode.task, asyncNode.getState())));
            node.data = label2;
            contents.add((IFigure)label2, (Object)new Rectangle(node.x, node.y, node.width, node.height));
            label2.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent arg0) {
                }

                public void mouseEntered(MouseEvent me) {
                    IFigure figure = (IFigure)me.getSource();
                    figure.setOpaque(false);
                }

                public void mouseExited(MouseEvent me) {
                    IFigure figure = (IFigure)me.getSource();
                    figure.setOpaque(true);
                }

                public void mouseHover(MouseEvent me) {
                }

                public void mouseMoved(MouseEvent arg0) {
                }
            });
            label2.setSize(200, 200);
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            PolylineConnection conn = new PolylineConnection();
            conn.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            NodeList nodes = edge.vNodes;
            if (nodes != null) {
                int j = 0;
                while (j < nodes.size()) {
                    Node n = nodes.getNode(j);
                    int x = n.x;
                    int y = n.y;
                    bends.add(new AbsoluteBendpoint(x, y));
                    bends.add(new AbsoluteBendpoint(x, y + n.height));
                    ++j;
                }
            }
            conn.setRoutingConstraint(bends);
            conn.setForegroundColor(ColorConstants.gray);
            PolygonDecoration dec = new PolygonDecoration();
            conn.setTargetDecoration((RotatableDecoration)dec);
            conn.setPoints(edge.getPoints());
            contents.add((IFigure)conn);
            ++i;
        }
        return contents;
    }

    private static class AsyncNode {
        private List<AsyncNode> children = new ArrayList<AsyncNode>();
        private AsyncNode parent;
        private String state;
        private String task;
        private String tranId;

        public AsyncNode(String task, String tranId) {
            this.task = task;
            this.tranId = tranId;
        }

        public AsyncNode(AsyncNode parent, String state, String task, String tranId) {
            this.parent = parent;
            this.state = state;
            this.task = task;
            this.tranId = tranId;
        }

        private String getState() {
            if (this.state == null) {
                return Messages.CICSAsyncInfo_na;
            }
            switch (this.state) {
                case "0": {
                    return Messages.CICSAsyncInfo_NotStarted;
                }
                case "1": {
                    return Messages.CICSAsyncInfo_active;
                }
                case "2": {
                    return Messages.CICSAsyncInfo_completed;
                }
                case "3": {
                    return Messages.CICSAsyncInfo_abended;
                }
                case "4": {
                    return Messages.CICSAsyncInfo_freeChildOrSecError;
                }
            }
            return Messages.CICSAsyncInfo_na;
        }

        public String toString() {
            return MessageFormat.format("{0} {1} {2}", this.task, this.tranId, this.getState());
        }
    }
}

