/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SourceFileParser
extends DefaultHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(SourceFileParser.class);
    private static final String TABLE = "table";
    private static final String DATA = "td";
    private static final String ROW = "tr";
    private static final int SOURCE_COLUMN_NUMBER = 3;
    private IFolder sourceFolder;
    private IFile sourceFile;
    private IFile offsetFile;
    private StringBuilder sourceFileStringBuilder = new StringBuilder();
    private StringBuilder offsetFileStringBuilder = new StringBuilder();
    private String filename;
    private String filetype;
    private int dataNodeIndex = 0;

    public SourceFileParser(IFolder sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    private IFile createIFile(String newFileName, String newFileType) {
        IFile file = this.sourceFolder.getFile(newFileName + "." + newFileType);
        if (file.exists()) {
            IResourceUtils.deleteIFile((IFile)file, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        IResourceUtils.createEmptyIFile((IFile)file, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        logger.trace((Object)("Created " + String.valueOf(file)));
        return file;
    }

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
        switch (elementName) {
            case "td": {
                this.offsetFileStringBuilder.append("<td>");
                break;
            }
            case "tr": {
                this.dataNodeIndex = 0;
                this.offsetFileStringBuilder.append("<tr>");
                break;
            }
            case "table": {
                this.filename = null;
                this.filetype = null;
                this.dataNodeIndex = 0;
                int i = 0;
                while (i < attributes.getLength()) {
                    String attributeName = attributes.getQName(i);
                    if (attributeName.equals("src")) {
                        this.filename = attributes.getValue(i);
                    } else if (attributeName.equals("lang")) {
                        this.filetype = attributes.getValue(i);
                        if (this.filetype != null) {
                            this.filetype = this.filetype.toLowerCase();
                        }
                        if (!this.filetype.equalsIgnoreCase("JAVA")) {
                            this.filetype = this.filetype.substring(0, this.filetype.length() < 3 ? this.filetype.length() : 3);
                        }
                    }
                    ++i;
                }
                this.sourceFile = this.createIFile(this.filename, this.filetype);
                this.offsetFile = this.createIFile(this.filename, this.filetype + ".lxml");
                this.sourceFileStringBuilder = new StringBuilder();
                this.offsetFileStringBuilder = new StringBuilder();
                this.offsetFileStringBuilder.append("<table>");
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String elementName) throws SAXException {
        switch (elementName) {
            case "td": {
                ++this.dataNodeIndex;
                this.offsetFileStringBuilder.append("</td>");
                break;
            }
            case "tr": {
                this.offsetFileStringBuilder.append("</tr>");
                break;
            }
            case "table": {
                IResourceUtils.setIFileContents((IFile)this.sourceFile, (String)this.sourceFileStringBuilder.toString(), (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
                this.offsetFileStringBuilder.append("</table>");
                IResourceUtils.setIFileContents((IFile)this.offsetFile, (String)this.offsetFileStringBuilder.toString(), (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
                break;
            }
        }
    }

    @Override
    public void characters(char[] characters, int start, int length) throws SAXException {
        String content = new String(characters, start, length);
        if (this.dataNodeIndex < 3) {
            this.offsetFileStringBuilder.append(content);
        } else {
            this.sourceFileStringBuilder.append(content);
        }
    }
}

