/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.Validator;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@Deprecated
public class SetOptionsHandlerOptionPage
extends TitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Combo idioptsCombo;
    private Combo idiadataCombo;
    private Combo idilcCombo;
    private Combo idilcobCombo;
    private Combo idilcoboCombo;
    private Combo idisysdbCombo;
    private Combo idilangxCombo;
    private Combo idilpliCombo;
    private Combo idilplieCombo;
    private Map<String, List<String>> dds;
    private boolean refresh = false;

    public SetOptionsHandlerOptionPage(Shell parentShell, Map<String, List<String>> _dds) {
        super(parentShell);
        this.dds = _dds;
    }

    private boolean idioptsCheck() {
        String idioptsName = this.idioptsCombo.getText().trim();
        if (idioptsName.isEmpty() || Validator.validateDataSetName((String)idioptsName) || Validator.validateDataSetNameWithMember((String)idioptsName)) {
            return true;
        }
        this.setMessage(Messages.SetOptionsHandler_Invalid_IDIOPTS_DSN_specified, 3);
        return false;
    }

    public boolean close() {
        if (this.getReturnCode() == 1) {
            return super.close();
        }
        if (!this.idioptsCheck()) {
            return false;
        }
        if (!SetOptionsHandlerOptionPage.checkCombo(this, this.idiadataCombo, Messages.SetOptionsHandler_Invalid_IDIADATA_DSN_specified)) {
            return false;
        }
        if (!SetOptionsHandlerOptionPage.checkCombo(this, this.idilcCombo, Messages.SetOptionsHandler_Invalid_IDILC_DSN_specified)) {
            return false;
        }
        if (!SetOptionsHandlerOptionPage.checkCombo(this, this.idilcobCombo, Messages.SetOptionsHandler_Invalid_IDILCOB_DSN_specified)) {
            return false;
        }
        if (!SetOptionsHandlerOptionPage.checkCombo(this, this.idilcoboCombo, Messages.SetOptionsHandler_Invalid_IDILCOBO_DSN_specified)) {
            return false;
        }
        if (!SetOptionsHandlerOptionPage.checkCombo(this, this.idisysdbCombo, Messages.SetOptionsHandler_Invalid_IDISYSDB_DSN_specified)) {
            return false;
        }
        if (!SetOptionsHandlerOptionPage.checkCombo(this, this.idilangxCombo, Messages.SetOptionsHandler_Invalid_IDILANGX_DSN_specified)) {
            return false;
        }
        if (!SetOptionsHandlerOptionPage.checkCombo(this, this.idilpliCombo, Messages.SetOptionsHandler_Invalid_IDILPLI_DSN_specified)) {
            return false;
        }
        if (!SetOptionsHandlerOptionPage.checkCombo(this, this.idilplieCombo, Messages.SetOptionsHandler_Invalid_IDILPLIE_DSN_specified)) {
            return false;
        }
        this.dds.put("IDIOPTS", Arrays.asList(this.idioptsCombo.getText().trim().toUpperCase().split("[ ,]+")));
        Activator.cache("IDIOPTS", this.idioptsCombo.getText().trim().toUpperCase());
        SetOptionsHandlerOptionPage.persistComboValue(this.dds, this.idiadataCombo, "IDIADATA");
        SetOptionsHandlerOptionPage.persistComboValue(this.dds, this.idilcCombo, "IDILC");
        SetOptionsHandlerOptionPage.persistComboValue(this.dds, this.idilcobCombo, "IDILCOB");
        SetOptionsHandlerOptionPage.persistComboValue(this.dds, this.idilcoboCombo, "IDILCOBO");
        SetOptionsHandlerOptionPage.persistComboValue(this.dds, this.idisysdbCombo, "IDISYSDB");
        SetOptionsHandlerOptionPage.persistComboValue(this.dds, this.idilangxCombo, "IDILANGX");
        SetOptionsHandlerOptionPage.persistComboValue(this.dds, this.idilpliCombo, "IDILPLI");
        SetOptionsHandlerOptionPage.persistComboValue(this.dds, this.idilplieCombo, "IDILPLIE");
        return super.close();
    }

    private static void persistComboValue(Map<String, List<String>> dds, Combo combo2, String key) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(combo2);
        Activator.cache(key, combo2.getText().trim().toUpperCase());
        ArrayList<String> splitValues = new ArrayList<String>(Arrays.asList(combo2.getText().trim().toUpperCase().split("[ ,]+")));
        List oldValues = dds.put(key, splitValues);
        if (oldValues != null) {
            for (String oldValue : oldValues) {
                if (splitValues.contains(oldValue)) continue;
                splitValues.add(oldValue);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText(Messages.SetOptionsHandler_Refresh);
        this.setButtonLayoutData(ok);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetOptionsHandlerOptionPage.this.setRefresh(true);
                SetOptionsHandlerOptionPage.this.okPressed();
            }
        });
    }

    private static void restoreComboValues(String comboId, Combo combo2, Map<String, List<String>> dds) {
        List<String> list = dds.get(comboId);
        if (list == null) {
            combo2.setItems(new String[0]);
        } else {
            combo2.setItems(list.toArray(new String[0]));
            if (combo2.getItemCount() > 0) {
                combo2.select(0);
            }
        }
        int i = 0;
        for (String values : Activator.retrieve(comboId)) {
            if (combo2.indexOf(values) != -1) {
                combo2.remove(values);
            }
            combo2.add(values, i);
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.SetOptionsHandler_Title);
        this.setTitle(Messages.SetOptionsHandler_FA_Invocation_Options_Page);
        this.setMessage(Messages.SetOptionsHandler_Specify_the_following_FA_options);
        Composite mainComp = GUI.composite((Composite)parent, (Layout)GridLayoutFactory.fillDefaults().numColumns(2).create(), (Object)GridDataFactory.fillDefaults().create());
        Group optsGroup = GUI.group((Composite)mainComp, (String)Messages.SetOptionsHandler_Fault_Analyzer_Options, (Layout)GridLayoutFactory.fillDefaults().numColumns(2).create(), (Object)GridDataFactory.fillDefaults().create(), (int)4);
        Group sidefileGroup = GUI.group((Composite)mainComp, (String)Messages.SetOptionsHandler_Side_File_Options, (Layout)GridLayoutFactory.fillDefaults().numColumns(2).create(), (Object)GridDataFactory.fillDefaults().create(), (int)4);
        GUI.label.left((Composite)optsGroup, (String)Messages.SetOptionsHandler_FA_Option_DSN, (Object)GridDataFactory.fillDefaults().span(1, 1).align(16384, 128).create());
        this.idioptsCombo = GUI.combo.editable((Composite)optsGroup, (Object)GridDataFactory.fillDefaults().hint(200, -1).create());
        SetOptionsHandlerOptionPage.restoreComboValues("IDIOPTS", this.idioptsCombo, this.dds);
        this.idiadataCombo = SetOptionsHandlerOptionPage.createLabelledComboAndRestoreInput(sidefileGroup, "IDIADATA", this.dds);
        this.idilcCombo = SetOptionsHandlerOptionPage.createLabelledComboAndRestoreInput(sidefileGroup, "IDILC", this.dds);
        this.idilcobCombo = SetOptionsHandlerOptionPage.createLabelledComboAndRestoreInput(sidefileGroup, "IDILCOB", this.dds);
        this.idilcoboCombo = SetOptionsHandlerOptionPage.createLabelledComboAndRestoreInput(sidefileGroup, "IDILCOBO", this.dds);
        this.idisysdbCombo = SetOptionsHandlerOptionPage.createLabelledComboAndRestoreInput(sidefileGroup, "IDISYSDB", this.dds);
        this.idilangxCombo = SetOptionsHandlerOptionPage.createLabelledComboAndRestoreInput(sidefileGroup, "IDILANGX", this.dds);
        this.idilpliCombo = SetOptionsHandlerOptionPage.createLabelledComboAndRestoreInput(sidefileGroup, "IDILPLI", this.dds);
        this.idilplieCombo = SetOptionsHandlerOptionPage.createLabelledComboAndRestoreInput(sidefileGroup, "IDILPLIE", this.dds);
        return super.createDialogArea(parent);
    }

    private static Combo createLabelledComboAndRestoreInput(Group group, final String labelId, final Map<String, List<String>> dds) {
        GUI.label.left((Composite)group, (String)(labelId + " DSN"), (Object)GridDataFactory.fillDefaults().span(1, 1).align(16384, 128).create());
        final Combo combo2 = GUI.combo.editable((Composite)group, (Object)GridDataFactory.fillDefaults().hint(200, -1).create());
        combo2.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text != null) {
                    e.text = e.text.toUpperCase();
                }
            }
        });
        combo2.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                int index;
                if (event.keyCode == 127 && (index = combo2.getSelectionIndex()) > -1) {
                    Activator.removeValue(labelId, combo2.getItem(index));
                    dds.remove(labelId, combo2.getItem(index));
                    combo2.remove(index);
                }
            }
        });
        SetOptionsHandlerOptionPage.restoreComboValues(labelId, combo2, dds);
        return combo2;
    }

    private static boolean checkCombo(SetOptionsHandlerOptionPage h, Combo combo2, String error) {
        String tempIdiadataName = combo2.getText().trim().toUpperCase();
        if (tempIdiadataName.isEmpty() || SetOptionsHandlerOptionPage.checkListingDSN(tempIdiadataName)) {
            return true;
        }
        h.setErrorMessage(error);
        return false;
    }

    private static boolean checkListingDSN(String values) {
        String[] value = values.split("[ ,]+");
        int i = 0;
        while (i < value.length) {
            String dsn = value[i];
            if (!Validator.validateDataSetName((String)dsn, (boolean)true)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }
}

