/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditorInput;
import com.ibm.etools.fa.pdtclient.ui.report.RefreshReportHandler;
import com.ibm.etools.fa.pdtclient.ui.report.SetOptionsHandlerOptionPage;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.HandlerUtil;

@Deprecated
public class SetOptionsHandler
extends AbstractHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(SetOptionsHandler.class);
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.command.setoptions";

    private static HashMap<String, List<String>> get_options(String address, String service, String dataset, String member) {
        IFile _opts = FAResourceUtils.getFaultEntryFolder((String)address, (String)service, (String)dataset, (String)member).getFile(member + ".opt");
        Objects.requireNonNull(_opts, "Must provide a non-null _opts.");
        HashMap<String, List<String>> dds = new HashMap<String, List<String>>();
        if (!_opts.exists()) {
            return dds;
        }
        XMLMemento memento = MementoUtils.loadXMLMementoFromIFile((IFile)_opts, (boolean)true, (Charset)StandardCharsets.UTF_8);
        if (memento == null) {
            return dds;
        }
        Object object = memento.getChildren("Listing");
        int n = ((IMemento[])object).length;
        int n2 = 0;
        while (n2 < n) {
            IMemento listing = object[n2];
            String[] spec = listing.getTextData().trim().split(" ", 2);
            if (spec.length == 2) {
                if (!dds.containsKey(spec[1])) {
                    dds.put(spec[1], new ArrayList());
                }
                if (spec[0].isEmpty()) {
                    logger.error((Object)("get_options: leading string from split was empty, other string was : '" + spec[1].trim() + "'"));
                } else if (spec[0].contains("(")) {
                    dds.get(spec[1]).add(spec[0].substring(0, spec[0].indexOf("(")));
                } else {
                    dds.get(spec[1]).add(spec[0]);
                }
            } else {
                logger.error((Object)("get_options: listing memento text didn't split into 2 pieces: '" + listing.getTextData().trim() + "'"));
            }
            ++n2;
        }
        object = memento.getChildren("li");
        int n3 = ((IMemento[])object).length;
        n2 = 0;
        while (n2 < n3) {
            String dsn;
            IMemento li = object[n2];
            String dd = li.getString("class");
            if (!dds.containsKey(dd)) {
                dds.put(dd, new ArrayList());
            }
            if ((dsn = li.getTextData()) != null && !dsn.isEmpty() && !dds.get(dd).contains(dsn)) {
                dds.get(dd).add(dsn);
            }
            ++n2;
        }
        ArrayList<String> empties = new ArrayList<String>();
        for (Map.Entry<String, List<String>> dd : dds.entrySet()) {
            if (!dd.getValue().isEmpty()) continue;
            empties.add(dd.getKey());
        }
        for (String empty : empties) {
            dds.remove(empty);
        }
        ArrayList<String> nonlistings = new ArrayList<String>();
        for (Map.Entry entry : dds.entrySet()) {
            if (((String)entry.getKey()).startsWith("IDIL") || ((String)entry.getKey()).equalsIgnoreCase("IDIADATA") || ((String)entry.getKey()).equalsIgnoreCase("IDISYSDB") || ((String)entry.getKey()).equalsIgnoreCase("IDIOPTS")) continue;
            nonlistings.add((String)entry.getKey());
        }
        for (String string : nonlistings) {
            dds.remove(string);
        }
        return dds;
    }

    static String getOptions(String address, String service, String dataset, String member) {
        return SetOptionsHandler.getOptions(SetOptionsHandler.get_options(address, service, dataset, member));
    }

    private static String getOptions(Map<String, List<String>> dds) {
        if (!dds.isEmpty()) {
            String string;
            Object opts = "";
            if (dds.containsKey("IDIOPTS") && dds.get("IDIOPTS").size() > 0) {
                opts = "IDIOPTS(" + dds.remove("IDIOPTS").get(0) + ")";
            }
            if ((string = dds.toString().trim().replace("{}", "")).isEmpty()) {
                return opts;
            }
            String datasets = (String)opts + "DATASETS" + string.replaceAll("=\\[", "(").replaceAll("\\]", ")").replace("{", "(").replace("}", ")");
            return datasets;
        }
        return "";
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPDHost host = null;
        String address = null;
        String port = null;
        String dataset = null;
        String member = null;
        if ("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor".equals(HandlerUtil.getActivePartId((ExecutionEvent)event))) {
            IEditorInput editorInput = ((FaultAnalyzerReportEditor)HandlerUtil.getActivePart((ExecutionEvent)event)).getEditorInput();
            if (editorInput instanceof FaultAnalyzerReportEditorInput) {
                host = ((FaultAnalyzerReportEditorInput)editorInput).getHost();
            }
            report_file = ((IFileEditorInput)editorInput).getFile().getProjectRelativePath();
            address = report_file.segment(0);
            port = report_file.segment(1);
            dataset = report_file.segment(2);
            member = report_file.segment(3);
        } else if ("com.ibm.etools.fa.pdtclient.ui.reports".equals(HandlerUtil.getActivePartId((ExecutionEvent)event)) && HandlerUtil.getCurrentSelection((ExecutionEvent)event) != null) {
            Map selection = (Map)((TreeSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).getFirstElement();
            report_file = FACorePlugin.getRoot().getFile((String)selection.get(ViewParser.class.getCanonicalName())).getProjectRelativePath();
            logger.debug((Object)report_file);
            address = report_file.segment(0);
            port = report_file.segment(1);
            dataset = report_file.removeFileExtension().segment(2);
            member = (String)selection.get("FAULT_ID");
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            if (activePart instanceof ReportsList) {
                ReportsList r = (ReportsList)activePart;
                host = r.getDisplayedResource().getHost();
            }
        }
        HashMap<String, List<String>> dds = SetOptionsHandler.get_options(address, port, dataset, member);
        SetOptionsHandlerOptionPage options_page = new SetOptionsHandlerOptionPage(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), dds);
        if (options_page.open() == 0) {
            XMLMemento opts = XMLMemento.createWriteRoot((String)"ul");
            opts.putString("class", "dd");
            logger.trace((Object)"saving options dds: ");
            for (Map.Entry entry : dds.entrySet()) {
                String dd = (String)entry.getKey();
                for (String ds : (List)entry.getValue()) {
                    if (ds.isEmpty()) continue;
                    logger.trace((Object)("saving options dd " + ds));
                    IMemento li = opts.createChild("li");
                    li.putString("class", dd);
                    li.putTextData(ds);
                }
            }
            if (options_page.isRefresh()) {
                RefreshReportHandler.refresh(host, address, port, dataset, member);
            }
        }
        return null;
    }

    @Deprecated
    private static void saveOptsFile(IFile opts_file, XMLMemento opts) {
        if (!opts_file.exists()) {
            if (!opts_file.getParent().exists()) {
                IResourceUtils.mkdirs((IFolder)FACorePlugin.getRoot().getFolder(opts_file.getParent().getProjectRelativePath()), (IProgressMonitor)new NullProgressMonitor());
            }
            IResourceUtils.createEmptyIFile((IFile)opts_file, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        }
        MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)opts, (IFile)opts_file, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
    }
}

