/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReportSetup {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.report";
    private static final PDLogger logger = PDLogger.get(ReportSetup.class);
    public static final String SECTION_SUMMARY = "Summary";
    public static final String SECTION_SYNOPSIS = "Synopsis";
    public static final String SECTION_EVENT_SUMMARY = "EventSummary";
    public static final String SECTION_EVENT_DETAILS = "EventDetails";
    public static final String SUBSECTION_EVENT_NUMBER = "Event";
    public static final String SUBSUBSECTION_EVENT_PROGRAM_STATUS_WORD_31 = "ProgramStatusWord31";
    public static final String SUBSUBSECTION_EVENT_PROGRAM_STATUS_WORD_64 = "ProgramStatusWord64";
    public static final String SECTION_ABEND_JOB_INFO = "AbendJobInfo";
    public static final String SECTION_SYSTEM_WIDE_INFO = "SystemWideInfo";
    public static final String SUBSECTION_OPEN_FILES = "OpenFiles";
    public static final String SUBSECTION_CICS_INFO = "CICSInfo";
    public static final String SUBSECTION_DB2_INFO = "DB2Info";
    public static final String SUBSECTION_IMS_INFO = "IMSInfo";
    public static final String SUBSECTION_MESSAGES = "Messages";
    public static final String SUBSECTION_STORAGE_AREAS = "StorageAreas";
    public static final String SUBSECTION_LE_HEAP_ANALYSIS = "LEHeapAnalysis";
    public static final String SUBSECTION_JAVA_INFO = "JavaInfo";
    public static final String SECTION_OPTIONS_IN_EFFECT = "OptionsInEffect";
    public static final String SECTION_PROLOG = "Prolog";
    public static final String SECTION_EPILOG = "Epilog";
    public static final String SECTION_USER = "User";
    public static final String SECTION_SECTION = "section";
    public static final String SECTION_MINIDUMP = "Minidump";
    public static final String LINK_ANCHOR = "a";
    public static final String ERROR_ANCHOR = "error";
    public static final String DIVIDER = "^--------------------------------------------------------------------------------$";
    public static final String TAG = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.tag";
    public static final String SECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.section";
    public static final String SUBSECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsection";
    public static final String SUBSUBSECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsection";
    public static final String SUBSUBSUBSECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsubsection";
    public static final String LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link";
    public static final String ERROR = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.error";
    public static final String ADDR_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.addr";
    public static final String STMT_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.stmt";
    public static final String LINE_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.line";
    public static final String CODE_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.code";
    public static final String EVNT_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.evnt";
    public static final String PSW_31_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.psw31";
    public static final String PSW_64_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.psw64";
    public static final String OPEN_FILE_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.openFile";
    public static final String CICS_ASYNC_INFO_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsAsync";
    public static final String CICS_TRACE_LINK_ANALYSIS_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsTraceLinkAnalysis";
    public static final String CICS_TRANSACTION_STORAGE_FILTER_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsTransactionStorageFilter";
    public static final String MD_TD = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.td";
    public static final String MD_TR = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.tr";
    public static final String MD_EBCDIC = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.ebcdic";
    public static final String MD_TABLE = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.table";
    public static final String MD_ASID = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.asid";
    public static final String USERNOTE = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.usernote";
    public static final String ANNOTATION_SECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.section.annotation";
    public static final String ANNOTATION_SUBSECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsection.annotation";
    public static final String ANNOTATION_SUBSUBSECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsection.annotation";
    public static final String ANNOTATION_SUBSUBSUBSECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsubsection.annotation";
    public static final String ANNOTATION_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.annotation";
    public static final String ANNOTATION_ERROR = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.error.annotation";
    public static final String ANNOTATION_ADDR_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.addr.annotation";
    public static final String ANNOTATION_STMT_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.stmt.annotation";
    public static final String ANNOTATION_LINE_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.line.annotation";
    public static final String ANNOTATION_CODE_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.code.annotation";
    public static final String ANNOTATION_EVNT_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.evnt.annotation";
    public static final String ANNOTATION_PSW_31_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.psw31.annotation";
    public static final String ANNOTATION_PSW_64_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.psw64.annotation";
    public static final String ANNOTATION_OPEN_FILE_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.openFile.annotation";
    public static final String ANNOTATION_CICS_ASYNC_INFO_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsAsync.annotation";
    public static final String ANNOTATION_CICS_TRACE_LINK_ANALYSIS_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsTraceLinkAnalysis.annotation";
    public static final String ANNOTATION_CICS_TRANSACTION_STORAGE_FILTER_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsTransactionStorageFilter.annotation";
    public static final String ANNOTATION_MD_TD = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.td.annotation";
    public static final String ANNOTATION_MD_TR = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.tr.annotation";
    public static final String ANNOTATION_MD_EBCDIC = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.ebcdic.annotation";
    public static final String ANNOTATION_MD_TABLE = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.table.annotation";
    public static final String ANNOTATION_MD_ASID = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.dump.asid.annotation";
    public static final String MARKER_SECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.section.marker";
    public static final String MARKER_SUBSECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsection.marker";
    public static final String MARKER_SUBSUBSECTION = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsection.marker";
    public static final String MARKER_ADDR_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.addr.marker";
    public static final String MARKER_STMT_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.stmt.marker";
    public static final String MARKER_LINE_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.line.marker";
    public static final String MARKER_CODE_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.code.marker";
    public static final String MARKER_EVNT_LINK = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.evnt.marker";
    public static final String MARKER_USERNOTE = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.usernote.marker";
    private static final String[] SECTION_TAG_LABELS = new String[]{"Prolog", "Summary", "Synopsis", "EventSummary", "EventDetails", "SystemWideInfo", "AbendJobInfo", "OptionsInEffect", "Epilog", "User"};
    private static final HashSet<String> SECTION_TAGS = new HashSet<String>(Arrays.asList(SECTION_TAG_LABELS));
    private static final String[] SUBSECTION_TAG_LABELS = new String[]{"Event", "OpenFiles", "CICSInfo", "DB2Info", "IMSInfo", "Messages", "StorageAreas", "LEHeapAnalysis", "JavaInfo"};
    private static final HashSet<String> SUBSECTION_TAGS = new HashSet<String>(Arrays.asList(SUBSECTION_TAG_LABELS));
    private static final String[] SUBSUBSECTION_TAG_LABELS = new String[]{"ProgramStatusWord31", "ProgramStatusWord64"};
    private static final HashSet<String> SUBSUBSECTION_TAGS = new HashSet<String>(Arrays.asList(SUBSUBSECTION_TAG_LABELS));
    private static final String[] LINK_TAG_LABELS = new String[]{"a"};
    private static final HashSet<String> LINK_TAGS = new HashSet<String>(Arrays.asList(LINK_TAG_LABELS));
    private static final String[] ERROR_TAG_LABELS = new String[]{"error"};
    private static final HashSet<String> ERROR_TAGS = new HashSet<String>(Arrays.asList(ERROR_TAG_LABELS));
    private static final String LMODPATTERN = "LMOD=(";
    private static final String ERRORPATTPARSING = "*Error in parsing*";
    private static final HashMap<String, String> ANNOTATION_LOCALISATIONS = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(ReportSetup.SECTION_SUMMARY, Messages.FaultAnalyzerReportEditor_Section_Summary);
            this.put(ReportSetup.SECTION_SYNOPSIS, Messages.FaultAnalyzerReportEditor_Section_Synopsis);
            this.put(ReportSetup.SECTION_EVENT_SUMMARY, Messages.FaultAnalyzerReportEditor_Section_Event_summary);
            this.put(ReportSetup.SECTION_EVENT_DETAILS, Messages.FaultAnalyzerReportEditor_Section_Event_details);
            this.put(ReportSetup.SUBSECTION_EVENT_NUMBER, Messages.FaultAnalyzerReportEditor_Subsection_Event_number);
            this.put(ReportSetup.SUBSUBSECTION_EVENT_PROGRAM_STATUS_WORD_31, Messages.ReportSetup_PSW);
            this.put(ReportSetup.SUBSUBSECTION_EVENT_PROGRAM_STATUS_WORD_64, Messages.ReportSetup_PSW);
            this.put(ReportSetup.SECTION_ABEND_JOB_INFO, Messages.FaultAnalyzerReportEditor_Section_Abend_job_info);
            this.put(ReportSetup.SECTION_SYSTEM_WIDE_INFO, Messages.FaultAnalyzerReportEditor_Section_System_wide_info);
            this.put(ReportSetup.SUBSECTION_OPEN_FILES, Messages.FaultAnalyzerReportEditor_Subsection_Open_files);
            this.put(ReportSetup.SUBSECTION_CICS_INFO, Messages.FaultAnalyzerReportEditor_Subsection_CICS_info);
            this.put(ReportSetup.SUBSECTION_DB2_INFO, Messages.FaultAnalyzerReportEditor_Subsection_DB2_info);
            this.put(ReportSetup.SUBSECTION_IMS_INFO, Messages.FaultAnalyzerReportEditor_Subsection_IMS_info);
            this.put(ReportSetup.SUBSECTION_MESSAGES, Messages.FaultAnalyzerReportEditor_Subsection_Messages);
            this.put(ReportSetup.SUBSECTION_STORAGE_AREAS, Messages.FaultAnalyzerReportEditor_Subsection_Storage_areas);
            this.put(ReportSetup.SUBSECTION_LE_HEAP_ANALYSIS, Messages.FaultAnalyzerReportEditor_Subsection_LE_Heap_analysis);
            this.put(ReportSetup.SUBSECTION_JAVA_INFO, Messages.FaultAnalyzerReportEditor_Subsection_Java_info);
            this.put(ReportSetup.SECTION_OPTIONS_IN_EFFECT, Messages.FaultAnalyzerReportEditor_Section_Options_in_effect);
            this.put(ReportSetup.SECTION_PROLOG, Messages.FaultAnalyzerReportEditor_Section_Prolog);
            this.put(ReportSetup.SECTION_EPILOG, Messages.FaultAnalyzerReportEditor_Section_Epilog);
            this.put(ReportSetup.SECTION_MINIDUMP, Messages.ReportsList_Minidump);
            this.put(ReportSetup.SECTION_USER, Messages.ReportsList_User);
        }
    };

    public static String getTagType(String tagLabel) {
        block26: {
            String levelNumber;
            Matcher matcher;
            if (tagLabel == null || !tagLabel.startsWith(SECTION_SECTION) || !(matcher = Pattern.compile("section(\\d+)").matcher(tagLabel)).find()) break block26;
            switch (levelNumber = matcher.group(1)) {
                case "1": {
                    return SECTION;
                }
                case "2": {
                    return SUBSECTION;
                }
                case "3": {
                    return SUBSUBSECTION;
                }
                case "4": {
                    return SUBSUBSUBSECTION;
                }
            }
            logger.info((Object)("unhandled section level: " + levelNumber + " formatting as a h3 / subsubsection."));
            return SUBSUBSECTION;
        }
        String tagType = null;
        if (SECTION_TAGS.contains(tagLabel)) {
            tagType = SECTION;
        } else if (SUBSECTION_TAGS.contains(tagLabel)) {
            tagType = SUBSECTION;
        } else if (SUBSUBSECTION_TAGS.contains(tagLabel)) {
            tagType = SUBSUBSECTION;
        } else if (LINK_TAGS.contains(tagLabel)) {
            tagType = LINK;
        } else if (ERROR_TAGS.contains(tagLabel)) {
            tagType = ERROR;
        } else {
            String errorMessage = String.format("Unknown tagLabel = '%s' found in fault entry report, skipping", tagLabel);
            logger.warn((Object)errorMessage);
        }
        return tagType;
    }

    public static String getSectionName(String annotationText) {
        Objects.requireNonNull(annotationText, "Must specify a non-null annotationText.");
        Object sectionName = null;
        Pattern tagPattern = Pattern.compile("<(.+?)>");
        Matcher tagMatcher = tagPattern.matcher(annotationText);
        if (tagMatcher.find() && tagMatcher.groupCount() == 1) {
            String tagLabel = tagMatcher.group(1);
            Object suffix = "";
            Object moduleName = "";
            Pattern eventNumberPattern = Pattern.compile("Event number=(\\d+)");
            Matcher eventNumberMatcher = eventNumberPattern.matcher(tagLabel);
            if (eventNumberMatcher.matches() && eventNumberMatcher.groupCount() == 1) {
                tagLabel = SUBSECTION_EVENT_NUMBER;
                suffix = " " + eventNumberMatcher.group(1);
            }
            try {
                if (tagLabel.contains(LMODPATTERN)) {
                    String[] tokens = tagLabel.split("=", tagLabel.length());
                    tagLabel = SUBSECTION_EVENT_NUMBER;
                    suffix = " " + tokens[1].split(" ")[0];
                    moduleName = " " + tokens[tokens.length - 1];
                }
            }
            catch (Exception ex) {
                moduleName = ERRORPATTPARSING;
            }
            if (tagLabel.startsWith(SECTION_SECTION)) {
                Matcher matcher = Pattern.compile("section\\d+\\s*id=\".+?\"\\s*title=\"(.+)\"\\s*").matcher(tagLabel);
                if (matcher.find() && (sectionName = matcher.group(1)) != null) {
                    Matcher matcher2;
                    if (((String)sectionName).endsWith(":")) {
                        sectionName = ((String)sectionName).substring(0, ((String)sectionName).length() - 1);
                    }
                    if ((matcher2 = Pattern.compile("(.+) at Address .+").matcher((CharSequence)sectionName)).find()) {
                        sectionName = matcher2.group(1);
                    }
                }
            } else {
                sectionName = ANNOTATION_LOCALISATIONS.get(tagLabel) + (String)suffix + (String)moduleName;
            }
        }
        return sectionName;
    }
}

