/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListDisplayedResource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.PDHostJhost;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.dialog.SystemLookupDialog;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IFileEditorInput;

public class ReportProviderDisplayTranslator {
    private static final PDLogger logger = PDLogger.get(ReportProviderDisplayTranslator.class);
    private static Map<String, Charset> mappings = new HashMap<String, Charset>();

    public static void disposeMappingFor(Set<IFileEditorInput> editorInputs) {
        logger.trace(new Object[]{"cleared codepage mappings...", editorInputs});
        for (IFileEditorInput in : editorInputs) {
            if (in == null) continue;
            mappings.remove(ReportProviderDisplayTranslator.getFaultEntryDirectoryPathString(in.getFile()));
        }
    }

    @Deprecated
    public static String translateTextForDisplay(IFile element, String textData) {
        return ReportProviderDisplayTranslator.translateTextForDisplay(null, element, textData);
    }

    public static String translateTextForDisplay(IPDHost host, IFile element, String textData) {
        Objects.requireNonNull(element, "Must provide a non-null Ifile element.");
        if (textData == null) {
            return null;
        }
        Charset codePageFromHost = ReportProviderDisplayTranslator.getCodePageFromHost(host, element);
        if (codePageFromHost == null) {
            logger.error((Object)"Codepage is null. using english.");
            codePageFromHost = FARL.CHARSET_ENGLISH;
        }
        int beforeLength = textData.length();
        String[] lines = textData.split("\n");
        StringBuilder out = new StringBuilder();
        logger.trace((Object)("selected codepage: " + String.valueOf(codePageFromHost) + " | contains unicode=" + codePageFromHost.contains(StandardCharsets.UTF_8) + " | contains ascii: " + codePageFromHost.contains(Charset.forName("US-ASCII"))));
        Charset intialValue = FARL.CHARSET_ENGLISH;
        if (codePageFromHost.contains(StandardCharsets.UTF_8) || codePageFromHost.contains(Charset.forName("US-ASCII"))) {
            intialValue = StandardCharsets.US_ASCII;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ByteBuffer convertedToUserCodePage = intialValue.encode(line);
            CharBuffer roundtripped = codePageFromHost.decode(convertedToUserCodePage);
            out.append(roundtripped.toString() + "\n");
            ++n2;
        }
        if (out.length() < beforeLength) {
            out.append("\n");
        }
        if (beforeLength != out.length()) {
            logger.trace(new Object[]{"length changed! before length was ", beforeLength, " |  after length is", out.length()});
        }
        return out.toString();
    }

    private static String getFaultEntryDirectoryPathString(IFile element) {
        IContainer parent;
        if (element != null && (parent = element.getParent()) != null) {
            return parent.getProjectRelativePath().toString();
        }
        return "";
    }

    private static Charset getCodePageFromHost(IPDHost host, IFile element) {
        Objects.requireNonNull(element, "Must provide a non-null Ifile element.");
        Charset codePage = CharsetResponseHelper.getLanguageCharset();
        if (host != null) {
            return Charset.forName(host.getCodePage());
        }
        ReportsListDisplayedResource r = ReportsListDisplayedResource.getResourceFromElement(host, element);
        if (r == null) {
            return codePage;
        }
        String fePath = ReportProviderDisplayTranslator.getFaultEntryDirectoryPathString(element);
        PDTreeContentHolder.addNewConnectionsDefined();
        PDTCCui.getDefault().loadSysInfoTreeContents();
        if (mappings.containsKey(fePath)) {
            codePage = mappings.get(fePath);
        } else {
            List findPDHosts = PDHostJhost.findPDHosts((String)r.getResourceAddress(), (int)Integer.parseInt(r.getResourceService()), (boolean)true);
            switch (findPDHosts.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    codePage = Charset.forName(((IPDHost)findPDHosts.get(0)).getCodePage());
                    break;
                }
                default: {
                    if (PDHostJhost.doAllHostsHaveSameCodePage((List)findPDHosts)) {
                        codePage = Charset.forName(((IPDHost)findPDHosts.get(0)).getCodePage());
                        break;
                    }
                    if (!PDDialogs.openQuestion((String)Messages.ReportProviderDisplayTranslator_0, (String)MessageFormat.format(Messages.ReportProviderDisplayTranslator_1, r.getResourceAddress(), r.getResourceService()))) break;
                    codePage = (Charset)PDDialogs.openDialogAndRunCallbackIfOk((Window)SystemLookupDialog.getSystemLookupDialogForHosts((String)r.getResourceAddress()), (PDDialogs.WindowCallback)new PDDialogs.WindowCallback<SystemLookupDialog, Charset>(){

                        public Charset call(SystemLookupDialog dialog) {
                            return Charset.forName(dialog.getSelectedHost().getCodePage());
                        }
                    }, (Object)codePage);
                }
            }
        }
        if (!mappings.containsKey(fePath)) {
            mappings.put(fePath, codePage);
        }
        return codePage;
    }
}

