/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditorInput;
import com.ibm.etools.fa.pdtclient.ui.report.ReportProviderDisplayTranslator;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class ReportProvider
extends AbstractDocumentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.report.provider";
    private static final PDLogger logger = PDLogger.get(ReportProvider.class);
    private HashMap<IFileEditorInput, XMLMemento> mementos = new HashMap();

    private void create_memento(IFileEditorInput editorInput) {
        if (this.mementos.containsKey(editorInput) && this.mementos.get(editorInput) != null) {
            return;
        }
        this.mementos.put(editorInput, MementoUtils.loadXMLMementoFromIFile((IFile)editorInput.getFile(), (boolean)true, (Charset)StandardCharsets.UTF_8));
    }

    private static Position getPositionFromMemento(IMemento m) {
        Objects.requireNonNull(m, "Must provide a non-null Memento.");
        Integer offset = m.getInteger("offset");
        Integer length = m.getInteger("length");
        return new Position(offset.intValue(), length.intValue());
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            ResourceMarkerAnnotationModel mod = new ResourceMarkerAnnotationModel((IResource)input.getFile());
            IMemento memento = this.get_memento(input);
            if (memento != null && "faml".equals(memento.getType())) {
                Position position;
                Position position2;
                String annotationType;
                Integer offset;
                ProjectionAnnotation projection;
                String annotationType2;
                String tag;
                Integer offset2;
                IMemento[] iMementoArray = memento.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.section");
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento section = iMementoArray[n2];
                    if (section.getInteger("length") > 1) {
                        offset2 = section.getInteger("offset");
                        mod.addAnnotation(new Annotation("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.section.annotation", true, section.getString("tag")), new Position(offset2.intValue(), 0));
                        ProjectionAnnotation projection2 = new ProjectionAnnotation();
                        projection2.setText(section.getString("tag"));
                        mod.addAnnotation((Annotation)projection2, ReportProvider.getPositionFromMemento(section));
                    }
                    ++n2;
                }
                iMementoArray = memento.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsection");
                n = iMementoArray.length;
                n2 = 0;
                while (n2 < n) {
                    IMemento subsection = iMementoArray[n2];
                    if (subsection.getInteger("length") > 1) {
                        offset2 = subsection.getInteger("offset");
                        tag = subsection.getString("tag");
                        annotationType2 = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsection.annotation";
                        Position position3 = new Position(offset2.intValue(), 0);
                        mod.addAnnotation(new Annotation(annotationType2, true, tag), position3);
                        ProjectionAnnotation projection3 = new ProjectionAnnotation();
                        projection3.setText(tag);
                        mod.addAnnotation((Annotation)projection3, ReportProvider.getPositionFromMemento(subsection));
                    }
                    ++n2;
                }
                iMementoArray = memento.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsection");
                n = iMementoArray.length;
                n2 = 0;
                while (n2 < n) {
                    IMemento subsubsection = iMementoArray[n2];
                    if (subsubsection.getInteger("length") > 1) {
                        mod.addAnnotation(new Annotation("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsection.annotation", true, subsubsection.getString("tag")), ReportProvider.getPositionFromMemento(subsubsection));
                        projection = new ProjectionAnnotation();
                        tag = subsubsection.getString("tag");
                        offset = subsubsection.getInteger("offset");
                        if (tag.contains("ProgramStatusWord31")) {
                            annotationType = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.psw31.annotation";
                            position2 = ReportProvider.getPositionFromMemento(subsubsection);
                        } else if (tag.contains("ProgramStatusWord64")) {
                            annotationType = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.psw64.annotation";
                            position2 = ReportProvider.getPositionFromMemento(subsubsection);
                        } else {
                            annotationType = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsection.annotation";
                            position2 = new Position(offset.intValue(), 0);
                        }
                        mod.addAnnotation(new Annotation(annotationType, true, tag), position2);
                        projection.setText(tag);
                        mod.addAnnotation((Annotation)projection, ReportProvider.getPositionFromMemento(subsubsection));
                    }
                    ++n2;
                }
                iMementoArray = memento.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsubsection");
                n = iMementoArray.length;
                n2 = 0;
                while (n2 < n) {
                    IMemento subsubsubsection = iMementoArray[n2];
                    mod.addAnnotation(new Annotation("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsubsection.annotation", true, subsubsubsection.getString("tag")), ReportProvider.getPositionFromMemento(subsubsubsection));
                    projection = new ProjectionAnnotation();
                    tag = subsubsubsection.getString("tag");
                    offset = subsubsubsection.getInteger("offset");
                    annotationType = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsubsection.annotation";
                    position2 = new Position(offset.intValue(), 0);
                    mod.addAnnotation(new Annotation(annotationType, true, tag), position2);
                    projection.setText(tag);
                    mod.addAnnotation((Annotation)projection, ReportProvider.getPositionFromMemento(subsubsubsection));
                    ++n2;
                }
                iMementoArray = memento.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link");
                n = iMementoArray.length;
                n2 = 0;
                while (n2 < n) {
                    IMemento link = iMementoArray[n2];
                    position = ReportProvider.getPositionFromMemento(link);
                    tag = link.getString("tag");
                    annotationType2 = tag.startsWith("<a href=\"CicsTransactionStorageSummary:") ? "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsTransactionStorageFilter.annotation" : (tag.startsWith("<a href=\"CicsTraceLinkAnalysis:") ? "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsTraceLinkAnalysis.annotation" : (tag.startsWith("<a href=\"CicsAsyncInfo:") ? "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsAsync.annotation" : (tag.startsWith("<a href=\"OpenFile:") ? "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.openFile.annotation" : (tag.startsWith("<a href=\"ADDR:") ? "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.addr.annotation" : (tag.startsWith("<a href=\"AbendCode:") ? "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.code.annotation" : (tag.startsWith("<a href=\"Event:") ? "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.evnt.annotation" : (tag.contains(" RLinen=") ? "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.line.annotation" : (tag.contains(" RStmtn=") ? "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.stmt.annotation" : "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.annotation"))))))));
                    Annotation annotation = new Annotation(annotationType2, true, tag);
                    mod.addAnnotation(annotation, position);
                    ++n2;
                }
                iMementoArray = memento.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.error");
                n = iMementoArray.length;
                n2 = 0;
                while (n2 < n) {
                    IMemento error = iMementoArray[n2];
                    position = ReportProvider.getPositionFromMemento(error);
                    tag = error.getString("tag");
                    Annotation annotation = new Annotation("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.error.annotation", true, tag);
                    mod.addAnnotation(annotation, position);
                    ++n2;
                }
            }
            return mod;
        }
        return null;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IFileEditorInput input;
        IMemento memento;
        if (element instanceof IFileEditorInput && (memento = this.get_memento(input = (IFileEditorInput)element)) != null && "faml".equals(memento.getType())) {
            Document doc;
            String textData = memento.getTextData();
            if (Preferences.isUseCodePageFromHostEnabled()) {
                IPDHost host = null;
                if (input instanceof FaultAnalyzerReportEditorInput) {
                    FaultAnalyzerReportEditorInput farei = (FaultAnalyzerReportEditorInput)input;
                    host = farei.getHost();
                }
                doc = new Document(ReportProviderDisplayTranslator.translateTextForDisplay(host, input.getFile(), textData));
            } else {
                doc = new Document(textData);
            }
            ReportProvider.addPositionsToDocument(doc, "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.section", memento);
            ReportProvider.addPositionsToDocument(doc, "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsection", memento);
            ReportProvider.addPositionsToDocument(doc, "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsection", memento);
            ReportProvider.addPositionsToDocument(doc, "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link", memento);
            ReportProvider.addPositionsToDocument(doc, "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.error", memento);
            return doc;
        }
        return new Document();
    }

    private static void addPositionsToDocument(Document doc, String category, IMemento memento) {
        doc.addPositionCategory(category);
        IMemento[] iMementoArray = memento.getChildren(category);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            ReportProvider.addPositionToDocument(doc, category, child);
            ++n2;
        }
    }

    private static void addPositionToDocument(Document doc, String category, IMemento m) {
        Integer offset = m.getInteger("offset");
        Integer length = m.getInteger("length");
        int docLength = doc.getLength();
        if (offset < 0) {
            offset = 0;
            logger.trace(new Object[]{"had to set offset to 0 from ", offset});
        }
        if (length > docLength) {
            length = docLength;
            logger.trace(new Object[]{"reduced length from ", length, " to ", docLength});
        }
        if (offset + length > docLength) {
            length = docLength - offset;
            logger.trace(new Object[]{"reduced length to ", length, " so offset ", offset, " + ", length, " is <= ", docLength});
        }
        Position position = new Position(offset.intValue(), length.intValue());
        if (offset <= docLength && length <= docLength && offset + length <= docLength) {
            try {
                doc.addPosition(category, position);
            }
            catch (BadLocationException | BadPositionCategoryException e) {
                logger.warn(e);
            }
        } else {
            logger.trace(new Object[]{"document length is ", docLength, " so can't use offset ", offset, " length: ", length});
        }
    }

    protected void disconnected() {
        HashSet e = new HashSet();
        Iterator elements = this.getConnectedElements();
        while (elements.hasNext()) {
            e.add(elements.next());
        }
        for (IFileEditorInput o : this.mementos.keySet()) {
            if (e.contains(o)) continue;
            this.mementos.put(o, null);
        }
        ReportProviderDisplayTranslator.disposeMappingFor(this.mementos.keySet());
        super.disconnected();
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        monitor.done();
    }

    public IMemento get_memento(IFileEditorInput element) {
        this.create_memento(element);
        return (IMemento)this.mementos.get(element);
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }
}

