/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.ui.report.AFAReportLinkDetector;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor;
import com.ibm.etools.fa.pdtclient.ui.report.ReportPageMenuHider;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.TextEditor;

public class ReportPage
extends TextEditor {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final PDLogger logger = PDLogger.get(ReportPage.class);
    private FaultAnalyzerReportEditor editor;
    private IMenuListener menu_listener = ReportPageMenuHider.getMenuItemRemover();

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.addMenuListener(this.menu_listener);
        this.menu_listener.menuAboutToShow(menu);
    }

    public ReportPage(FaultAnalyzerReportEditor _editor) {
        this.editor = _editor;
    }

    public void createPartControl(Composite parent) {
        IAnnotationModel visual;
        IAnnotationModel model;
        super.createPartControl(parent);
        ProjectionSupport support = new ProjectionSupport((ProjectionViewer)this.getSourceViewer(), this.getAnnotationAccess(), this.getSharedColors());
        final LinkedHashMap<Annotation, Position> errorAnnotations = new LinkedHashMap<Annotation, Position>();
        support.setAnnotationPainterDrawingStrategy(new AnnotationPainter.IDrawingStrategy(){

            public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
                if (gc != null) {
                    Point lao = textWidget.getLocationAtOffset(offset);
                    String text2 = ReportPage.this.editor.label_provider.getText(annotation) + "...";
                    gc.setForeground(Display.getCurrent().getSystemColor(16));
                    gc.drawText(text2, lao.x, lao.y, true);
                    Point point = gc.textExtent(text2);
                    gc.drawRectangle(lao.x, lao.y, point.x, point.y);
                } else {
                    textWidget.redraw();
                    StyledText text3 = textWidget;
                    ReportPage.processErrorAnnotations(text3, errorAnnotations);
                    ReportPage.this.highlightHeader(text3);
                }
            }
        });
        support.install();
        ((ProjectionViewer)this.getSourceViewer()).doOperation(19);
        ProjectionAnnotationModel projection = ((ProjectionViewer)this.getSourceViewer()).getProjectionAnnotationModel();
        if (projection == null) {
            this.logger.debug((Object)"No ProjectionAnnotationModel");
        }
        if ((model = ((ProjectionViewer)this.getSourceViewer()).getAnnotationModel()) == null) {
            this.logger.debug((Object)"No AnnotationModel");
        }
        if ((visual = ((ProjectionViewer)this.getSourceViewer()).getVisualAnnotationModel()) == null) {
            this.logger.debug((Object)"No VisualAnnotationModel");
        }
        if (projection != null && model != null) {
            Iterator annotations = model.getAnnotationIterator();
            while (annotations.hasNext()) {
                Annotation annotation = (Annotation)annotations.next();
                if (annotation instanceof ProjectionAnnotation) {
                    projection.addAnnotation(annotation, model.getPosition(annotation));
                    continue;
                }
                if (!annotation.getType().startsWith("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.error")) continue;
                errorAnnotations.put(annotation, model.getPosition(annotation));
            }
        }
        this.getSourceViewer().setRangeIndication(0, 1, true);
        StyledText text2 = this.getSourceViewer().getTextWidget();
        ReportPage.processErrorAnnotations(text2, errorAnnotations);
        this.highlightHeader(text2);
    }

    private void highlightHeader(StyledText text2) {
        String string = text2.getText();
        List<String> headerList = this.editor.getHeaderList();
        for (String header : headerList) {
            Pattern p = Pattern.compile(Pattern.quote(header));
            Matcher m = p.matcher(string);
            while (m.find()) {
                StyleRange style1 = new StyleRange();
                style1.start = m.start();
                style1.length = m.end() - m.start();
                style1.fontStyle = 3;
                style1.foreground = new Color(0, 162, 232);
                text2.setStyleRange(style1);
            }
        }
    }

    private static void processErrorAnnotations(StyledText styledText, Map<Annotation, Position> strongAnnotations) {
        for (Map.Entry<Annotation, Position> entry : strongAnnotations.entrySet()) {
            StyleRange style = new StyleRange();
            style.start = entry.getValue().getOffset();
            style.length = entry.getValue().getLength();
            style.fontStyle = 3;
            style.foreground = new Color(255, 0, 0);
            styledText.setStyleRange(style);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.getEditorSite().getShell().setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.pdtclient.ui.font"));
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.pdtclient.ui.font"));
        this.setSourceViewerConfiguration(new SourceViewerConfiguration(){

            public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
                return new IHyperlinkDetector[]{new AFAReportLinkDetector(ReportPage.this, ReportPage.this.editor)};
            }

            public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
                return new MultipleHyperlinkPresenter(new RGB(0, 0, 255));
            }

            public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
                return 0;
            }

            public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
                return new ITextHover(){

                    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
                        IAnnotationModel model = ReportPage.this.getDocumentProvider().getAnnotationModel((Object)ReportPage.this.getEditorInput());
                        Iterator annotations = model.getAnnotationIterator();
                        while (annotations.hasNext()) {
                            Position position;
                            Annotation annotation = (Annotation)annotations.next();
                            if (!annotation.getType().startsWith("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link") || !(position = model.getPosition(annotation)).includes(hoverRegion.getOffset())) continue;
                            String link_text = annotation.getText();
                            if (link_text.contains("\"")) {
                                return link_text.substring(link_text.indexOf(34) + 1, link_text.lastIndexOf(34)).replace("\n", "");
                            }
                            return link_text;
                        }
                        return null;
                    }

                    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
                        return new Region(offset, 1);
                    }
                };
            }
        });
        this.configureSourceViewerDecorationSupport(this.getSourceViewerDecorationSupport((ISourceViewer)viewer));
        return viewer;
    }

    public String getPartName() {
        return this.getEditorInput().getName();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.getSourceViewer().getSelectionProvider();
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor");
    }

    protected boolean isBlockSelectionModeSupported() {
        return true;
    }

    public boolean isChangeInformationShowing() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEditorInputModifiable() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return false;
    }

    protected boolean isLineNumberRulerVisible() {
        return true;
    }

    protected boolean isOverviewRulerVisible() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }
}

