/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.loader.FATPQueries;
import com.ibm.etools.fa.pdtclient.ui.report.OpenAddressHandler;
import com.ibm.etools.fa.pdtclient.ui.report.OpenEventHandler;
import com.ibm.etools.fa.pdtclient.ui.report.OpenSourceHandler;
import com.ibm.etools.fa.pdtclient.ui.report.impl.CICSAsyncInfo;
import com.ibm.etools.fa.pdtclient.ui.report.impl.CICSTraceLinkAnalysis;
import com.ibm.etools.fa.pdtclient.ui.report.impl.CICSTransactionStorageFilter;
import com.ibm.etools.fa.pdtclient.ui.report.psw.ProgramStatusWord;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.BaseStartPosType;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.lookup.view.LookedUpMessage;
import com.ibm.pdtools.common.component.lookup.view.LookupView;
import com.ibm.pdtools.common.component.lookup.view.OpenCodeHandler;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDUserTask;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;

public class ReportHyperlink
implements IHyperlink {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ReportHyperlink.class);
    public static final String PROTOCOL_ADDR = "ADDR";
    public static final String PROTOCOL_CODE = "AbendCode";
    public static final String PROTOCOL_EVNT = "Event";
    public static final String PROTOCOL_LINE = "SrcLine";
    public static final String PROTOCOL_STMT = "SrcStmt";
    public static final String PROTOCOL_OPEN_FILE = "OpenFile";
    public static final String PROTOCOL_CICS_ASYNC_INFO = "CicsAsyncInfo";
    public static final String PROTOCOL_CICS_TRACE_LINK_ANALYSIS = "CicsTraceLinkAnalysis";
    public static final String PROTOCOL_CICS_TRANSACTION_STORAGE_FILTER = "CicsTransactionStorageSummary";
    private IRegion region;
    private String text;
    private String base;
    private IDocument document;
    private IAnnotationModel model;

    public ReportHyperlink(IRegion region, String _text, String _base) {
        this.region = region;
        this.text = _text;
        this.base = _base;
    }

    public ReportHyperlink(IRegion region, String _text, String _base, IDocument document, IAnnotationModel model) {
        this(region, _text, _base);
        this.document = document;
        this.model = model;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        int beginIndex = this.text.indexOf(":") + 1;
        int toIndex = this.text.lastIndexOf("\"");
        if (beginIndex >= 0 && toIndex >= 0) {
            return this.text.substring(beginIndex, toIndex).trim().replaceAll("\n", " ");
        }
        return "";
    }

    public String getTypeLabel() {
        int beginIndex = this.text.indexOf("\"") + 1;
        int toIndex = this.text.indexOf(":");
        if (beginIndex >= 0 && toIndex >= 0) {
            return this.text.substring(beginIndex, toIndex).trim();
        }
        return "";
    }

    private static String getAttributeValue(String hyperlinkText, String attribute) {
        Pattern attributePattern = Pattern.compile(attribute + "=(\\S+)");
        Matcher attributeMatcher = attributePattern.matcher(hyperlinkText);
        String value = null;
        if (attributeMatcher.find() && attributeMatcher.groupCount() == 1 && (value = attributeMatcher.group(1)).length() < 1) {
            value = null;
        }
        return value;
    }

    private void loadOpenFile(String hostname, int port) {
        HashMap<String, String> parameters;
        block18: {
            String positionTypeString;
            String position;
            parameters = new HashMap<String, String>();
            parameters.put("param.hostname", hostname);
            parameters.put("param.port", Integer.toString(port));
            String hyperlinkText = this.getHyperlinkText();
            if (PDLoggerJhost.isTraceEnabled()) {
                logger.trace((Object)("hyperlink=" + hyperlinkText));
            }
            String resource = ReportHyperlink.getAttributeValue(hyperlinkText, "resource");
            parameters.put("param.resource", resource);
            String template = ReportHyperlink.getAttributeValue(hyperlinkText, "templateDSN");
            if (template != null) {
                parameters.put("param.template", template);
            }
            if ((position = ReportHyperlink.getAttributeValue(hyperlinkText, "position")) != null) {
                parameters.put("param.position", position);
            }
            if ((positionTypeString = ReportHyperlink.getAttributeValue(hyperlinkText, "positionType")) == null) break block18;
            switch (positionTypeString) {
                case "KEY": {
                    parameters.put("param.position.type", BaseStartPosType.KEY.name());
                    break;
                }
                case "RBA": {
                    parameters.put("param.position.type", BaseStartPosType.RBA.name());
                    break;
                }
                case "RECORD_NUMBER": {
                    parameters.put("param.position.type", BaseStartPosType.RECORD_NUMBER.name());
                    break;
                }
            }
        }
        parameters.put("param.createhost", Boolean.toString(false));
        try {
            EclipseUtils.executeParameterizedCommand((String)"com.ibm.etools.fm.ui.editor.openFormattedAPI", parameters);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            logger.error(e);
            PDDialogs.openErrorThreadSafe((String)Messages.FileManagerAPIFactory_ImplementationUnavailableTitle, (String)Messages.FileManagerAPIFactory_ImplementationUnavailable);
        }
    }

    public void open() {
        final String type = this.getTypeLabel();
        IPath path = FACorePlugin.getRoot().getFile(this.base).getProjectRelativePath();
        final String address = path.segment(0);
        final String service = path.segment(1);
        final String dataset = path.segment(2);
        final String member = path.segment(3);
        final String addr = this.getHyperlinkText();
        PDUserTask.createAndRunJob((String)"", (PDUserTask.PDUserJobFunction)new PDUserTask.PDUserJobFunction(){

            public void run(IProgressMonitor monitor) {
                if (type.equals(ReportHyperlink.PROTOCOL_ADDR)) {
                    OpenAddressHandler.open(address, service, dataset, member, addr);
                } else if (type.equals(ReportHyperlink.PROTOCOL_CODE)) {
                    ReportHyperlink.this.onCodeLinkClicked(address, Integer.valueOf(service), addr);
                } else if (type.equals(ReportHyperlink.PROTOCOL_EVNT)) {
                    String event = "<Event number=" + addr + ">";
                    OpenEventHandler.openEvent(address, service, dataset, member, event);
                } else if (type.equals(ReportHyperlink.PROTOCOL_OPEN_FILE)) {
                    ReportHyperlink.this.loadOpenFile(address, Integer.valueOf(service));
                } else if (type.equals(ReportHyperlink.PROTOCOL_CICS_ASYNC_INFO)) {
                    CICSAsyncInfo.showAsyncInfo(FAResourceUtils.getFaultEntryFolder((String)address, (String)service, (String)dataset, (String)member).getFile(member + ".async.info.xml"), monitor);
                } else if (type.equals(ReportHyperlink.PROTOCOL_CICS_TRACE_LINK_ANALYSIS)) {
                    CICSTraceLinkAnalysis.showCICSTrace(FAResourceUtils.getFaultEntryFolder((String)address, (String)service, (String)dataset, (String)member).getFile(member + ".cicslink.info.xml"), monitor);
                } else if (type.equals(ReportHyperlink.PROTOCOL_CICS_TRANSACTION_STORAGE_FILTER)) {
                    CICSTransactionStorageFilter.filterStorage(ReportHyperlink.this.document, ReportHyperlink.this.model);
                } else if (ReportHyperlink.this.text.contains(" RLinen=")) {
                    OpenSourceHandler.openSourceWithLine(address, service, dataset, member, addr);
                } else if (ReportHyperlink.this.text.contains(" RStmtn=")) {
                    OpenSourceHandler.openSourceWithStmt(address, service, dataset, member, addr);
                } else if (ReportHyperlink.this.text.contains("ProgramStatusWord31") || ReportHyperlink.this.text.contains("ProgramStatusWord64")) {
                    ProgramStatusWord.openPSW(ReportHyperlink.this.document, ReportHyperlink.this.text, ReportHyperlink.this.region);
                }
            }
        });
    }

    protected void onCodeLinkClicked(final String host, final Integer port, String codeLink) {
        final String code = codeLink.split("Value=")[1];
        Map results = OpenCodeHandler.openCode((String)code);
        if (results == null || results.isEmpty()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    LookedUpMessage lookedUpMessage = FATPQueries.lookupMessageCode(host, port.toString(), (IProgressMonitor)new NullProgressMonitor(), code);
                    if (lookedUpMessage.isValid()) {
                        LookupView view2 = LookupView.showView();
                        view2.addExplanationAndDisplayIt(lookedUpMessage);
                    } else {
                        logger.error((Object)lookedUpMessage.getErrorMessage());
                        PDDialogs.openErrorThreadSafe((String)Messages.ReportHyperlink_failedLookupTitle, (String)lookedUpMessage.getErrorMessage());
                    }
                }
            });
        }
    }
}

