/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.PreferencesAnalysis;
import com.ibm.etools.fa.pdtclient.ui.faobjects.FaultAnalyzerParameters;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.loader.FATPQueries;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPAdapter;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob2;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPResponseHandler;
import com.ibm.etools.fa.pdtclient.ui.fatp.FAUserTask;
import com.ibm.etools.fa.pdtclient.ui.report.DeferredModel;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditorInput;
import com.ibm.etools.fa.pdtclient.ui.report.MinidumpProvider;
import com.ibm.etools.fa.pdtclient.ui.report.ReportSetup;
import com.ibm.etools.fa.pdtclient.ui.report.SourceFileParser;
import com.ibm.etools.fa.pdtclient.ui.report.impl.ViewIditrace;
import com.ibm.etools.fa.pdtclient.ui.report.impl.ViewSavedReport;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.impl.ClearCachedReport;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDUserTask;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RefreshReportHandler
extends SkeletonHandler {
    private static final PDLogger logger = PDLogger.get(RefreshReportHandler.class);
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String EMPTY_MINIDUMP_ROW = "<tr><td>00000000</td><td>00000000</td><td>00000000</td><td>00000000</td><td>00000000</td><td>00000000</td><td>00000000</td><td>00000000</td></tr>\n";
    private static List<Job> jobs = new ArrayList<Job>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readMinidumpLine(InputStream reader, byte new_line, Charset charset) {
        ByteArrayOutputStream line = new ByteArrayOutputStream(1024);
        try {
            int read = reader.read();
            if (read == -1) {
                return null;
            }
            while (read != new_line && read != -1) {
                line.write((byte)(read & 0xFF));
                read = reader.read();
            }
        }
        catch (IOException read) {
            // empty catch block
        }
        try {
            return line.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static void saveMinidumpResponse(IProgressMonitor _mon, String requestUri, File responseTempFile, String responseMediaType, String content_encoding, Charset responseCharset, String requestHeaderIfMatch, String requestHeaderHost, String requestEntityHeaderHost) {
        block71: {
            logger.trace((Object)MessageFormat.format("Saving using {0} {1}", responseMediaType, responseCharset));
            IFolder fault_entry = FACorePlugin.getRoot().getFolder(requestHeaderHost.replace(":", "/") + requestUri.replace("(", "/").replace(")", ""));
            if (!fault_entry.exists()) {
                IResourceUtils.mkdirs((IFolder)fault_entry, (IProgressMonitor)new NullProgressMonitor());
            }
            if (content_encoding.equals("identity") || content_encoding.equals("")) {
                if (responseMediaType.isEmpty() || responseMediaType.equals("text/xml") || responseMediaType.equals("text/plain")) {
                    try {
                        _mon.subTask(Messages.RefreshReportHandler_Reading_response_contents);
                        String entity_tag = requestHeaderIfMatch;
                        String extension = "";
                        if (!entity_tag.equals("\"minidump\"")) break block71;
                        extension = "mdml";
                        IFile dump_file = FACorePlugin.getRoot().getFile(fault_entry.getProjectRelativePath().append(requestUri.replaceFirst(".*\\(", "").replace(")", "")).addFileExtension(extension));
                        try {
                            Throwable throwable = null;
                            Object var14_25 = null;
                            try (BufferedReader isr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(responseTempFile), responseCharset));){
                                String line = isr.readLine();
                                if (line != null) {
                                    if (!dump_file.exists()) {
                                        dump_file.create((InputStream)new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)), true, null);
                                    }
                                    int memory = (int)(Runtime.getRuntime().freeMemory() / 10L);
                                    StringBuilder sb = new StringBuilder(memory);
                                    while (line != null) {
                                        sb.append(line).append('\n');
                                        if (sb.length() >= memory) {
                                            dump_file.appendContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)), true, false, _mon);
                                            sb = new StringBuilder(memory);
                                        }
                                        line = isr.readLine();
                                    }
                                    dump_file.appendContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)), true, false, _mon);
                                    try {
                                        FileEditorInput input = new FileEditorInput(dump_file);
                                        String host = requestEntityHeaderHost;
                                        MinidumpProvider provider = new MinidumpProvider();
                                        provider.setHost(host);
                                        provider.deferred_setup(input, _mon);
                                        DeferredModel inputAnnotationModel = (DeferredModel)provider.getAnnotationModel(input);
                                        if (inputAnnotationModel != null) {
                                            inputAnnotationModel.update_markers();
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.warn((Throwable)e);
                                    }
                                }
                                isr.close();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (CoreException e) {
                            logger.warn((Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        logger.warn((Throwable)e);
                    }
                } else if (responseMediaType.equals("application/minidump")) {
                    try {
                        _mon.subTask(Messages.RefreshReportHandler_Saving_binary_minidump);
                        String entity_tag = requestHeaderIfMatch;
                        String extension = "";
                        if (!entity_tag.equals("\"minidump\"")) break block71;
                        extension = "mdml";
                        IFile dump_file = FACorePlugin.getRoot().getFile(fault_entry.getProjectRelativePath().append(requestUri.replaceFirst(".*\\(", "").replace(")", "")).addFileExtension(extension));
                        try {
                            if (!dump_file.exists()) {
                                dump_file.create((InputStream)new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)), true, null);
                            }
                            Throwable e = null;
                            Object var14_27 = null;
                            try (FileInputStream fis = new FileInputStream(responseTempFile);){
                                byte new_line = responseCharset.encode("\n").get();
                                String line = RefreshReportHandler.readMinidumpLine(fis, new_line, responseCharset);
                                File tmpfile = File.createTempFile("fabin", "dump");
                                Throwable throwable = null;
                                Object var20_43 = null;
                                try (BufferedWriter tfw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpfile), StandardCharsets.UTF_8));){
                                    if (line != null) {
                                        while (line != null) {
                                            if (line.startsWith("<table")) {
                                                if (line.endsWith("/>")) {
                                                    tfw.append(line.substring(0, line.length() - 2).concat(">\n"));
                                                    int i = 0;
                                                    while (i < 128) {
                                                        tfw.append(EMPTY_MINIDUMP_ROW);
                                                        ++i;
                                                    }
                                                    tfw.append("</table>\n");
                                                } else {
                                                    tfw.append(line).append('\n');
                                                    byte[] b = new byte[4096];
                                                    if (fis.read(b) != 4096) {
                                                        fis.close();
                                                        ((Writer)tfw).close();
                                                        tmpfile.delete();
                                                        throw new RuntimeException(Messages.RefreshReportHandler_CorruptedBinaryMinidumpDownload);
                                                    }
                                                    int i = 0;
                                                    while (i < 128) {
                                                        tfw.append("<tr>");
                                                        int j = 0;
                                                        while (j < 32) {
                                                            tfw.append("<td>");
                                                            int int_index = i * 32 + j;
                                                            String hex = Integer.toHexString((b[int_index] & 0xFF) << 24 | (b[int_index + 1] & 0xFF) << 16 | (b[int_index + 2] & 0xFF) << 8 | b[int_index + 3] & 0xFF).toUpperCase();
                                                            int l2 = hex.length();
                                                            while (l2 < 8) {
                                                                tfw.append('0');
                                                                ++l2;
                                                            }
                                                            tfw.append(hex);
                                                            tfw.append("</td>");
                                                            j += 4;
                                                        }
                                                        tfw.append("</tr>\n");
                                                        ++i;
                                                    }
                                                }
                                            } else {
                                                tfw.append(line).append('\n');
                                            }
                                            line = RefreshReportHandler.readMinidumpLine(fis, new_line, responseCharset);
                                        }
                                    }
                                    fis.close();
                                    ((Writer)tfw).close();
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                                throwable = null;
                                var20_43 = null;
                                try (FileInputStream tfis = new FileInputStream(tmpfile);){
                                    dump_file.setContents((InputStream)tfis, true, false, _mon);
                                    tfis.close();
                                    tmpfile.delete();
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Throwable throwable) {
                                if (e == null) {
                                    e = throwable;
                                } else if (e != throwable) {
                                    e.addSuppressed(throwable);
                                }
                                throw e;
                            }
                            try {
                                FileEditorInput input = new FileEditorInput(dump_file);
                                MinidumpProvider provider = new MinidumpProvider();
                                provider.setHost("Host");
                                provider.deferred_setup(input, _mon);
                                DeferredModel inputModel = (DeferredModel)provider.getAnnotationModel(input);
                                if (inputModel != null) {
                                    inputModel.update_markers();
                                }
                                logger.trace((Object)Messages.RefreshReportHandler_FinishedPrepareMinidump);
                            }
                            catch (Exception e2) {
                                logger.warn((Throwable)e2);
                            }
                        }
                        catch (CoreException e) {
                            logger.warn((Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        logger.warn((Throwable)e);
                    }
                }
            }
        }
    }

    private static void saveReportSection(IProgressMonitor progressMonitor, String jobName, IDocument master, IFolder fault_entry, String[] xmlTags, String fileName) throws IOException {
        progressMonitor.subTask(jobName);
        XMLMemento main_doc = RefreshReportHandler.vivisect(master, xmlTags);
        File tmpfile = File.createTempFile("fareport", "section");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpfile), StandardCharsets.UTF_8));){
            main_doc.save((Writer)writer);
            main_doc = null;
            ((Writer)writer).close();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        IFile file = fault_entry.getFile(fileName);
        try {
            try {
                if (!file.exists()) {
                    IResourceUtils.createEmptyIFile((IFile)file, (boolean)true, (IProgressMonitor)progressMonitor);
                }
                throwable2 = null;
                Object var10_14 = null;
                try (FileInputStream source = new FileInputStream(tmpfile);){
                    file.setContents((InputStream)source, true, false, null);
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            catch (CoreException e) {
                logger.warn((Throwable)e);
                tmpfile.delete();
            }
        }
        finally {
            tmpfile.delete();
        }
    }

    private static void extractSidefileDDs(IProgressMonitor _mon, FindReplaceDocumentAdapter frdoc, IDocument master, XMLMemento dds) {
        _mon.subTask(Messages.RefreshReportHandler_Interpreting_report_sidefile_DDs);
        int offset = 0;
        dds.putString("class", "dd");
        int docLength = master.getLength();
        try {
            IRegion listing;
            while (offset < docLength && (listing = frdoc.find(offset, "<Listing>[\\w\\W]*?</Listing>", true, true, false, true)) != null) {
                StringReader reader = new StringReader(master.get(listing.getOffset(), listing.getLength()));
                try {
                    dds.copyChild((IMemento)XMLMemento.createReadRoot((Reader)reader));
                }
                catch (WorkbenchException e) {
                    logger.warn((Throwable)e);
                    break;
                }
                master.replace(listing.getOffset(), listing.getLength(), "");
                offset = listing.getOffset() + 1;
            }
        }
        catch (BadLocationException e) {
            logger.warn((Throwable)e);
        }
    }

    private static void removeIdilangxSections(FindReplaceDocumentAdapter frdoc, IDocument master) {
        int offset = 0;
        IRegion idilangx = null;
        int docLength = master.getLength();
        try {
            while (offset < docLength && (idilangx = frdoc.find(offset, "<IDILANGX>[\\w\\W]*?</IDILANGX>", true, true, false, true)) != null) {
                master.replace(idilangx.getOffset(), idilangx.getLength(), "");
                offset = idilangx.getOffset() + 1;
            }
        }
        catch (BadLocationException e) {
            logger.warn((Throwable)e);
        }
    }

    private static void removeHeadingTags(FindReplaceDocumentAdapter frdoc, IDocument master) {
        int offset = 0;
        int docLength = master.getLength();
        try {
            IRegion heading;
            while (offset < docLength && (heading = frdoc.find(offset, "<H.>", true, true, false, true)) != null) {
                master.replace(heading.getOffset(), heading.getLength(), "");
                offset = heading.getOffset() + 1;
            }
        }
        catch (BadLocationException e) {
            logger.warn((Throwable)e);
        }
    }

    private static void extractDDs(FindReplaceDocumentAdapter frdoc, IDocument master, XMLMemento dds) {
        int offset = 0;
        IRegion dd = null;
        int docLength = master.getLength();
        try {
            while (offset < docLength && (dd = frdoc.find(offset, "<ul class=\"dd\">[\\w\\W]*?</ul>", true, true, false, true)) != null) {
                XMLMemento m = MementoUtils.loadXMLMementoFromString((String)master.get(dd.getOffset(), dd.getLength()));
                if (m != null) {
                    IMemento[] iMementoArray = m.getChildren("li");
                    int n = iMementoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento li = iMementoArray[n2];
                        dds.copyChild(li);
                        ++n2;
                    }
                    offset = dd.getOffset() + dd.getLength() + 1;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            logger.warn((Throwable)e);
        }
    }

    private static void extractCICSAsyncInfo(FindReplaceDocumentAdapter frdoc, IDocument master, IFolder fault_entry, IProgressMonitor monitor) {
        XMLMemento asyncInfos = XMLMemento.createWriteRoot((String)"asyncInfos");
        int offset = 0;
        IRegion matchingRegion = null;
        int docLength = master.getLength();
        try {
            while (offset < docLength && (matchingRegion = frdoc.find(offset, "(?sm)<asyncInfos root=\".+\".>.*?</asyncInfos>", true, true, false, true)) != null) {
                XMLMemento m = MementoUtils.loadXMLMementoFromString((String)master.get(matchingRegion.getOffset(), matchingRegion.getLength()));
                if (m != null) {
                    asyncInfos.putString("root", m.getString("root"));
                    asyncInfos.putString("rootTaskName", m.getString("rootTaskName"));
                    IMemento[] iMementoArray = m.getChildren("asyncInfo");
                    int n = iMementoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento li = iMementoArray[n2];
                        asyncInfos.copyChild(li);
                        ++n2;
                    }
                    master.replace(matchingRegion.getOffset(), matchingRegion.getLength(), "");
                    offset = matchingRegion.getOffset() + matchingRegion.getLength() + 1;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            logger.warn((Throwable)e);
        }
        IFile opt = fault_entry.getFile(fault_entry.getLocation().lastSegment() + ".async.info.xml");
        if (!opt.exists()) {
            IResourceUtils.createEmptyIFile((IFile)opt, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        }
        MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)asyncInfos, (IFile)opt, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
        try {
            opt.setHidden(true);
        }
        catch (CoreException e) {
            logger.error((Throwable)e);
        }
    }

    private static void extractCICSLinkInfo(FindReplaceDocumentAdapter frdoc, IDocument master, IFolder fault_entry, IProgressMonitor monitor) {
        IFile opt;
        XMLMemento cicslink = XMLMemento.createWriteRoot((String)"cicslink");
        int offset = 0;
        IRegion matchingRegion = null;
        int docLength = master.getLength();
        try {
            while (offset < docLength && (matchingRegion = frdoc.find(offset, "(?sm)<cicslink>.*?</cicslink>", true, true, false, true)) != null) {
                String string = master.get(matchingRegion.getOffset(), matchingRegion.getLength());
                XMLMemento m = MementoUtils.loadXMLMementoFromString((String)string);
                if (m == null) continue;
                IMemento[] iMementoArray = m.getChildren();
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    cicslink.copyChild(child);
                    ++n2;
                }
                cicslink.putTextData(m.getTextData());
                master.replace(matchingRegion.getOffset(), matchingRegion.getLength(), "");
                docLength = master.getLength();
                offset = matchingRegion.getOffset() + matchingRegion.getLength() + 1;
            }
        }
        catch (BadLocationException e) {
            logger.warn((Throwable)e);
        }
        if (!(opt = fault_entry.getFile(fault_entry.getLocation().lastSegment() + ".cicslink.info.xml")).exists()) {
            IResourceUtils.createEmptyIFile((IFile)opt, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        }
        MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)cicslink, (IFile)opt, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
        try {
            opt.setHidden(true);
        }
        catch (CoreException e) {
            logger.error((Throwable)e);
        }
    }

    private static void createReportTocFile(IProgressMonitor _mon, IFolder fault_entry, String requestUri, String extension) {
        _mon.subTask(Messages.RefreshReportHandler_Creating_report_toc_file);
        XMLMemento toc = XMLMemento.createWriteRoot((String)"faml");
        IMemento link = toc.createChild("link");
        link.putString("rel", "main");
        link.putString("href", "main.faml");
        link = toc.createChild("link");
        link.putString("rel", "event");
        link.putString("href", "event.faml");
        link = toc.createChild("link");
        link.putString("rel", "abend");
        link.putString("href", "abend.faml");
        link = toc.createChild("link");
        link.putString("rel", "system");
        link.putString("href", "system.faml");
        link = toc.createChild("link");
        link.putString("rel", "misc");
        link.putString("href", "misc.faml");
        link = toc.createChild("link");
        link.putString("rel", "option");
        link.putString("href", fault_entry.getLocation().lastSegment() + ".opt");
        link = toc.createChild("link");
        link.putString("rel", "user");
        link.putString("href", "user.faml");
        IFile report_file = FACorePlugin.getRoot().getFile(fault_entry.getProjectRelativePath().append(requestUri.replaceFirst(".*\\(", "").replace(")", "")).addFileExtension(extension));
        if (!report_file.exists()) {
            IResourceUtils.createEmptyIFile((IFile)report_file, (boolean)true, (IProgressMonitor)_mon);
        }
        MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)toc, (IFile)report_file, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)_mon);
    }

    private static void createDDFile(XMLMemento dds, IFolder fault_entry) {
        IFile opt = fault_entry.getFile(fault_entry.getLocation().lastSegment() + ".opt");
        if (!opt.exists()) {
            IResourceUtils.createEmptyIFile((IFile)opt, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        }
        MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)dds, (IFile)opt, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
    }

    private static String fixLineEndingsIfLanguageIsKorean(String contents) {
        if (CharsetResponseHelper.getLanguageCharset().equals(FARL.CHARSET_KOREAN)) {
            contents = contents.replaceAll("\\R", System.lineSeparator());
        }
        return contents;
    }

    private static void addAnnotationsToReport(Document doc, FindReplaceDocumentAdapter frdoc, AnnotationModel mod) {
        String tagPattern = "(?s)</?(\\w+?)(?:\\s\\w+=.+?)?>";
        Pattern tagLabelPattern = Pattern.compile(tagPattern);
        HashMap<String, Position> startTagMap = new HashMap<String, Position>();
        Stack<Position> reportTagStack = new Stack<Position>();
        int searchOffset = 0;
        try {
            IRegion tag = null;
            int docLength = frdoc.length();
            while (searchOffset < docLength && (tag = frdoc.find(searchOffset, tagPattern, true, true, false, true)) != null) {
                int contentOffset = tag.getOffset() + tag.getLength();
                String tagXml = doc.get(tag.getOffset(), tag.getLength());
                Matcher tagLabelMatcher = tagLabelPattern.matcher(tagXml);
                if (tagLabelMatcher.matches() && tagLabelMatcher.groupCount() == 1) {
                    String tagLabel = tagLabelMatcher.group(1);
                    String tagType = ReportSetup.getTagType(tagLabel);
                    if (startTagMap.containsKey(tagLabel)) {
                        Position startTag = (Position)startTagMap.remove(tagLabel);
                        int sectionLength = tag.getOffset() - startTag.getOffset();
                        if (tagType != null) {
                            TypedPosition position = new TypedPosition(startTag.getOffset(), sectionLength, tagType);
                            String startTagXml = doc.get(startTag.getOffset(), startTag.getLength());
                            Annotation annotation = new Annotation(tagType, true, startTagXml);
                            mod.addAnnotation(annotation, (Position)position);
                        }
                    } else if (tagType != null) {
                        startTagMap.put(tagLabel, new Position(tag.getOffset(), tag.getLength()));
                    }
                    if (tagType != null) {
                        reportTagStack.push(new Position(tag.getOffset(), tag.getLength()));
                    }
                } else {
                    String errorMessage = String.format("Tag did not properly match the expected regular expression! tagXml = '%s'", tagXml);
                    logger.warn((Object)errorMessage);
                }
                searchOffset = contentOffset;
            }
            if (!startTagMap.isEmpty()) {
                String errorMessage = String.format("%d closing tags were not found! This possibly means that the report contained XML-like strings in the storage areas\n" + String.valueOf(startTagMap), startTagMap.size());
                logger.warn((Object)errorMessage);
            }
            while (!reportTagStack.isEmpty()) {
                Position reportTag = (Position)reportTagStack.pop();
                doc.replace(reportTag.getOffset(), reportTag.getLength(), "");
            }
        }
        catch (BadLocationException e) {
            logger.warn((Object)("searchOffset = " + searchOffset), (Throwable)e);
        }
    }

    private static XMLMemento vivisect(IDocument _doc, String[] _tags) {
        AnnotationModel mod;
        Document doc;
        FindReplaceDocumentAdapter frdoc;
        block15: {
            if (_doc.getLength() == 0) {
                return XMLMemento.createWriteRoot((String)"faml");
            }
            frdoc = new FindReplaceDocumentAdapter(_doc);
            StringBuilder text2 = new StringBuilder();
            try {
                String[] stringArray = _tags;
                int n = _tags.length;
                int n2 = 0;
                while (n2 < n) {
                    String tag = stringArray[n2];
                    String sectionPattern = String.format("(?s)<%s.*?>.+?</%s>", tag, tag);
                    IRegion section = frdoc.find(0, sectionPattern, true, true, false, true);
                    if (section != null) {
                        text2.append(_doc.get(section.getOffset(), section.getLength()));
                        _doc.replace(section.getOffset(), section.getLength(), "");
                    }
                    ++n2;
                }
            }
            catch (BadLocationException e) {
                logger.warn((Throwable)e);
            }
            doc = new Document(text2.toString());
            text2 = null;
            mod = new AnnotationModel();
            mod.connect((IDocument)doc);
            frdoc = new FindReplaceDocumentAdapter((IDocument)doc);
            HashSet<String> nonaddress = new HashSet<String>();
            if (_tags[0].equals("EventSummary")) {
                try {
                    IRegion header_region = frdoc.find(0, "^-+[ -]+\\s*$", true, false, false, true);
                    if (header_region == null) break block15;
                    String header = doc.get(header_region.getOffset(), header_region.getLength());
                    Matcher columns = Pattern.compile("-+").matcher(header);
                    columns.find();
                    columns.find();
                    columns.find();
                    columns.find();
                    int mod_name = columns.start();
                    columns.find();
                    int prog_name = columns.start();
                    columns.find();
                    int ep_name = columns.start();
                    int i = doc.getLineOfOffset(header_region.getOffset()) + 1;
                    while (i < doc.getNumberOfLines()) {
                        IRegion line_region = doc.getLineInformation(i);
                        String line = doc.get(line_region.getOffset(), line_region.getLength());
                        if (!line.trim().isEmpty()) {
                            IRegion event_region;
                            int event_number_offset;
                            String column;
                            int lineLength = line.length();
                            if (lineLength >= mod_name + 8 && (column = line.substring(mod_name, mod_name + 8)).matches("\\p{XDigit}+")) {
                                nonaddress.add(column);
                            }
                            if (lineLength >= prog_name + 8 && (column = line.substring(prog_name, prog_name + 8)).matches("\\p{XDigit}+")) {
                                nonaddress.add(column);
                            }
                            if (lineLength >= ep_name + 8 && (column = line.substring(ep_name, ep_name + 8)).matches("\\p{XDigit}+")) {
                                nonaddress.add(column);
                            }
                            if ((event_number_offset = (event_region = frdoc.find(line_region.getOffset(), "\\d+", true, false, false, true)).getOffset() - line_region.getOffset()) < mod_name) {
                                String event_number = doc.get(event_region.getOffset(), event_region.getLength());
                                doc.replace(event_region.getOffset(), event_region.getLength(), "<a href=\"Event: " + event_number + "\">" + event_number + "</a>");
                            }
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (BadLocationException e) {
                    logger.warn((Throwable)e);
                }
            }
        }
        RefreshReportHandler.addAnnotationsToReport(doc, frdoc, mod);
        XMLMemento memento = XMLMemento.createWriteRoot((String)"faml");
        memento.putTextData(doc.get());
        Iterator annotations = mod.getAnnotationIterator();
        while (annotations.hasNext()) {
            Annotation annotation = (Annotation)annotations.next();
            Position position = mod.getPosition(annotation);
            IMemento child = memento.createChild(annotation.getType());
            child.putInteger("offset", position.getOffset());
            child.putInteger("length", position.getLength());
            child.putString("tag", annotation.getText());
        }
        return memento;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FATPJob downloadMinidump(String address, String service, String dataset, String member, String user) {
        URI uri = FARL.getFARLURI((String)address, (String)service, (String)dataset, (String)member);
        IFolder faultEntryFolder = FAResourceUtils.getFaultEntryFolder((String)address, (String)service, (String)dataset, (String)member);
        IFile report_path = faultEntryFolder.getFile(member + ".faml");
        int md_pages = 0;
        Object object = ViewParser.parse(report_path.getProjectRelativePath().removeLastSegments(2).addFileExtension("hfml").toString()).getList();
        int n = ((Map<String, String>[])object).length;
        int n2 = 0;
        while (n2 < n) {
            Map<String, String> i = object[n2];
            if (i.get("FAULT_ID").equals(report_path.getProjectRelativePath().removeFileExtension().lastSegment())) {
                try {
                    md_pages = Integer.parseInt((String)((HashMap)i).get("MD_PAGES"));
                }
                catch (Exception e) {
                    md_pages = 0;
                }
                break;
            }
            ++n2;
        }
        final boolean queue = md_pages > Preferences.getMinidumpQueueThreshold();
        int bytesPerMiniDumpPage = 4096;
        FATPJob job = new FATPJob(MessageFormat.format(Messages.RefreshReportHandler_DownloadingNPages, md_pages, FATPJob.toMegabytes(md_pages * 4096)), FARL.get_minidump((URI)uri)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = super.run(monitor);
                if (queue) {
                    List<Job> list = jobs;
                    synchronized (list) {
                        jobs.remove(0);
                    }
                    if (!jobs.isEmpty()) {
                        Job job0 = jobs.get(0);
                        job0.schedule();
                    }
                }
                return status;
            }

            @Override
            protected void finalize_responses(IProgressMonitor _mon) {
                for (FATP[] request_response : this.responses) {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try {
                        FATP request = request_response[0];
                        try {
                            try (FATP response = request_response[1];){
                                if (!request.get_request_method().equals("TRACE") && !request.get_request_method().equals("DEBUG")) {
                                    if (response.is_successful_response()) {
                                        String requestUri = request.get_request_uri();
                                        File responseTempFile = response.get_temp_file();
                                        String content_encoding = response.get_entity_header("Content-Encoding");
                                        String responseEntryContentType = response.get_entity_header("Content-Type");
                                        String requestHeaderIfMatch = request.get_request_header("If-Match");
                                        String requestHeaderHost = request.getEncodedRequestHeader();
                                        String requestEntityHeaderHost = request.get_entity_header("Host");
                                        String responseMediaType = responseEntryContentType.split(";", 2)[0].trim();
                                        Charset responseCharset = CharsetResponseHelper.getCharsetFromResponseOrDefaultFromContentTypeHeader(responseEntryContentType);
                                        RefreshReportHandler.saveMinidumpResponse(_mon, requestUri, responseTempFile, responseMediaType, content_encoding, responseCharset, requestHeaderIfMatch, requestHeaderHost, requestEntityHeaderHost);
                                    } else {
                                        logger.error((Object)response.toTrace());
                                    }
                                }
                            }
                            if (request == null) continue;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (request != null) {
                                request.close();
                            }
                            throw throwable;
                        }
                        request.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                logger.trace((Object)("Finished " + Messages.RefreshReportHandler_DownloadingMinidump));
                ReportsList reportList = ReportsList.getIfOpen();
                if (reportList != null) {
                    reportList.refresh();
                }
            }
        };
        if (queue) {
            object = jobs;
            synchronized (object) {
                jobs.add(job);
            }
        }
        String dumpFilePath = report_path.getProjectRelativePath().removeFileExtension().addFileExtension("mdml").toString();
        job.setProperty(new QualifiedName("fatp", dumpFilePath), FACorePlugin.getRoot().getFile(report_path.getProjectRelativePath().removeFileExtension().addFileExtension("mdml")));
        job.set_user(user);
        if (queue) {
            Job job0 = jobs.get(0);
            if (job0 == job) {
                job.setUser(true);
                job0.schedule();
            }
        } else {
            job.setUser(true);
            job.schedule();
        }
        return job;
    }

    public static void cancelRefreshJobs() {
        for (Job job : jobs) {
            logger.trace(new Object[]{"cancelled job: ", job});
            job.cancel();
        }
    }

    private static FATPJob downloadSavedReport(String address, String port, String dataset, String member, String options, String user) {
        URI uri = FARL.getFARLURI((String)Ipv6Utils.decode((String)address), (String)port, (String)dataset, (String)member);
        if (options != null) {
            logger.trace(new Object[]{"Options are: ", options.replace(",", ",\n\t")});
        }
        LinkedHashMap<FATP, FATPResponseHandler> jobsList = new LinkedHashMap<FATP, FATPResponseHandler>();
        final IFolder fault_entry = FACorePlugin.getRoot().getFolder(Ipv6Utils.stripAndEncode((String)uri.getHost()) + "/" + uri.getPort() + FARL.getPathStringIncludingHash((URI)uri).replace("(", "/").replace(")", ""));
        final AtomicBoolean reportedRefreshedSuccessfully = new AtomicBoolean();
        jobsList.put(FARL.getRTRecordSegments((URI)uri, (String)Preferences.getNL()), new FATPResponseHandler(){

            @Override
            public void handle(IProgressMonitor monitor, FATPAdapter response) {
                ReportsList reportList;
                if (!response.is_successful_response()) {
                    logger.error((Object)response.toTrace());
                    return;
                }
                monitor.beginTask(Messages.RefreshReportHandler_DownloadSavedReport, -1);
                Charset charset = CharsetResponseHelper.getCharsetFromResponseOrDefaultFromContentTypeHeader(response.getEntityContentType());
                String contents = response.get_body(charset).replaceAll("\u0000", " ");
                monitor.worked(1);
                contents = RefreshReportHandler.fixLineEndingsIfLanguageIsKorean(contents);
                contents = contents.trim();
                if (contents.isEmpty()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Report Not Found", (String)("No saved report found under fault entry " + fault_entry.getName()));
                        }
                    });
                    return;
                }
                IFile savedReportFile = fault_entry.getFile("Saved Report.txt");
                if (!savedReportFile.exists()) {
                    IResourceUtils.createEmptyIFile((IFile)savedReportFile, (boolean)true, (IProgressMonitor)monitor);
                }
                monitor.worked(1);
                IResourceUtils.setIFileContents((IFile)savedReportFile, (String)contents, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
                if (!reportedRefreshedSuccessfully.get()) {
                    ViewSavedReport.openSavedReport(fault_entry);
                }
                if ((reportList = ReportsList.getIfOpen()) != null) {
                    reportList.refresh();
                }
            }
        });
        FATPJob2 job = new FATPJob2(Messages.RefreshReportHandler_Downloading_report, jobsList, true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                logger.trace((Object)("<<< " + Messages.RefreshReportHandler_Downloading_report));
            }
        });
        job.set_user(user);
        job.setUser(true);
        job.schedule();
        return job;
    }

    private static void checkDataSetExisting(final IPDHost host, final String address, final String port, final String dataset, final String member, final String options, final String user) {
        List<Map<String, String>> faultEntryList = ViewParser.getFaultEntrytList();
        for (final Map<String, String> map : faultEntryList) {
            final String fault_id = map.get("FAULT_ID");
            String spilled = map.get("SPILLED");
            if (!fault_id.equals(member)) continue;
            if (Messages.SPILLED_YES.equals(spilled)) {
                Job job = new Job(Messages.FATPQueries_Checks_exist){

                    protected IStatus run(IProgressMonitor monitor) {
                        Result<FATPQueries.EXISTS_STATUS> checkExistsResult = FATPQueries.checkExists(address, port, monitor, (String)map.get("MVS_DUMP_DSN"));
                        FATPQueries.EXISTS_STATUS output = (FATPQueries.EXISTS_STATUS)((Object)checkExistsResult.getOutput());
                        if (FATPQueries.EXISTS_STATUS.EXISTS.equals((Object)output)) {
                            RefreshReportHandler.downloadReport(host, address, port, dataset, member, options, user);
                        } else {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                    MessageBox dialog = new MessageBox(activeShell, 288);
                                    dialog.setText(Messages.SPILLED_WARNING);
                                    dialog.setMessage("One or more minidump pages for fault entry " + fault_id + " were spilled to XDUMP\ndata set " + (String)map.get("MVS_DUMP_DSN") + " when it was created.\nHowever, because this XDUMP data set no longer exists, reanalysis report\ninformation might be missing or incorrect.\n\nPress Ok to continue with reanalysis of this fault entry or press\nCancel to abort.");
                                    int open = dialog.open();
                                    if (32 == open) {
                                        RefreshReportHandler.downloadReport(host, address, port, dataset, member, options, user);
                                    }
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                continue;
            }
            RefreshReportHandler.downloadReport(host, address, port, dataset, member, options, user);
        }
    }

    private static FATPJob downloadReport(final IPDHost host, final String address, final String port, final String dataset, final String member, String options, final String user) {
        IFolder faultEntryFolder = FAResourceUtils.getFaultEntryFolder((String)address, (String)port, (String)dataset, (String)member);
        final IFile report_path = faultEntryFolder.getFile(member + ".faml");
        final URI uri = FARL.getFARLURI((String)Ipv6Utils.decodeAndWrap((String)address), (String)port, (String)dataset, (String)member);
        if (options != null) {
            logger.trace(new Object[]{"Options are: ", options.replace(",", ",\n\t")});
        }
        LinkedHashMap<FATP, FATPResponseHandler> jobsList = new LinkedHashMap<FATP, FATPResponseHandler>();
        final IFolder fault_entry = FACorePlugin.getRoot().getFolder(address + "/" + port + FARL.getPathStringIncludingHash((URI)uri).replace("(", "/").replace(")", ""));
        final AtomicBoolean reportedRefreshedSuccessfully = new AtomicBoolean();
        jobsList.put(FARL.refresh_report((URI)uri, (String)options, (String)Preferences.getNL()), new FATPResponseHandler(){

            @Override
            public void handle(IProgressMonitor monitor, FATPAdapter response) {
                if (!fault_entry.exists()) {
                    IResourceUtils.mkdirs((IFolder)fault_entry, (IProgressMonitor)new NullProgressMonitor());
                }
                if (response.is_successful_response()) {
                    reportedRefreshedSuccessfully.set(true);
                } else {
                    logger.error((Object)("Failed to refresh report: " + response.toTrace()));
                }
            }
        });
        jobsList.put(FARL.get_report((URI)uri, (String)Preferences.getNL()), new FATPResponseHandler(){

            @Override
            public void handle(IProgressMonitor monitor, FATPAdapter response) {
                reportedRefreshedSuccessfully.get();
                if (!response.is_successful_response()) {
                    logger.error((Object)response.toTrace());
                }
                try {
                    String[] split;
                    String contents = response.get_body(CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.getEntityContentType())).replaceAll("\u0000", " ");
                    contents = RefreshReportHandler.fixLineEndingsIfLanguageIsKorean(contents);
                    String[] stringArray = split = contents.split("\n");
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tagValue = stringArray[n2];
                        if (tagValue.contains("<H1>")) {
                            contents = contents.replaceAll(tagValue, tagValue.replace("<H1> ", "<H1>"));
                        } else if (tagValue.contains("<H2>")) {
                            Pattern p = Pattern.compile(Pattern.quote("<H2> "));
                            Matcher m = p.matcher(contents);
                            while (m.find()) {
                                contents = m.replaceAll("<H2>");
                            }
                        }
                        ++n2;
                    }
                    IFile tmp = fault_entry.getFile(fault_entry.getLocation().lastSegment() + ".tmp");
                    if (!tmp.exists()) {
                        IResourceUtils.mkdirs((IFolder)fault_entry, (IProgressMonitor)monitor);
                        IResourceUtils.createEmptyIFile((IFile)tmp, (boolean)true, (IProgressMonitor)monitor);
                    }
                    IResourceUtils.setIFileContents((IFile)tmp, (String)contents, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
                    Document master = new Document(contents);
                    contents = null;
                    FindReplaceDocumentAdapter frdoc = new FindReplaceDocumentAdapter((IDocument)master);
                    XMLMemento dds = XMLMemento.createWriteRoot((String)"ul");
                    RefreshReportHandler.extractSidefileDDs(monitor, frdoc, (IDocument)master, dds);
                    RefreshReportHandler.removeIdilangxSections(frdoc, (IDocument)master);
                    RefreshReportHandler.removeHeadingTags(frdoc, (IDocument)master);
                    RefreshReportHandler.extractDDs(frdoc, (IDocument)master, dds);
                    RefreshReportHandler.extractCICSAsyncInfo(frdoc, (IDocument)master, fault_entry, monitor);
                    RefreshReportHandler.extractCICSLinkInfo(frdoc, (IDocument)master, fault_entry, monitor);
                    RefreshReportHandler.createDDFile(dds, fault_entry);
                    String extension = "faml";
                    RefreshReportHandler.createReportTocFile(monitor, fault_entry, FARL.getPathStringIncludingHash((URI)uri), extension);
                    RefreshReportHandler.saveReportSection(monitor, Messages.RefreshReportHandler_Extracting_main_report_section, (IDocument)master, fault_entry, new String[]{"Prolog", "Summary", "Synopsis"}, "main.faml");
                    RefreshReportHandler.saveReportSection(monitor, Messages.RefreshReportHandler_Extracting_event_report_section, (IDocument)master, fault_entry, new String[]{"EventSummary", "EventDetails"}, "event.faml");
                    RefreshReportHandler.saveReportSection(monitor, Messages.RefreshReportHandler_Extracting_abend_info_report_section, (IDocument)master, fault_entry, new String[]{"AbendJobInfo"}, "abend.faml");
                    RefreshReportHandler.saveReportSection(monitor, Messages.RefreshReportHandler_Extracting_system_wide_info_section, (IDocument)master, fault_entry, new String[]{"SystemWideInfo"}, "system.faml");
                    RefreshReportHandler.saveReportSection(monitor, Messages.RefreshReportHandler_Extracting_miscellaneous_section, (IDocument)master, fault_entry, new String[]{"OptionsInEffect", "Epilog"}, "misc.faml");
                    RefreshReportHandler.saveReportSection(monitor, Messages.RefreshReportHandler_Extracting_user_section, (IDocument)master, fault_entry, new String[]{"User"}, "user.faml");
                    try {
                        IFile report_file = FACorePlugin.getRoot().getFile(fault_entry.getProjectRelativePath().append(FARL.getPathStringIncludingHash((URI)uri).replaceFirst(".*\\(", "").replace(")", "")).addFileExtension(extension));
                        report_file.setHidden(true);
                        IFile opt = fault_entry.getFile(fault_entry.getLocation().lastSegment() + ".opt");
                        opt.setHidden(true);
                    }
                    catch (CoreException e) {
                        logger.warn((Throwable)e);
                    }
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
                if (report_path.exists()) {
                    PDPlatformUIUtils.editor.openEditor((IEditorInput)new FaultAnalyzerReportEditorInput(report_path, host), (String)"com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor");
                }
                RefreshReportHandler.downloadMinidump(address, port, dataset, member, user);
                ReportsList reportList = ReportsList.getIfOpen();
                if (reportList != null) {
                    reportList.refresh();
                }
            }
        });
        jobsList.put(FARL.get_langx((URI)uri), new FATPResponseHandler(){

            @Override
            public void handle(IProgressMonitor monitor, FATPAdapter response) {
                reportedRefreshedSuccessfully.get();
                monitor.beginTask(Messages.RefreshReportHandler_Saving_langx_source, -1);
                if (!response.is_successful_response()) {
                    logger.error((Object)response.toTrace());
                    return;
                }
                String body = response.get_body(CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.getEntityContentType()));
                if (body.isEmpty()) {
                    logger.info((Object)"No source files returned.");
                    return;
                }
                try {
                    StringBuilder sb = new StringBuilder("<sourceFiles>");
                    sb.append(body);
                    sb.append("</sourceFiles>");
                    InputSource source = new InputSource(new StringReader(sb.toString()));
                    SAXParserFactory.newInstance().newSAXParser().parse(source, (DefaultHandler)new SourceFileParser(fault_entry));
                    ReportsList reportList = ReportsList.getIfOpen();
                    if (reportList != null) {
                        reportList.refresh();
                    }
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    logger.error((Throwable)e);
                }
            }
        });
        jobsList.put(FARL.get_iditrace((URI)uri, (String)Preferences.getNL()), new FATPResponseHandler(){

            @Override
            public void handle(IProgressMonitor monitor, FATPAdapter response) {
                if (!response.is_successful_response()) {
                    logger.error((Object)response.toTrace());
                    return;
                }
                monitor.beginTask(Messages.RefreshReportHandler_DownloadIDITrace, -1);
                Charset charset = CharsetResponseHelper.getCharsetFromResponseOrDefaultFromContentTypeHeader(response.getEntityContentType());
                String contents = response.get_body(charset).replaceAll("\u0000", " ");
                monitor.worked(1);
                contents = RefreshReportHandler.fixLineEndingsIfLanguageIsKorean(contents);
                logger.debug((Object)("<IDITRACE>" + contents + "</IDITRACE>"));
                IFile iditrace_file = fault_entry.getFile("IDITRACE.log");
                if (!iditrace_file.exists()) {
                    IResourceUtils.createEmptyIFile((IFile)iditrace_file, (boolean)true, (IProgressMonitor)monitor);
                }
                monitor.worked(1);
                IResourceUtils.setIFileContents((IFile)iditrace_file, (String)contents, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
                if (!reportedRefreshedSuccessfully.get()) {
                    ViewIditrace.openIditrace(address, port, dataset, member);
                }
                EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fa.pdtclient.ui.report", (String)"hasIditrace");
                ReportsList reportList = ReportsList.getIfOpen();
                if (reportList != null) {
                    reportList.refresh();
                }
            }
        });
        jobsList.put(FARL.get_job_jcl((URI)uri), new FATPResponseHandler(){

            @Override
            public void handle(IProgressMonitor monitor, FATPAdapter response) {
                if (!response.is_successful_response()) {
                    logger.error((Object)response.toTrace());
                    return;
                }
                if (response.isNoContentResponse()) {
                    logger.trace((Object)"fault entry has no jcl.");
                    return;
                }
                monitor.beginTask("Downloading Job JCL...", -1);
                monitor.worked(1);
                IFile jclFile = fault_entry.getFile(member + ".jcl");
                if (!jclFile.exists()) {
                    IResourceUtils.createEmptyIFile((IFile)jclFile, (boolean)true, (IProgressMonitor)monitor);
                }
                monitor.worked(1);
                Charset charset = CharsetResponseHelper.getCharsetFromResponseOrDefaultFromContentTypeHeader(response.getEntityContentType());
                response.copy_body_to_file_utf8(jclFile, charset);
                IResourceUtils.refreshLocalIResource((IResource)jclFile, (int)0, (IProgressMonitor)monitor);
                EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fa.pdtclient.ui.report", (String)"hasJcl");
            }
        });
        if (Preferences.isTraceEnabled()) {
            jobsList.put(FARL.get_zzdebug((URI)uri, (String)Preferences.getNL()), new FATPResponseHandler(){

                @Override
                public void handle(IProgressMonitor monitor, FATPAdapter response) {
                    if (!response.is_successful_response()) {
                        logger.error((Object)response.toTrace());
                        return;
                    }
                    monitor.beginTask(Messages.RefreshReportHandler_DownloadZZDebug, -1);
                    monitor.worked(1);
                    IFile zzdebug_file = fault_entry.getFile("ZZDEBUG.log");
                    if (!zzdebug_file.exists()) {
                        IResourceUtils.createEmptyIFile((IFile)zzdebug_file, (boolean)true, (IProgressMonitor)monitor);
                    }
                    monitor.worked(1);
                    Charset charset = CharsetResponseHelper.getCharsetFromResponseOrDefaultFromContentTypeHeader(response.getEntityContentType());
                    response.copy_body_to_file_utf8(zzdebug_file, charset);
                    IResourceUtils.refreshLocalIResource((IResource)zzdebug_file, (int)0, (IProgressMonitor)monitor);
                    EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fa.pdtclient.ui.report", (String)"hasZZdebug");
                    ReportsList reportList = ReportsList.getIfOpen();
                    if (reportList != null) {
                        reportList.refresh();
                    }
                    monitor.done();
                }
            });
        }
        FATPJob2 job = new FATPJob2(Messages.RefreshReportHandler_Downloading_report, jobsList, true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                logger.trace((Object)("<<< " + Messages.RefreshReportHandler_Downloading_report));
            }
        });
        job.set_user(user);
        job.setUser(true);
        job.schedule();
        return job;
    }

    protected void handle(final ExecutionEvent event) {
        FAUserTask.createAndRunJob(Messages.RefreshReportHandler_RefreshingReport, new PDUserTask.PDUserJobFunction(){

            public void run(IProgressMonitor monitor) {
                if ("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor".equals(HandlerUtil.getActivePartId((ExecutionEvent)event))) {
                    FaultAnalyzerReportEditor fare = (FaultAnalyzerReportEditor)HandlerUtil.getActivePart((ExecutionEvent)event);
                    IPath report_file = ((IFileEditorInput)fare.getEditorInput()).getFile().getProjectRelativePath();
                    IEditorInput editorInput = ((FaultAnalyzerReportEditor)HandlerUtil.getActivePart((ExecutionEvent)event)).getEditorInput();
                    IPDHost host = null;
                    if (editorInput instanceof FaultAnalyzerReportEditorInput) {
                        host = ((FaultAnalyzerReportEditorInput)editorInput).getHost();
                    }
                    RefreshReportHandler.refresh(host, report_file.segment(0), report_file.segment(1), report_file.segment(2), report_file.segment(3));
                }
            }
        });
    }

    @Deprecated
    public static void refresh(String address, String service, String dataset, String member) {
        RefreshReportHandler.refresh(null, address, service, dataset, member);
    }

    public static void refresh(final IPDHost system, final String address, final String service, final String dataset, final String member) {
        logger.trace((Object)"====================================== Started refreshing a report: ===========================================================");
        final String options = new PreferencesAnalysis().getAnalysisOptions();
        if (ClearCachedReport.clearCachedReport(address, service, dataset, member)) {
            try {
                final String user = FaultAnalyzerParameters.getUserFromHost(address, service, PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor()));
                FAUserTask.createAndRunJob(Messages.RefreshReportHandler_DownloadingReport, new PDUserTask.PDUserJobFunction(){

                    public void run(IProgressMonitor monitor) {
                        logger.trace((Object)MessageFormat.format("refreshing report: {0} {1} {2} {3}", address, service, dataset, member));
                        RefreshReportHandler.checkDataSetExisting(system, address, service, dataset, member, options, user);
                    }
                });
            }
            catch (InterruptedException e) {
                logger.trace((Object)"Interrupted.");
            }
        }
    }

    public static void getSavedReport(final String address, final String service, final String dataset, final String member) {
        logger.trace((Object)"====================================== Started refreshing a report: ===========================================================");
        final String options = new PreferencesAnalysis().getAnalysisOptions();
        try {
            final String user = FaultAnalyzerParameters.getUserFromHost(address, service, PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor()));
            FAUserTask.createAndRunJob(Messages.RefreshReportHandler_DownloadingReport, new PDUserTask.PDUserJobFunction(){

                public void run(IProgressMonitor monitor) {
                    logger.trace((Object)MessageFormat.format("refreshing report: {0} {1} {2} {3}", address, service, dataset, member));
                    RefreshReportHandler.downloadSavedReport(address, service, dataset, member, options, user);
                }
            });
        }
        catch (InterruptedException e) {
            logger.trace((Object)"Interrupted.");
        }
    }
}

