/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor;
import com.ibm.etools.fa.pdtclient.ui.report.ReportPage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class PrintReportHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(PrintReportHandler.class);
    List<String> headerList;

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor2 = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        final ArrayList select_order = new ArrayList();
        final HashMap selected = new HashMap();
        if (editor2 != null && editor2 instanceof FaultAnalyzerReportEditor) {
            final FaultAnalyzerReportEditor ed = (FaultAnalyzerReportEditor)editor2;
            this.headerList = ed.getHeaderList();
            TitleAreaDialog structure = new TitleAreaDialog(Display.getCurrent().getActiveShell()){

                protected Control createDialogArea(Composite parent) {
                    this.setTitle(Messages.PrintReportHandler_PrintReport);
                    this.setMessage(Messages.PrintReportHandler_DoubleClickToAddRemove);
                    parent = new Composite(parent, 0);
                    FormLayout layout = new FormLayout();
                    parent.setLayout((Layout)layout);
                    TreeViewer viewer = new TreeViewer(parent);
                    FormData data = new FormData();
                    data.left = new FormAttachment(0, 4);
                    data.width = 150;
                    viewer.getControl().setLayoutData((Object)data);
                    viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                        public void dispose() {
                        }

                        public Object[] getChildren(Object parentElement) {
                            return ed.outline_provider.getChildren(parentElement);
                        }

                        public Object[] getElements(Object inputElement) {
                            return ed.outline_provider.getElements(inputElement);
                        }

                        public Object getParent(Object element) {
                            return ed.outline_provider.getParent(element);
                        }

                        public boolean hasChildren(Object element) {
                            if (element instanceof Annotation && ((Annotation)element).getType().equals("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsection.annotation")) {
                                return false;
                            }
                            return ed.outline_provider.hasChildren(element);
                        }

                        public void inputChanged(Viewer inputViewer, Object oldInput, Object newInput) {
                        }
                    });
                    viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                        public String getText(Object element) {
                            return ed.label_provider.getText(element);
                        }

                        public boolean isLabelProperty(Object element, String property) {
                            return false;
                        }
                    });
                    viewer.setInput((Object)ed.getEditorInput());
                    viewer.expandToLevel(1);
                    final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2048);
                    data = new FormData();
                    data.left = new FormAttachment(viewer.getControl(), 0, 4);
                    data.top = new FormAttachment(viewer.getControl(), 0, 128);
                    data.bottom = new FormAttachment(viewer.getControl(), 0, 1024);
                    data.width = 200;
                    list.setLayoutData((Object)data);
                    list.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDoubleClick(MouseEvent e) {
                            int[] indices;
                            int[] nArray = indices = list.getSelectionIndices();
                            int n = indices.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int index = nArray[n2];
                                select_order.remove(selected.remove(list.getItem(index)));
                                ++n2;
                            }
                            list.remove(indices);
                        }
                    });
                    viewer.addOpenListener(new IOpenListener(){

                        public void open(OpenEvent e) {
                            Annotation annotation = (Annotation)((TreeSelection)e.getSelection()).getFirstElement();
                            String text2 = ed.label_provider.getText(annotation);
                            if (list.indexOf(text2) > -1) {
                                return;
                            }
                            list.add(text2);
                            selected.put(text2, annotation);
                            select_order.add(annotation);
                        }
                    });
                    return viewer.getControl();
                }

                protected void okPressed() {
                    if (select_order.isEmpty()) {
                        this.setMessage(Messages.PrintReportHandler_DoubleClickToAddRemove, 2);
                        return;
                    }
                    this.setMessage(Messages.PrintReportHandler_DoubleClickToAddRemove);
                    PrinterData data = new PrintDialog(Display.getCurrent().getActiveShell()).open();
                    if (data != null) {
                        StyledText st = new StyledText((Composite)this.getParentShell(), 2050);
                        st.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
                        for (Annotation annotation : select_order) {
                            for (ReportPage page : ed.pages) {
                                IAnnotationModel model = page.getViewer().getAnnotationModel();
                                Iterator annotations = model.getAnnotationIterator();
                                while (annotations.hasNext()) {
                                    Annotation section_annotation = (Annotation)annotations.next();
                                    if (!(section_annotation instanceof ProjectionAnnotation) || !annotation.getText().startsWith(section_annotation.getText())) continue;
                                    Position position = model.getPosition(section_annotation);
                                    try {
                                        st.append(page.getViewer().getDocument().get(position.getOffset(), position.getLength()));
                                    }
                                    catch (BadLocationException e) {
                                        logger.warn((Throwable)e);
                                    }
                                }
                            }
                        }
                        StyledTextPrintOptions options = new StyledTextPrintOptions();
                        options.footer = Messages.Footer_In_PDF_report;
                        options.printTextFontStyle = true;
                        for (String header : PrintReportHandler.this.headerList) {
                            Pattern p = Pattern.compile(Pattern.quote(header));
                            Matcher m = p.matcher(st.getText());
                            while (m.find()) {
                                StyleRange style1 = new StyleRange();
                                style1.start = m.start();
                                style1.length = m.end() - m.start();
                                style1.fontStyle = 1;
                                st.setStyleRange(style1);
                            }
                        }
                        st.print(new Printer(data), options).run();
                        super.okPressed();
                    }
                }
            };
            structure.open();
        }
    }
}

