/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.report.OpenSectionHandler;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListOpenListener;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenSourceHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.command.opensource";
    private static final PDLogger logger = PDLogger.get(OpenSectionHandler.class);

    public static void openSourceWithLine(String address, String service, String dataset, String member, String line) {
        OpenSourceHandler.openWithLine(FAResourceUtils.getFaultEntryFolder((String)address, (String)service, (String)dataset, (String)member), line.split(" "));
    }

    public static void openSourceWithStmt(String address, String service, String dataset, String member, String stmt) {
        OpenSourceHandler.openWithStmt(FAResourceUtils.getFaultEntryFolder((String)address, (String)service, (String)dataset, (String)member), stmt.split(" "));
    }

    private static void openWithLine(IFolder fault_entry, String[] href) {
        String program_name = "";
        String extension = "";
        String file = "";
        int fileno = 0;
        int lineno = 1;
        String[] stringArray = href;
        int n = href.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.startsWith("Program=")) {
                program_name = token.substring("Program=".length());
            } else if (token.startsWith("Lang=")) {
                extension = token.substring("Lang=".length());
            } else if (token.startsWith("RFilen=")) {
                fileno = Integer.parseInt(token.substring("RFilen=".length()));
            } else if (token.startsWith("RLinen=")) {
                lineno = Integer.parseInt(token.substring("RLinen=".length()));
            } else if (token.startsWith("File=")) {
                file = token.substring("File=".length());
            }
            ++n2;
        }
        IFile src_file = FACorePlugin.getRoot().getFile(fault_entry.getProjectRelativePath().append(program_name).addFileExtension(extension.toLowerCase()));
        IFile langx_file = FACorePlugin.getRoot().getFile(src_file.getProjectRelativePath().addFileExtension("lxml"));
        if (!src_file.exists() || !langx_file.exists()) {
            src_file = FACorePlugin.getRoot().getFile(fault_entry.getProjectRelativePath().append("'" + file + "'").addFileExtension(extension));
            langx_file = FACorePlugin.getRoot().getFile(src_file.getProjectRelativePath().addFileExtension("lxml"));
            if (!src_file.exists() || !langx_file.exists()) {
                PDDialogs.openInfoThreadSafe((String)Messages.OpenSourceHandler_SourceNotFound, (String)Messages.OpenSourceHandler_RequestedSourceNotFound);
                return;
            }
        }
        int editor_line = 0;
        boolean found_line = false;
        XMLMemento langx = MementoUtils.loadXMLMementoFromIFile((IFile)langx_file, (boolean)true, (Charset)StandardCharsets.UTF_8);
        if (langx != null) {
            IMemento[] iMementoArray = langx.getChildren("tr");
            int n3 = iMementoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento tr = iMementoArray[n4];
                if (fileno != Integer.parseInt(tr.getChildren("td")[0].getTextData().trim())) {
                    ++editor_line;
                } else if (lineno != Integer.parseInt(tr.getChildren("td")[1].getTextData().trim())) {
                    ++editor_line;
                } else {
                    found_line = true;
                    break;
                }
                ++n4;
            }
        }
        OpenSourceHandler.openTheEditor(editor_line, found_line, src_file);
    }

    private static void openWithStmt(IFolder fault_entry, String[] href) {
        String program_name = "";
        String extension = "";
        int fileno = 0;
        int stmtno = 1;
        String[] stringArray = href;
        int n = href.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.startsWith("Program=")) {
                program_name = token.substring("Program=".length());
            } else if (token.startsWith("Lang=")) {
                extension = token.substring("Lang=".length());
            } else if (token.startsWith("RFilen=")) {
                fileno = Integer.parseInt(token.substring("RFilen=".length()));
            } else if (token.startsWith("RStmtn=")) {
                stmtno = Integer.parseInt(token.substring("RStmtn=".length()));
            }
            ++n2;
        }
        IFile src_file = FACorePlugin.getRoot().getFile(fault_entry.getProjectRelativePath().append(program_name).addFileExtension(extension.toLowerCase()));
        IFile langx_file = FACorePlugin.getRoot().getFile(src_file.getProjectRelativePath().addFileExtension("lxml"));
        if (!src_file.exists() || !langx_file.exists()) {
            PDDialogs.openInfoThreadSafe((String)Messages.OpenSourceHandler_SourceNotFound, (String)Messages.OpenSourceHandler_RequestedSourceNotFound);
            return;
        }
        int editor_line = 0;
        boolean found_line = false;
        XMLMemento langx = MementoUtils.loadXMLMementoFromIFile((IFile)langx_file, (boolean)true, (Charset)StandardCharsets.UTF_8);
        if (langx != null) {
            IMemento[] iMementoArray = langx.getChildren("tr");
            int n3 = iMementoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento tr = iMementoArray[n4];
                IMemento[] tdArray = tr.getChildren("td");
                if (fileno != Integer.parseInt(tdArray[0].getTextData().trim())) {
                    ++editor_line;
                } else if (stmtno != Integer.parseInt(tdArray[2].getTextData().trim())) {
                    if (extension.equalsIgnoreCase("ASM") && stmtno == Integer.parseInt(tdArray[1].getTextData().trim())) {
                        found_line = true;
                        break;
                    }
                    ++editor_line;
                } else {
                    found_line = true;
                    break;
                }
                ++n4;
            }
        }
        OpenSourceHandler.openTheEditor(editor_line, found_line, src_file);
    }

    private static void openTheEditor(final int editor_line, final boolean found_line, final IFile src_file) {
        if (src_file != null) {
            final String editor_id = ReportsListOpenListener.getEditorIdForFile(src_file);
            PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    IEditorPart editor2 = PDPlatformUIUtils.editor.openEditorOnActivePage((IFile)src_file, (String)editor_id, (boolean)true);
                    if (editor2 instanceof ITextEditor) {
                        try {
                            IRegion line_info = ((ITextEditor)editor2).getDocumentProvider().getDocument((Object)editor2.getEditorInput()).getLineInformation(!found_line ? 1 : editor_line);
                            ((ITextEditor)editor2).resetHighlightRange();
                            int line_offset = line_info.getOffset();
                            int line_length = line_info.getLength() - 1;
                            ((ITextEditor)editor2).selectAndReveal(line_offset, line_length < 0 ? 0 : line_length);
                            ((ITextEditor)editor2).setHighlightRange(line_offset, line_length < 0 ? 0 : line_length, true);
                        }
                        catch (BadLocationException e) {
                            logger.warn((Throwable)e);
                        }
                    }
                }
            });
        }
    }
}

