/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.report.DeferredModel;
import com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDPopupDialogWithTimeout;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorPart;

public class OpenAddressHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static Map<IFile, PDPopupDialogWithTimeout> openInvalidAddressPopupDialogs = new ConcurrentHashMap<IFile, PDPopupDialogWithTimeout>();

    public static void open(String host, String port, String dataset, String member, String addr) {
        OpenAddressHandler.open(null, host, port, dataset, member, addr);
    }

    public static void open(IPDHost system, String host, String port, String dataset, String member, String addr) {
        Objects.requireNonNull(host, "Please specify non-null host.");
        Objects.requireNonNull(port, "Please specify non-null port.");
        Objects.requireNonNull(dataset, "Please specify non-null dataset.");
        Objects.requireNonNull(member, "Please specify non-null member.");
        Objects.requireNonNull(addr, "Please specify non-null addr.");
        final IFile dump_file = FAResourceUtils.getFaultEntryMDMLFile((String)host, (String)port, (String)dataset, (String)member);
        Job[] jobArray = Job.getJobManager().find(FATPJob.class);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job fatp = jobArray[n2];
            if (dump_file.equals(fatp.getProperty(new QualifiedName("fatp", dump_file.getProjectRelativePath().toString())))) {
                PDDialogs.openInfoThreadSafe((String)Messages.OpenAddressHandler_MinidumpPreparation, (String)Messages.OpenAddressHandler_MinidumpIsBeingPrepared);
                return;
            }
            ++n2;
        }
        if (!dump_file.exists()) {
            PDDialogs.openInfoThreadSafe((String)Messages.OpenAddressHandler_NoMinidumpFile, (String)Messages.OpenAddressHandler_NoMinidumpAvailable);
        } else {
            DeferredModel dm = new DeferredModel((IResource)dump_file);
            dm.setup();
            final String trimmedAddr = addr.replaceAll(" ", "").replaceAll("_", "");
            final String formattedAddr = OpenAddressHandler.formatAddress(trimmedAddr);
            Long value = 0L;
            boolean valid = true;
            try {
                value = Long.parseLong(trimmedAddr, 16);
            }
            catch (NumberFormatException nfe) {
                valid = false;
            }
            final int lineIndex = valid ? dm.get_line(value) : -1;
            final int lineIndexHighOrderTurnedOff = valid ? dm.get_line(Integer.MAX_VALUE & value) : -1;
            PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (lineIndex > -1 || lineIndexHighOrderTurnedOff > -1) {
                        PDLogger.get(OpenAddressHandler.class).trace((Object)("Opening addr: " + formattedAddr));
                        IEditorPart editor2 = PDPlatformUIUtils.editor.openEditorOnActivePage((IFile)dump_file, null, (boolean)false);
                        if (editor2 instanceof MinidumpPage) {
                            MinidumpPage page = (MinidumpPage)editor2;
                            page.set_origin(Long.parseLong(trimmedAddr, 16));
                            page.setAddressText(formattedAddr);
                        } else {
                            PDLogger.get(this.getClass()).error((Object)MessageFormat.format("Can''t open address {0} as the minidump page could not be opened.", formattedAddr));
                        }
                        editor2.setFocus();
                    } else {
                        if (!openInvalidAddressPopupDialogs.isEmpty()) {
                            for (Map.Entry<IFile, PDPopupDialogWithTimeout> d2 : openInvalidAddressPopupDialogs.entrySet()) {
                                if (!d2.getKey().equals((Object)dump_file)) continue;
                                d2.getValue().close();
                            }
                        }
                        PDPopupDialogWithTimeout dialog = new PDPopupDialogWithTimeout(PDPlatformUIUtils.getActiveShell(), 540676, Messages.MinidumpPage_Invalid_address, MessageFormat.format(Messages.OpenAddressHandler_AddressNotInMinidump, Long.toHexString(Long.parseLong(trimmedAddr, 16)).toUpperCase()), 500, new Runnable(){

                            @Override
                            public void run() {
                                openInvalidAddressPopupDialogs.remove(dump_file);
                            }
                        });
                        openInvalidAddressPopupDialogs.put(dump_file, dialog);
                        dialog.open();
                    }
                }
            });
        }
    }

    public static String formatAddress(String addr) {
        String trimmedAddr = addr.replaceAll(" ", "").replaceAll("_", "");
        if (trimmedAddr.length() > 8) {
            return trimmedAddr.substring(0, trimmedAddr.length() - 8) + "_" + trimmedAddr.substring(trimmedAddr.length() - 8);
        }
        return trimmedAddr;
    }
}

