/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.report.DeferredDocument;
import com.ibm.etools.fa.pdtclient.ui.report.DeferredModel;
import com.ibm.etools.fa.pdtclient.ui.report.MinidumpProvider;
import com.ibm.etools.fa.pdtclient.ui.report.OpenAddressHandler;
import com.ibm.etools.fa.pdtclient.ui.report.ReportHyperlink;
import com.ibm.etools.fa.pdtclient.ui.report.ReportPageMenuHider;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LabeledContainer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class MinidumpPage
extends TextEditor
implements IGotoMarker {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(MinidumpPage.class);
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage";
    private boolean detectHyperlinks = true;
    private LightweightSystem lws = null;
    private int left_pixel = 0;
    private int top_pixel = 0;
    private HashMap<IMarker, UsernoteFigure> usernotes = new HashMap();
    private HashMap<UsernoteFigure, XYAnchor> anchors = new HashMap();
    private Combo address_text = null;
    private long origin_address = -1L;
    private Annotation[] annotations = new Annotation[0];
    private IMarker pending_marker;
    private Combo custom_encoding_selection;
    private Combo addressModeSelection;
    private int bitMode = 32;
    private static final String[] ADDRESS_MODE_STRINGS = new String[]{"24", "32", "64"};
    private static final int DEFAULT_MODE_INDEX = 1;
    private IMenuListener menu_listener = ReportPageMenuHider.getMenuItemRemover();
    private final int maxAddressLength = Long.toHexString(Long.MAX_VALUE).length();

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.addMenuListener(this.menu_listener);
        this.menu_listener.menuAboutToShow(menu);
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        AnnotationRulerColumn annotation_ruler = new AnnotationRulerColumn((IAnnotationModel)this.get_mod(), 12);
        annotation_ruler.setHover(new IAnnotationHover(){

            public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
                StringBuffer text2 = new StringBuffer();
                try {
                    DeferredModel model = MinidumpPage.this.get_mod();
                    if (!model.ready()) {
                        return text2.toString();
                    }
                    DeferredDocument document = MinidumpPage.this.get_doc();
                    if (!document.ready()) {
                        return text2.toString();
                    }
                    IMarker[] iMarkerArray = ((IFileEditorInput)MinidumpPage.this.getEditorInput()).getFile().findMarkers(null, true, 1);
                    int n = iMarkerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        int char_start = MarkerUtilities.getCharStart((IMarker)marker);
                        if (MarkerUtilities.getLineNumber((IMarker)marker) == lineNumber + 1 || document.getLineOfOffset(char_start) == lineNumber) {
                            if (!marker.getAttribute("location", "").isEmpty()) {
                                text2.append(marker.getAttribute("location", ""));
                                text2.append(": ");
                                text2.append(MarkerUtilities.getMessage((IMarker)marker));
                                text2.append("\n\n");
                            } else {
                                Annotation annotation = MinidumpPage.this.annotations[lineNumber];
                                if (annotation == null) {
                                    return text2.toString();
                                }
                                Position position = model.getBackingPosition(annotation);
                                if (position.includes(char_start)) {
                                    int row_offset = char_start - position.getOffset();
                                    long row_address = Long.parseLong(annotation.getText().split(" ")[1], 16);
                                    long address = (long)((row_offset / 9 << 2) + (row_offset % 9 >> 1)) + row_address;
                                    text2.append(Long.toHexString(address).toUpperCase());
                                    text2.append(": ");
                                    text2.append(MarkerUtilities.getMessage((IMarker)marker));
                                    text2.append("\n\n");
                                }
                            }
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    logger.warn((Throwable)e);
                }
                return text2.toString();
            }
        });
        LineNumberRulerColumn column = new LineNumberRulerColumn(){

            protected int computeNumberOfDigits() {
                return 17;
            }

            protected String createDisplayString(int line) {
                block8: {
                    if (line % 129 != 128) break block8;
                    return "";
                }
                try {
                    StringBuilder display = new StringBuilder(Long.toHexString(MinidumpPage.this.get_mod().get_address(line)).toUpperCase());
                    if (display.length() < 8) {
                        int i = display.length();
                        while (i < 8) {
                            display.insert(0, '0');
                            ++i;
                        }
                    } else if (display.length() > 8 && display.length() <= 16) {
                        int i = display.length();
                        while (i < 16) {
                            display.insert(0, '0');
                            ++i;
                        }
                        display.insert(8, '_');
                    }
                    return display.toString();
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    return "";
                }
            }
        };
        column.setForeground(new Color((Device)Display.getCurrent(), 255, 96, 0));
        ruler.addDecorator(10, (IVerticalRulerColumn)column);
        return annotation_ruler;
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        LineNumberRulerColumn column = new LineNumberRulerColumn(){

            protected int computeNumberOfDigits() {
                return 12;
            }

            protected String createDisplayString(int line) {
                if (line % 129 == 128) {
                    return "";
                }
                long offset = MinidumpPage.this.origin_address - MinidumpPage.this.get_mod().get_address(line);
                return (offset > 0L ? "-" : "+") + Long.toHexString(Math.abs(offset)).toUpperCase();
            }
        };
        return column;
    }

    private static boolean isValidAddressFormat(String addressTextContent) {
        if (addressTextContent.contains("_") && addressTextContent.length() <= 8) {
            return false;
        }
        addressTextContent = addressTextContent.toUpperCase();
        if ((addressTextContent = addressTextContent.replace("_", "")).contains("_")) {
            return false;
        }
        if (addressTextContent.length() > 16) {
            return false;
        }
        int i = 0;
        while (i < addressTextContent.length()) {
            switch (addressTextContent.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void createPartControl(Composite parent) {
        parent = new Composite(parent, 0x20000000);
        parent.setLayoutData((Object)GUI.grid.d.fillH((int)1));
        parent.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(parent, 0x20000000);
        composite.setLayoutData((Object)GUI.grid.d.fillAll());
        composite.setLayout((Layout)new FillLayout());
        MinidumpProvider provider = this.get_provider();
        provider.deferred_setup(this.getEditorInput());
        DeferredModel doc_model = this.get_mod();
        super.createPartControl(composite);
        doc_model.update_markers();
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        try {
            IMarker[] iMarkerArray = file.findMarkers("org.eclipse.core.resources.marker", true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                this.prepare_marker(marker);
                ++n2;
            }
        }
        catch (CoreException e) {
            logger.warn((Throwable)e);
        }
        final ISourceViewer viewer = this.getSourceViewer();
        viewer.setRangeIndication(0, 1, true);
        if (this.pending_marker != null) {
            this.gotoMarker(this.pending_marker);
        } else if (this.origin_address != -1L) {
            this.set_origin(this.origin_address);
        } else if (this.origin_address == -1L) {
            this.set_origin(0L);
        }
        viewer.getTextWidget().addMouseListener((org.eclipse.swt.events.MouseListener)new MouseAdapter(){

            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                if (e.button == 3) {
                    StyledText textWidget = viewer.getTextWidget();
                    int mouseOffset = -1;
                    try {
                        mouseOffset = textWidget.getOffsetAtLocation(new org.eclipse.swt.graphics.Point(e.x, e.y));
                    }
                    catch (IllegalArgumentException ex) {
                        logger.error((Throwable)ex);
                    }
                    if (mouseOffset == -1) {
                        int lineIndex = textWidget.getLineIndex(e.y) + 1;
                        mouseOffset = lineIndex >= textWidget.getLineCount() ? textWidget.getCharCount() : textWidget.getOffsetAtLine(lineIndex) - 1;
                    }
                    if (textWidget.getSelectionCount() > 0) {
                        boolean withinSelection;
                        org.eclipse.swt.graphics.Point textSelection = textWidget.getSelection();
                        boolean bl = withinSelection = mouseOffset >= textSelection.x && mouseOffset < textSelection.y;
                        if (withinSelection) {
                            return;
                        }
                    }
                    textWidget.setCaretOffset(mouseOffset);
                }
            }
        });
        this.getVerticalRuler().update();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarkerDelta[] deltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", true);
                if (deltas.length == 0) {
                    return;
                }
                IResource resource = null;
                IMarkerDelta[] iMarkerDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    final IMarkerDelta delta = iMarkerDeltaArray[n2];
                    if (resource != delta.getResource()) {
                        resource = delta.getResource();
                        Job job = new Job(Messages.MinidumpPage_UpdateMarkersView){

                            protected IStatus run(IProgressMonitor monitor) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (delta.getResource().equals((Object)((IFileEditorInput)MinidumpPage.this.getEditorInput()).getFile())) {
                                            MinidumpPage.this.prepare_marker(delta.getMarker());
                                        }
                                    }
                                });
                                return Status.OK_STATUS;
                            }
                        };
                        job.setRule((ISchedulingRule)delta.getResource());
                        job.schedule();
                    }
                    ++n2;
                }
            }
        }, 1);
        IPath minidump_path = ((FileEditorInput)this.getEditorInput()).getFile().getProjectRelativePath();
        this.setPartName(Ipv6Utils.decodeAndWrap((String)minidump_path.segment(0)) + ":" + minidump_path.segment(1) + "/" + minidump_path.segment(2) + "(" + minidump_path.segment(3) + ")-" + Messages.ReportsList_Minidump);
        Composite childComposite = new Composite(parent, 0);
        childComposite.setLayoutData((Object)GUI.grid.d.fillH((int)1));
        childComposite.setLayout((Layout)GUI.grid.l.margins((int)3, (boolean)false));
        Composite showAddressComposite = GUI.composite((Composite)childComposite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)showAddressComposite, (String)Messages.MinidumpPage_Address1, (Object)GUI.grid.d.left1());
        this.address_text = new Combo(showAddressComposite, 2048);
        this.address_text.setTextLimit(17);
        this.address_text.setToolTipText(Messages.MinidumpPage_PleaseSpecifyAddress);
        this.address_text.setLayoutData((Object)GUI.grid.d.fillH((int)1));
        List<String> list = Activator.retrieve("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.address");
        String[] items = new String[list.size()];
        this.address_text.setItems(list.toArray(items));
        this.address_text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character != '\r') {
                    return;
                }
                String addressTextContent = MinidumpPage.this.address_text.getText().trim();
                if (MinidumpPage.isValidAddressFormat(addressTextContent)) {
                    long address = 0L;
                    if (addressTextContent.contains("_")) {
                        String[] addressParts = addressTextContent.split("_", 2);
                        StringBuilder sb = new StringBuilder(addressParts[1]);
                        while (sb.length() < 8) {
                            sb.insert(0, "0");
                        }
                        addressParts[1] = sb.toString();
                        address = Long.parseLong(addressParts[0] + addressParts[1], 16);
                    } else {
                        address = Long.parseLong(addressTextContent, 16);
                    }
                    try {
                        MinidumpPage.this.set_origin(address);
                        MinidumpPage.this.address_text.setBackground(Display.getCurrent().getSystemColor(1));
                        Activator.cache("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.address", Long.toHexString(address).trim().toUpperCase());
                        List<String> minidumpList = Activator.retrieve("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.address");
                        String[] minidumpItems = new String[minidumpList.size()];
                        MinidumpPage.this.address_text.setItems(minidumpList.toArray(minidumpItems));
                        int i = 0;
                        while (i < minidumpItems.length) {
                            minidumpItems[i] = OpenAddressHandler.formatAddress(minidumpItems[i]);
                            ++i;
                        }
                        MinidumpPage.this.address_text.setText(minidumpItems[0]);
                    }
                    catch (Exception ex) {
                        MinidumpPage.this.address_text.setBackground(Display.getCurrent().getSystemColor(3));
                    }
                } else {
                    MinidumpPage.this.address_text.setBackground(Display.getCurrent().getSystemColor(3));
                }
            }
        });
        final org.eclipse.swt.widgets.Button wShowAddressButton = GUI.button.push((Composite)showAddressComposite, (String)Messages.MinidumpPage_ShowAddress, (Object)GUI.grid.d.left1());
        wShowAddressButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String hexString = MinidumpPage.this.address_text.getText().trim().replace("_", "");
                    long address = Long.parseLong(hexString, 16);
                    MinidumpPage.this.set_origin(address);
                    MinidumpPage.this.address_text.setBackground(Display.getCurrent().getSystemColor(1));
                    Activator.cache("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.address", Long.toHexString(address).trim().toUpperCase());
                    List<String> minidumpList = Activator.retrieve("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.address");
                    String[] minidumpItems = new String[minidumpList.size()];
                    MinidumpPage.this.address_text.setItems(minidumpList.toArray(minidumpItems));
                    MinidumpPage.this.address_text.setText(minidumpItems[0]);
                }
                catch (Exception ex) {
                    MinidumpPage.this.address_text.setBackground(Display.getCurrent().getSystemColor(3));
                }
            }
        });
        final ControlDecoration dec = new ControlDecoration((Control)this.address_text, 16512);
        dec.setShowOnlyOnFocus(true);
        dec.hide();
        final Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        final Image requiredImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage();
        wShowAddressButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MinidumpPage.this.showAddressDecorationSupport(MinidumpPage.this.address_text.getText(), dec, errorImage, requiredImage, wShowAddressButton);
            }
        });
        this.address_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MinidumpPage.this.showAddressDecorationSupport(MinidumpPage.this.address_text.getText(), dec, errorImage, requiredImage, wShowAddressButton);
            }
        });
        Composite offsetComposite = GUI.composite((Composite)childComposite, (Layout)GUI.grid.l.noMargins((int)4, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)offsetComposite, (String)Messages.MinidumpPage_Offset, (Object)GUI.grid.d.left1());
        final Combo offsetText = new Combo(offsetComposite, 2048);
        offsetText.setToolTipText(Messages.MinidumpPage_PleaseSpecifyOffset);
        offsetText.setLayoutData((Object)GUI.grid.d.fillH((int)1));
        list = Activator.retrieve("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.offset");
        items = new String[list.size()];
        offsetText.setItems(list.toArray(items));
        final ControlDecoration offsetComboDecoration = new ControlDecoration((Control)offsetText, 16512);
        offsetComboDecoration.setShowOnlyOnFocus(true);
        offsetComboDecoration.hide();
        final org.eclipse.swt.widgets.Button wPlusButton = GUI.button.push((Composite)offsetComposite, (String)"+", (Object)GUI.grid.d.left1());
        wPlusButton.setToolTipText(Messages.MinidumpPage_MoveForward);
        wPlusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MinidumpPage.this.showAddressDecorationSupport(offsetText.getText(), offsetComboDecoration, errorImage, requiredImage, wPlusButton);
                try {
                    DeferredDocument doc = MinidumpPage.this.get_doc();
                    int caret = MinidumpPage.this.getSourceViewer().getTextWidget().getCaretOffset();
                    long offset = caret - doc.getLineInformationOfOffset(caret).getOffset();
                    MinidumpPage.this.origin_address = MinidumpPage.this.get_mod().get_address(doc.getLineOfOffset(caret)) + offset / 9L * 4L + offset % 9L / 2L;
                    offset = Long.parseLong(offsetText.getText().trim(), 16);
                    MinidumpPage.this.set_origin(MinidumpPage.this.origin_address + offset);
                    offsetText.setBackground(Display.getCurrent().getSystemColor(1));
                    Activator.cache("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.offset", Long.toHexString(offset).trim().toUpperCase());
                    List<String> minidumpList = Activator.retrieve("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.offset");
                    String[] minidumpItems = new String[minidumpList.size()];
                    offsetText.setItems(minidumpList.toArray(minidumpItems));
                    offsetText.setText(minidumpItems[0]);
                }
                catch (Exception ex) {
                    offsetText.setBackground(Display.getCurrent().getSystemColor(3));
                }
            }
        });
        final org.eclipse.swt.widgets.Button wMinusButton = GUI.button.push((Composite)offsetComposite, (String)"-", (Object)GUI.grid.d.left1());
        offsetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MinidumpPage.this.showAddressDecorationSupport(offsetText.getText(), offsetComboDecoration, errorImage, requiredImage, wPlusButton, wMinusButton);
            }
        });
        wMinusButton.setToolTipText(Messages.MinidumpPage_MoveBack);
        wMinusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MinidumpPage.this.showAddressDecorationSupport(offsetText.getText(), offsetComboDecoration, errorImage, requiredImage, wMinusButton);
                try {
                    DeferredDocument doc = MinidumpPage.this.get_doc();
                    int caret = MinidumpPage.this.getSourceViewer().getTextWidget().getCaretOffset();
                    long offset = caret - doc.getLineInformationOfOffset(caret).getOffset();
                    MinidumpPage.this.origin_address = MinidumpPage.this.get_mod().get_address(doc.getLineOfOffset(caret)) + offset / 9L * 4L + offset % 9L / 2L;
                    offset = Long.parseLong(offsetText.getText().trim(), 16);
                    MinidumpPage.this.set_origin(MinidumpPage.this.origin_address - offset);
                    offsetText.setBackground(Display.getCurrent().getSystemColor(1));
                    Activator.cache("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.offset", Long.toHexString(offset).trim().toUpperCase());
                    List<String> minidumpList = Activator.retrieve("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage.offset");
                    String[] minidumpItems = new String[minidumpList.size()];
                    offsetText.setItems(minidumpList.toArray(minidumpItems));
                    offsetText.setText(minidumpItems[0]);
                }
                catch (Exception ex) {
                    offsetText.setBackground(Display.getCurrent().getSystemColor(3));
                }
            }
        });
        Composite encodingSelectionComposite = GUI.composite((Composite)childComposite, (Layout)GUI.grid.l.noMargins((int)7, (boolean)false), (Object)GUI.grid.d.fillAll());
        final org.eclipse.swt.widgets.Button ebcdic_button = GUI.button.radio((Composite)encodingSelectionComposite, (String)"EBCDIC", (Object)GUI.grid.d.left1());
        ebcdic_button.setToolTipText(Messages.MinidumpPage_UsesTheDefaultCodePage);
        final org.eclipse.swt.widgets.Button ascii_button = GUI.button.radio((Composite)encodingSelectionComposite, (String)"ASCII", (Object)GUI.grid.d.left1());
        ascii_button.setToolTipText(Messages.MinidumpPage_BasicAsciiCharacterEncoding);
        final org.eclipse.swt.widgets.Button custom_encoding_button = GUI.button.radio((Composite)encodingSelectionComposite, (String)Messages.MinidumpPage_Other, (Object)GUI.grid.d.left1());
        custom_encoding_button.setToolTipText(Messages.MinidumpPage_SelectAvailableCharacterSet);
        this.custom_encoding_selection = new Combo(encodingSelectionComposite, 2060);
        String[] supportedCharsets = Charset.availableCharsets().keySet().toArray(new String[0]);
        this.custom_encoding_selection.setItems(supportedCharsets);
        final org.eclipse.swt.widgets.Button persistent_ebcdic_button = GUI.button.checkbox((Composite)encodingSelectionComposite, (String)Messages.MinidumpPage_EBCDIC_Compare_Button, (Object)GUI.grid.d.left1());
        persistent_ebcdic_button.setToolTipText(Messages.MinidumpPage_Persistent_EBCDIC);
        this.addressModeSelection = new Combo(encodingSelectionComposite, 2060);
        this.addressModeSelection.setItems(ADDRESS_MODE_STRINGS);
        GUI.label((Composite)encodingSelectionComposite, (String)Messages.MinidumpPage_Bitmode, (Object)GUI.grid.d.left1(), (int)0);
        SelectionAdapter encodingSelectionListener = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent e) {
                org.eclipse.swt.widgets.Button sourceButton = (org.eclipse.swt.widgets.Button)e.getSource();
                DeferredDocument ddoc = MinidumpPage.this.get_doc();
                Charset charset = CharsetResponseHelper.getCharsetFromSystem(ddoc.getHost());
                String invalidCharacterPattern = null;
                boolean ignoreMultiByteCharacters = false;
                if (sourceButton.equals(ebcdic_button)) {
                    charset = CharsetResponseHelper.getCharsetFromSystem(ddoc.getHost());
                    invalidCharacterPattern = "\\P{Print}";
                    ignoreMultiByteCharacters = false;
                    ascii_button.setSelection(false);
                    ebcdic_button.setSelection(true);
                    custom_encoding_button.setSelection(false);
                } else if (sourceButton.equals(ascii_button)) {
                    charset = StandardCharsets.UTF_8;
                    invalidCharacterPattern = "\\P{Print}";
                    ignoreMultiByteCharacters = true;
                    ascii_button.setSelection(true);
                    ebcdic_button.setSelection(false);
                    custom_encoding_button.setSelection(false);
                } else if (sourceButton.equals(custom_encoding_button)) {
                    charset = MinidumpPage.this.getCustomEncoding();
                    if (charset == null) return;
                    invalidCharacterPattern = "\\p{C}";
                    ignoreMultiByteCharacters = false;
                    ebcdic_button.setSelection(false);
                    ascii_button.setSelection(false);
                    custom_encoding_button.setSelection(true);
                } else if (sourceButton.equals(persistent_ebcdic_button)) {
                    ddoc.setPersistentEBCDIC(persistent_ebcdic_button.getSelection());
                    if (ebcdic_button.getSelection()) {
                        charset = CharsetResponseHelper.getCharsetFromSystem(ddoc.getHost());
                        invalidCharacterPattern = "\\P{Print}";
                        ignoreMultiByteCharacters = false;
                        ascii_button.setSelection(false);
                        ebcdic_button.setSelection(true);
                        custom_encoding_button.setSelection(false);
                    } else if (ascii_button.getSelection()) {
                        charset = StandardCharsets.UTF_8;
                        invalidCharacterPattern = "\\P{Print}";
                        ignoreMultiByteCharacters = true;
                        ascii_button.setSelection(true);
                        ebcdic_button.setSelection(false);
                        custom_encoding_button.setSelection(false);
                    } else if (custom_encoding_button.getSelection()) {
                        charset = MinidumpPage.this.getCustomEncoding();
                        if (charset == null) return;
                        invalidCharacterPattern = "\\p{C}";
                        ignoreMultiByteCharacters = false;
                        ebcdic_button.setSelection(false);
                        ascii_button.setSelection(false);
                        custom_encoding_button.setSelection(true);
                    }
                }
                ddoc.setEncodingCharSet(charset);
                ddoc.setInvalidCharacterPattern(invalidCharacterPattern);
                ddoc.setIgnoreMultibyteCharacters(ignoreMultiByteCharacters);
                MinidumpPage.this.getSourceViewer().getTextWidget().redraw();
            }
        };
        ebcdic_button.addSelectionListener((SelectionListener)encodingSelectionListener);
        ascii_button.addSelectionListener((SelectionListener)encodingSelectionListener);
        custom_encoding_button.addSelectionListener((SelectionListener)encodingSelectionListener);
        persistent_ebcdic_button.addSelectionListener((SelectionListener)encodingSelectionListener);
        this.custom_encoding_selection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                custom_encoding_button.setSelection(true);
                custom_encoding_button.notifyListeners(13, new Event());
            }
        });
        ebcdic_button.setSelection(true);
        this.addressModeSelection.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MinidumpPage.this.bitMode = Integer.parseInt(MinidumpPage.this.addressModeSelection.getText());
            }
        });
        this.addressModeSelection.select(1);
    }

    private void showAddressDecorationSupport(String string, ControlDecoration dec, Image errorImage, Image requiredImage, org.eclipse.swt.widgets.Button ... button2) {
        org.eclipse.swt.widgets.Button b;
        org.eclipse.swt.widgets.Button[] buttonArray = button2;
        int n = button2.length;
        int n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            b.setEnabled(false);
            ++n2;
        }
        if (string.trim().isEmpty()) {
            dec.setDescriptionText(Messages.MinidumpPage_PleaseSpecifyAddress);
            dec.setImage(requiredImage);
            dec.show();
        } else if (string.length() > this.maxAddressLength + (string.contains("_") ? 1 : 0)) {
            dec.setDescriptionText(MessageFormat.format(Messages.MinidumpPage_CheckAddressLength, this.maxAddressLength));
            dec.setImage(errorImage);
            dec.show();
        } else if (string.trim().toUpperCase().matches("(\\p{XDigit}{1,8}_)?\\p{XDigit}{1,8}")) {
            dec.hide();
            buttonArray = button2;
            n = button2.length;
            n2 = 0;
            while (n2 < n) {
                b = buttonArray[n2];
                b.setEnabled(true);
                ++n2;
            }
        } else {
            dec.setDescriptionText(Messages.MinidumpPage_PleaseSpecifyAddress);
            dec.setImage(errorImage);
            dec.show();
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.getEditorSite().getShell().setFont(JFaceResources.getFont((String)"com.ibm.etools.fa.pdtclient.ui.font"));
        SourceViewer viewer = new SourceViewer(parent, this.getVerticalRuler(), this.getOverviewRuler(), true, styles){

            protected FindReplaceDocumentAdapter getFindReplaceDocumentAdapter() {
                return new FindReplaceDocumentAdapter(this.getDocument()){

                    public IRegion find(int startOffset, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch) throws BadLocationException {
                        DeferredDocument doc = MinidumpPage.this.get_doc();
                        DeferredModel mod = MinidumpPage.this.get_mod();
                        if (startOffset == -1 && forwardSearch) {
                            startOffset = 0;
                        } else if (startOffset == -1 && !forwardSearch) {
                            startOffset = doc.getLength() - 1;
                        }
                        int editor_start = startOffset / (129 * doc.getLineLength()) * (129 * doc.getLineLength());
                        String page = doc.show_page(mod.get_address(doc.getLineOfOffset(startOffset)));
                        startOffset %= 129 * doc.getLineLength();
                        while (page != null) {
                            Document page_doc = new Document(page);
                            BlockTextSelection text_block = new BlockTextSelection((IDocument)page_doc, 0, 73, 128, 105, 0);
                            IRegion[] text_block_regions = text_block.getRegions();
                            Document text_doc = new Document(text_block.getText().replaceAll("\n", ""));
                            FindReplaceDocumentAdapter page_doc_finder = new FindReplaceDocumentAdapter((IDocument)page_doc);
                            FindReplaceDocumentAdapter text_doc_finder = new FindReplaceDocumentAdapter((IDocument)text_doc);
                            IRegion page_result = page_doc_finder.find(startOffset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                            IRegion text_result = text_doc_finder.find(startOffset / doc.getLineLength() * 32 + (startOffset % doc.getLineLength() < 73 ? 0 : startOffset % doc.getLineLength() - 73), findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                            if (page_result != null || text_result != null) {
                                int page_offset = -1;
                                int page_end = -1;
                                int text_offset = -1;
                                int text_end = -1;
                                if (page_result != null) {
                                    page_offset = page_result.getOffset() + editor_start;
                                    page_end = page_result.getOffset() + page_result.getLength() + editor_start;
                                }
                                if (text_result != null) {
                                    text_offset = text_block_regions[text_result.getOffset() / 32].getOffset() + text_result.getOffset() % 32 + editor_start;
                                    text_end = text_block_regions[(text_result.getOffset() + text_result.getLength()) / 32].getOffset() + (text_result.getOffset() + text_result.getLength()) % 32 + editor_start;
                                }
                                if (page_result != null && text_result == null) {
                                    Region page_region = new Region(page_offset, page_end - page_offset);
                                    return page_region;
                                }
                                if (page_result == null && text_result != null) {
                                    Region text_region = new Region(text_offset, text_end - text_offset);
                                    return text_region;
                                }
                                if (forwardSearch) {
                                    if (text_offset < page_offset) {
                                        Region text_region = new Region(text_offset, text_end - text_offset);
                                        return text_region;
                                    }
                                    Region page_region = new Region(page_offset, page_end - page_offset);
                                    return page_region;
                                }
                                if (text_end > page_end) {
                                    Region text_region = new Region(text_offset, text_end - text_offset);
                                    return text_region;
                                }
                                Region page_region = new Region(page_offset, page_end - page_offset);
                                return page_region;
                            }
                            if (forwardSearch) {
                                editor_start += "00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000  *................................* *................................*\n".length() * 129;
                                page = doc.show_next();
                                startOffset = 0;
                                continue;
                            }
                            editor_start -= "00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000  *................................* *................................*\n".length() * 129;
                            startOffset = page.length() - 1;
                            page = doc.show_prev();
                        }
                        return null;
                    }
                };
            }
        };
        StyledText st = viewer.getTextWidget();
        this.lws = new LightweightSystem((Canvas)st);
        IFigure root = this.lws.getRootFigure();
        root.setOpaque(false);
        root.setLayoutManager((LayoutManager)new FreeformLayout());
        this.lws.setEventDispatcher((EventDispatcher)new SWTEventDispatcher(){

            public void dispatchFocusGained(FocusEvent e) {
                super.dispatchFocusGained(e);
            }

            public void dispatchFocusLost(FocusEvent e) {
                super.dispatchFocusLost(e);
            }

            public void dispatchKeyPressed(KeyEvent e) {
                super.dispatchKeyPressed(e);
                e.doit = false;
            }

            public void dispatchKeyReleased(KeyEvent e) {
                super.dispatchKeyReleased(e);
                e.doit = false;
            }

            public void dispatchKeyTraversed(TraverseEvent e) {
                super.dispatchKeyTraversed(e);
                e.doit = false;
            }

            public void dispatchMouseDoubleClicked(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseDoubleClicked(me);
            }

            public void dispatchMouseEntered(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseEntered(me);
            }

            public void dispatchMouseExited(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseExited(me);
            }

            public void dispatchMouseHover(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseHover(me);
            }

            public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseMoved(me);
            }

            public void dispatchMousePressed(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMousePressed(me);
            }

            public void dispatchMouseReleased(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseReleased(me);
            }

            public void dispatchMouseWheelScrolled(Event event) {
                super.dispatchMouseWheelScrolled(event);
                if (this.getMouseTarget() instanceof UsernoteFigure) {
                    event.doit = false;
                }
            }
        });
        Listener scroller = new Listener(){

            public void handleEvent(Event event) {
                MinidumpPage.this.update_usernotes_position();
                event.doit = false;
            }
        };
        st.addListener(3, scroller);
        st.addListener(5, scroller);
        st.addListener(4, scroller);
        st.addListener(1, scroller);
        st.addListener(2, scroller);
        st.addListener(11, scroller);
        st.getHorizontalBar().addListener(13, scroller);
        st.getVerticalBar().addListener(13, scroller);
        this.setSourceViewerConfiguration(new SourceViewerConfiguration(){

            public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
                return new IHyperlinkDetector[]{new IHyperlinkDetector(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
                        String text2;
                        IRegion linkRegion;
                        int textWidth;
                        IDocument document;
                        block9: {
                            String trimmedText;
                            block8: {
                                block7: {
                                    if (!(this).MinidumpPage.this.detectHyperlinks) {
                                        return null;
                                    }
                                    document = textViewer.getDocument();
                                    if (document instanceof DeferredDocument && !((DeferredDocument)document).ready()) {
                                        return null;
                                    }
                                    try {
                                        textWidth = (this).MinidumpPage.this.bitMode / 4;
                                        linkRegion = this.getLinkRegion(document, region, textWidth);
                                        if (linkRegion != null) break block7;
                                        return null;
                                    }
                                    catch (BadLocationException e) {
                                        logger.trace((Throwable)e);
                                        return null;
                                    }
                                }
                                text2 = document.get(linkRegion.getOffset(), textWidth);
                                trimmedText = text2.trim().replace(" ", "");
                                if (!trimmedText.isEmpty()) break block8;
                                return null;
                            }
                            int spaces = text2.length() - trimmedText.length();
                            if (spaces <= 0) return new IHyperlink[]{new ReportHyperlink(linkRegion, "<a href=\"ADDR: " + text2 + "\">", ((IFileEditorInput)MinidumpPage.this.getEditorInput()).getFile().getProjectRelativePath().toString())};
                            linkRegion = this.getLinkRegion(document, region, textWidth += spaces);
                            if (linkRegion != null) break block9;
                            return null;
                        }
                        text2 = document.get(linkRegion.getOffset(), textWidth);
                        return new IHyperlink[]{new ReportHyperlink(linkRegion, "<a href=\"ADDR: " + text2 + "\">", ((IFileEditorInput)MinidumpPage.this.getEditorInput()).getFile().getProjectRelativePath().toString())};
                    }

                    private IRegion getLinkRegion(IDocument document, IRegion region, int textWidth) throws BadLocationException {
                        Object link_region = document.getLineInformationOfOffset(region.getOffset());
                        int lineOfOffset = document.getLineOfOffset(region.getOffset());
                        int offsetOfLine = document.getLineOffset(lineOfOffset);
                        link_region = region.getOffset() - link_region.getOffset() + textWidth <= 71 ? new Region(region.getOffset(), textWidth) : (region.getOffset() - link_region.getOffset() <= 71 ? new Region(offsetOfLine + 71 - textWidth, textWidth) : null);
                        return link_region;
                    }
                }};
            }

            public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
                return new DefaultHyperlinkPresenter(new RGB(0, 128, 0));
            }

            public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
                return 0;
            }

            public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
                return new ITextHover(){

                    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
                        DeferredModel model = MinidumpPage.this.get_mod();
                        if (!model.ready()) {
                            return null;
                        }
                        try {
                            IDocument document = textViewer.getDocument();
                            IRegion line_info = document.getLineInformationOfOffset(hoverRegion.getOffset());
                            long line_address = model.get_address(((DeferredDocument)document).getLineOfOffset(line_info.getOffset()));
                            return "ADDR: " + Long.toHexString((long)((hoverRegion.getOffset() - line_info.getOffset()) / 9 << 2) + line_address).toUpperCase();
                        }
                        catch (BadLocationException e) {
                            logger.warn((Throwable)e);
                            return null;
                        }
                    }

                    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
                        IDocument document;
                        block4: {
                            try {
                                document = textViewer.getDocument();
                                if (!(document instanceof DeferredDocument) || ((DeferredDocument)document).ready()) break block4;
                                return null;
                            }
                            catch (BadLocationException e) {
                                logger.warn((Throwable)e);
                                return new Region(offset, 1);
                            }
                        }
                        IRegion line_info = document.getLineInformationOfOffset(offset);
                        if (offset - line_info.getOffset() < 72) {
                            return new Region(offset - (offset - line_info.getOffset()) % 9, 8);
                        }
                        return new Region(line_info.getOffset() + 72, 34);
                    }
                };
            }
        });
        this.configureSourceViewerDecorationSupport(this.getSourceViewerDecorationSupport((ISourceViewer)viewer));
        return viewer;
    }

    protected void disposeDocumentProvider() {
        this.get_provider().teardown(this.getEditorInput());
        super.disposeDocumentProvider();
    }

    private DeferredDocument get_doc() {
        return (DeferredDocument)this.get_provider().getDocument(this.getEditorInput());
    }

    private DeferredModel get_mod() {
        return (DeferredModel)this.get_provider().getAnnotationModel(this.getEditorInput());
    }

    private MinidumpProvider get_provider() {
        return (MinidumpProvider)this.getDocumentProvider();
    }

    private Charset getCustomEncoding() {
        String selectedCharsetName = this.custom_encoding_selection.getText();
        if (selectedCharsetName != null && !selectedCharsetName.isEmpty()) {
            return (Charset)Charset.availableCharsets().get(selectedCharsetName);
        }
        return null;
    }

    public void gotoMarker(IMarker marker) {
        int char_start = MarkerUtilities.getCharStart((IMarker)marker);
        int char_end = MarkerUtilities.getCharEnd((IMarker)marker);
        if (char_end == -1) {
            char_end = char_start;
        }
        DeferredModel model = this.get_mod();
        DeferredDocument doc = this.get_doc();
        if (!model.ready() || !doc.ready()) {
            this.pending_marker = marker;
            return;
        }
        try {
            if (marker.getAttribute("location") != null) {
                this.set_origin(Long.parseLong((String)marker.getAttribute("location"), 16));
            }
        }
        catch (CoreException e) {
            logger.warn((Throwable)e);
        }
        if (char_start >= 0) {
            this.getSourceViewer().setRangeIndication(char_start, char_end - char_start, true);
            this.selectAndReveal(char_start, char_end - char_start);
        }
        this.update_usernotes_position();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(ID);
    }

    protected boolean isBlockSelectionModeSupported() {
        return true;
    }

    public boolean isChangeInformationShowing() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEditorInputModifiable() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return false;
    }

    protected boolean isLineNumberRulerVisible() {
        return true;
    }

    protected boolean isOverviewRulerVisible() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    protected void prepare_marker(IMarker marker) {
        if (!marker.exists()) {
            UsernoteFigure usernoteFigure = this.usernotes.get(marker);
            if (usernoteFigure != null) {
                IFigure rootFigure = this.lws.getRootFigure();
                rootFigure.remove((IFigure)usernoteFigure);
                this.anchors.remove((Object)usernoteFigure);
                this.usernotes.remove(marker).removeAll();
            }
            return;
        }
        try {
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                return;
            }
            DeferredDocument doc = this.get_doc();
            DeferredModel model = this.get_mod();
            Map attributes = marker.getAttributes();
            if (attributes.containsKey("charStart") && !attributes.containsKey("location")) {
                int char_start = MarkerUtilities.getCharStart((IMarker)marker);
                long line_address = model.get_address(doc.getLineOfOffset(char_start));
                if (line_address < 0L) {
                    return;
                }
                int line_offset = char_start % doc.getLineLength();
                if (line_offset > 70 && line_offset < 73 || line_offset > 104) {
                    return;
                }
                line_address = line_offset > 72 && line_offset < 105 ? (line_address += (long)(line_offset - 73)) : (line_address += (long)(line_offset / 9 * 4 + line_offset % 9 / 2));
                attributes.put("location", Long.toHexString(line_address).toUpperCase());
                marker.setAttributes(attributes);
            } else if (!attributes.containsKey("charStart") && attributes.containsKey("location")) {
                long location = Long.parseLong((String)attributes.get("location"), 16);
                int line = model.get_line(location);
                long line_address = model.get_address(line);
                long line_offset = (location - line_address) / 4L * 9L + (location - line_address) % 4L % 2L;
                MarkerUtilities.setCharStart((Map)attributes, (int)((int)((long)doc.getLineOffset(line) + line_offset)));
                marker.setAttributes(attributes);
            }
        }
        catch (CoreException e) {
            logger.warn((Throwable)e);
        }
        if (this.usernotes.containsKey(marker)) {
            UsernoteFigure note = this.usernotes.get(marker);
            if (note != null) {
                note.setText(MarkerUtilities.getMessage((IMarker)marker));
            }
            return;
        }
        for (IMarker existing : this.usernotes.keySet()) {
            if (MarkerUtilities.getCharStart((IMarker)existing) != MarkerUtilities.getCharStart((IMarker)marker) || MarkerUtilities.getCharEnd((IMarker)existing) != MarkerUtilities.getCharEnd((IMarker)marker)) continue;
            try {
                String text2 = MarkerUtilities.getMessage((IMarker)existing) + "\n" + MarkerUtilities.getMessage((IMarker)marker);
                existing.setAttribute("message", (Object)text2);
                this.usernotes.get(existing).setText(text2);
                marker.delete();
            }
            catch (CoreException e) {
                logger.warn((Throwable)e);
            }
            this.usernotes.put(marker, null);
            return;
        }
        UsernoteFigure figure = new UsernoteFigure(marker);
        this.lws.getRootFigure().add((IFigure)figure);
        this.usernotes.put(marker, figure);
    }

    public boolean isAddressInMinidump(long address) {
        DeferredModel mod = this.get_mod();
        if (this.get_doc().ready() && mod.ready()) {
            return mod.get_line(address) > -1;
        }
        return false;
    }

    public void setAddressText(String text2) {
        this.address_text.setText(text2);
    }

    public void set_origin(long _address) {
        if (PDLoggerJhost.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format("addr={0} hex={1}", _address, Long.toHexString(_address)));
        }
        DeferredModel mod = this.get_mod();
        DeferredDocument doc = this.get_doc();
        if (!doc.ready()) {
            this.origin_address = _address;
            return;
        }
        if (!mod.ready()) {
            this.origin_address = _address;
            return;
        }
        String hexString = Long.toHexString(_address);
        if (hexString.length() == 8 && (_address & Integer.MIN_VALUE) != 0L) {
            _address &= Integer.MAX_VALUE;
        }
        this.origin_address = _address;
        int start_line = mod.get_line(_address);
        if (start_line > -1) {
            this.getSourceViewer().setRangeIndication(doc.getLineOffset(start_line), 1, true);
            long address_offset = _address - mod.get_address(start_line);
            this.getSourceViewer().getTextWidget().setFocus();
            this.getSourceViewer().getTextWidget().setSelection((int)((long)doc.getLineOffset(start_line) + address_offset / 4L * 9L + address_offset % 4L * 2L));
            if (this.getVerticalRuler() != null) {
                this.getVerticalRuler().update();
            }
            this.update_usernotes_position();
        } else {
            PDDialogs.openErrorThreadSafe((String)Messages.MinidumpPage_Invalid_address, (String)MessageFormat.format(Messages.OpenAddressHandler_AddressNotInMinidump, Long.toHexString(this.origin_address).toUpperCase()));
        }
    }

    private void update_usernotes_position() {
        StyledText st = this.getSourceViewer().getTextWidget();
        int vpixel = st.getTopPixel();
        int hpixel = st.getHorizontalPixel();
        for (UsernoteFigure fig : this.usernotes.values()) {
            if (fig == null) continue;
            fig.translate(this.left_pixel - hpixel, this.top_pixel - vpixel);
        }
        for (XYAnchor anchor : this.anchors.values()) {
            Point point = anchor.getReferencePoint();
            anchor.setLocation(new Point(point.x + this.left_pixel - hpixel, point.y + this.top_pixel - vpixel));
        }
        IFigure rootFigure = this.lws.getRootFigure();
        rootFigure.repaint();
        this.top_pixel = vpixel;
        this.left_pixel = hpixel;
    }

    public void dispose() {
        super.dispose();
    }

    private class FigureDragger
    implements MouseListener,
    MouseMotionListener {
        int pressed_x = 0;
        int pressed_y = 0;

        private FigureDragger() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
            me.consume();
        }

        public void mouseDragged(MouseEvent me) {
            int delta_y;
            me.consume();
            IFigure figure = (IFigure)me.getSource();
            if (!(figure instanceof UsernoteFigure)) {
                return;
            }
            MinidumpPage.this.getSourceViewer().getTextWidget().setSelection(MarkerUtilities.getCharStart((IMarker)((UsernoteFigure)figure).marker));
            Rectangle bounds = figure.getBounds();
            org.eclipse.swt.graphics.Rectangle ca = MinidumpPage.this.getSourceViewer().getTextWidget().getClientArea();
            int delta_x = me.x - this.pressed_x;
            if (delta_x < 0) {
                Point left = bounds.getLeft().getTranslated(delta_x, 0);
                if (left.x < ca.x) {
                    return;
                }
            } else if (delta_x > 0) {
                Point right = bounds.getRight().getTranslated(delta_x, 0);
                if (right.x > ca.x + ca.width) {
                    return;
                }
            }
            if ((delta_y = me.y - this.pressed_y) < 0) {
                Point top = bounds.getTop().getTranslated(delta_y, 0);
                if (top.y < ca.y) {
                    return;
                }
            } else if (delta_y > 0) {
                Point bottom = bounds.getBottom().getTranslated(delta_y, 0);
                if (bottom.y > ca.y + ca.height) {
                    return;
                }
            }
            figure.translate(delta_x, delta_y);
            figure.repaint();
            figure.getParent().repaint();
            this.pressed_x = me.x;
            this.pressed_y = me.y;
        }

        public void mouseEntered(MouseEvent me) {
            this.pressed_x = me.x;
            this.pressed_y = me.y;
            me.consume();
            IFigure figure = (IFigure)me.getSource();
            if (!(figure instanceof UsernoteFigure)) {
                return;
            }
            ((UsernoteFigure)figure).set_translucent();
        }

        public void mouseExited(MouseEvent me) {
            me.consume();
            IFigure figure = (IFigure)me.getSource();
            if (!(figure instanceof UsernoteFigure)) {
                return;
            }
            ((UsernoteFigure)figure).set_opaque();
        }

        public void mouseHover(MouseEvent me) {
            me.consume();
            IFigure figure = (IFigure)me.getSource();
            if (!(figure instanceof UsernoteFigure)) {
                return;
            }
        }

        public void mouseMoved(MouseEvent me) {
            me.consume();
            IFigure figure = (IFigure)me.getSource();
            if (!(figure instanceof UsernoteFigure)) {
                return;
            }
        }

        public void mousePressed(MouseEvent me) {
            IFigure figure = (IFigure)me.getSource();
            if (!(figure instanceof UsernoteFigure)) {
                return;
            }
            ((UsernoteFigure)figure).set_opaque();
            this.pressed_x = me.x;
            this.pressed_y = me.y;
        }

        public void mouseReleased(MouseEvent me) {
            me.consume();
            IFigure figure = (IFigure)me.getSource();
            if (!(figure instanceof UsernoteFigure)) {
                return;
            }
            ((UsernoteFigure)figure).set_translucent();
            this.pressed_x = 0;
            this.pressed_y = 0;
            StyledText st = MinidumpPage.this.getSourceViewer().getTextWidget();
            st.setSelection(MarkerUtilities.getCharStart((IMarker)((UsernoteFigure)figure).marker));
        }
    }

    private class UsernoteFigure
    extends LabeledContainer {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private IMarker marker;
        private Label label;
        private int alpha = 255;
        private PolylineConnection connection = new PolylineConnection();

        public UsernoteFigure(IMarker _marker) {
            this.marker = _marker;
            try {
                this.setLayoutManager((LayoutManager)new ToolbarLayout(false));
                this.setLabel(_marker.getAttribute("location").toString());
                this.setSize(200, 100);
                StyledText st = MinidumpPage.this.getSourceViewer().getTextWidget();
                org.eclipse.swt.graphics.Point point = st.getLocationAtOffset(MarkerUtilities.getCharStart((IMarker)_marker));
                this.setLocation(new Point(point.x + 20, point.y - 130));
                this.label = new Label(MarkerUtilities.getMessage((IMarker)_marker)){

                    public String getSubStringText() {
                        return super.getText();
                    }
                };
                this.label.setBounds(new Rectangle(0, 0, 150, 100));
                this.label.setLabelAlignment(1);
                this.label.setTextPlacement(16);
                this.label.setTextAlignment(8);
                this.add((IFigure)this.label);
                this.setToolTip((IFigure)new Label(this.label.getText()));
                IFigure root = MinidumpPage.this.lws.getRootFigure();
                XYAnchor xy_anchor = new XYAnchor(new Point(point.x, point.y + 5));
                ChopboxAnchor note_anchor = new ChopboxAnchor((IFigure)this);
                this.connection.setSourceAnchor((ConnectionAnchor)note_anchor);
                this.connection.setTargetAnchor((ConnectionAnchor)xy_anchor);
                PolygonDecoration decor = new PolygonDecoration();
                decor.setPoints(PolygonDecoration.TRIANGLE_TIP);
                this.connection.setTargetDecoration((RotatableDecoration)decor);
                root.add((IFigure)this.connection);
                this.connection.setForegroundColor(Display.getCurrent().getSystemColor(3));
                this.connection.setLineWidth(2);
                MinidumpPage.this.anchors.put(this, xy_anchor);
            }
            catch (CoreException e) {
                logger.warn((Throwable)e);
            }
            Button edit_button = new Button(Messages.MinidumpPage_Edit);
            edit_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    IMarker actionMarker = UsernoteFigure.this.marker;
                    InputDialog dialog = new InputDialog(MinidumpPage.this.getSite().getShell(), Messages.MinidumpPage_EditMarker, Messages.MinidumpPage_EditMarker, MarkerUtilities.getMessage((IMarker)actionMarker), null){

                        protected void configureShell(Shell shell) {
                            super.configureShell(shell);
                            shell.setSize(500, 300);
                        }

                        protected Control createDialogArea(Composite parent) {
                            Control control = super.createDialogArea(parent);
                            GridData data = new GridData(256, 16, true, false);
                            data.widthHint = 500;
                            data.heightHint = 300;
                            this.getText().setLayoutData((Object)data);
                            return control;
                        }

                        protected int getInputTextStyle() {
                            return 2050;
                        }
                    };
                    if (dialog.open() == 0) {
                        try {
                            actionMarker.setAttribute("message", (Object)dialog.getValue());
                        }
                        catch (CoreException e) {
                            logger.warn((Throwable)e);
                        }
                    }
                    MinidumpPage.this.set_origin(Long.parseLong(actionMarker.getAttribute("location", "0"), 16));
                    StyledText st = MinidumpPage.this.getSourceViewer().getTextWidget();
                    st.setSelection(MarkerUtilities.getCharStart((IMarker)actionMarker));
                }
            });
            this.add((IFigure)edit_button);
            Button removeButton = new Button(Messages.MinidumpPage_Remove);
            removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    IMarker actionMarker = UsernoteFigure.this.marker;
                    if (PDDialogs.openConfirmThreadSafe((String)Messages.MinidumpPage_RemoveMarker, (String)Messages.MinidumpPage_ConfirmRemove)) {
                        try {
                            actionMarker.delete();
                        }
                        catch (CoreException e) {
                            logger.error((Throwable)e);
                        }
                    }
                }
            });
            this.add((IFigure)removeButton);
            FigureDragger dragger = new FigureDragger();
            this.addMouseListener(dragger);
            this.addMouseMotionListener(dragger);
        }

        public void paint(Graphics graphics) {
            graphics.setAlpha(this.alpha);
            if (this.marker.exists()) {
                try {
                    if (this.marker.getType().equals("org.eclipse.core.resources.bookmark")) {
                        this.setBackgroundColor(Preferences.getBookmarkUsernoteColor());
                        this.setForegroundColor(Preferences.getBookmarkUsernoteTextColor());
                    } else if (this.marker.getType().equals("org.eclipse.core.resources.taskmarker")) {
                        this.setBackgroundColor(Preferences.getTaskUsernoteColor());
                        this.setForegroundColor(Preferences.getBookmarkUsernoteTextColor());
                    } else if (this.marker.getType().equals("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.usernote.marker")) {
                        this.setBackgroundColor(Preferences.getHostUsernoteColor());
                        this.setForegroundColor(Preferences.getHostUsernoteTextColor());
                    } else {
                        this.setBackgroundColor(Display.getCurrent().getSystemColor(7));
                    }
                }
                catch (CoreException e) {
                    logger.warn((Throwable)e);
                }
            }
            super.paint(graphics);
        }

        public void removeAll() {
            super.removeAll();
            MinidumpPage.this.lws.getRootFigure().remove((IFigure)this.connection);
        }

        public void set_opaque() {
            this.alpha = 255;
        }

        public void set_translucent() {
            this.alpha = 160;
        }

        public void setText(String attribute) {
            this.label.setText(attribute);
            this.setToolTip((IFigure)new Label(this.label.getText()));
        }
    }
}

