/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.report.markers.MarkerContentProvider;
import com.ibm.etools.fa.pdtclient.ui.report.markers.MarkerLabelProvider;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class Markers
extends ViewPart {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.markers";
    private static final PDLogger logger = PDLogger.get(Markers.class);
    public static final String GENERATOR_ID = "com.ibm.etools.fa.pdtclient.ui.markers.generator";
    private TreeViewer tree;

    public Markers() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarkerDelta[] deltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", true);
                if (deltas.length != 0) {
                    IResource resource = null;
                    IMarkerDelta[] iMarkerDeltaArray = deltas;
                    int n = deltas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarkerDelta delta = iMarkerDeltaArray[n2];
                        if (resource != delta.getResource()) {
                            resource = delta.getResource();
                            UIJob job = new UIJob(Messages.Markers_UpdateMarkersView){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    Markers.this.set_input(PDPlatformUIUtils.editor.getInputFromActiveEditor());
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setRule((ISchedulingRule)delta.getResource());
                            job.schedule();
                        }
                        ++n2;
                    }
                }
            }
        }, 1);
    }

    public void createPartControl(Composite parent) {
        this.tree = new TreeViewer(parent, 0x10010004);
        this.tree.getTree().setLinesVisible(true);
        this.tree.setContentProvider((IContentProvider)new MarkerContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new MarkerLabelProvider());
        this.tree.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IWorkbenchPage page;
                IMarker marker = Markers.getFirstSelectedMarker(event.getSelection());
                if (marker != null && (page = PDPlatformUIUtils.getActiveIWorkbenchPage()) != null) {
                    try {
                        IDE.gotoMarker((IEditorPart)IDE.openEditor((IWorkbenchPage)page, (IMarker)marker), (IMarker)marker);
                    }
                    catch (PartInitException e) {
                        logger.warn((Throwable)e);
                    }
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.tree);
        MenuManager mgr = new MenuManager();
        this.getSite().registerContextMenu(mgr, (ISelectionProvider)this.tree);
        this.tree.getControl().setMenu(mgr.createContextMenu(this.tree.getControl()));
    }

    public static IMarker getFirstSelectedMarker(ISelection selection) {
        Object firstElement;
        if (selection != null && !selection.isEmpty() && (firstElement = ((ITreeSelection)selection).getFirstElement()) instanceof IMarker) {
            return (IMarker)firstElement;
        }
        return null;
    }

    public void set_input(IEditorInput _input) {
        if (this.tree != null && !this.tree.getTree().isDisposed()) {
            this.tree.setInput((Object)_input);
            this.tree.expandAll();
        }
    }

    public void setFocus() {
        this.set_input(PDPlatformUIUtils.editor.getInputFromActiveEditor());
    }

    public static Markers getMarkers() {
        return (Markers)PDPlatformUIUtils.view.findView((String)ID, Markers.class);
    }
}

