/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IFileEditorInput;

public class FaultAnalyzerReportEditorPropertyTester
extends PropertyTester {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String NAMESPACE = "com.ibm.etools.fa.pdtclient.ui.report";
    public static final String PROPERTY_HAS_IDITRACE = "hasIditrace";
    public static final String PROPERTY_HAS_ZZDEBUG = "hasZZdebug";
    public static final String PROPERTY_HAS_JCL = "hasJcl";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        block13: {
            if (!(receiver instanceof FaultAnalyzerReportEditor)) break block13;
            FaultAnalyzerReportEditor reportEditor = (FaultAnalyzerReportEditor)((Object)receiver);
            IFileEditorInput faultEntryInputFile = (IFileEditorInput)reportEditor.getEditorInput();
            IPath faultEntryPath = faultEntryInputFile.getFile().getProjectRelativePath().removeLastSegments(1);
            switch (property) {
                case "hasIditrace": {
                    IPath iditracePath = faultEntryPath.append("IDITRACE.log");
                    IFile iditraceFile = FACorePlugin.getRoot().getFile(iditracePath);
                    return iditraceFile.exists();
                }
                case "hasZZdebug": {
                    IPath iditracePath = faultEntryPath.append("ZZDEBUG.log");
                    IFile iditraceFile = FACorePlugin.getRoot().getFile(iditracePath);
                    return iditraceFile.exists();
                }
                case "hasJcl": {
                    IPath jclPath = faultEntryPath.append(faultEntryPath.lastSegment() + ".jcl");
                    IFile jclFile = FACorePlugin.getRoot().getFile(jclPath);
                    return jclFile.exists();
                }
            }
        }
        return false;
    }
}

