/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditorInputFactory;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class FaultAnalyzerReportEditorInput
implements IFileEditorInput,
IPersistableElement {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IFile inputFile;
    private IPDHost host;

    public IPDHost getHost() {
        return this.host;
    }

    public FaultAnalyzerReportEditorInput(IFile inputFile, IPDHost host) {
        if (inputFile == null) {
            throw new IllegalArgumentException();
        }
        this.inputFile = inputFile;
        this.host = host;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFile.class) {
            return this.inputFile;
        }
        return this.inputFile.getAdapter(adapter);
    }

    public boolean exists() {
        return this.inputFile.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.inputFile.getName());
    }

    public String getName() {
        return this.inputFile.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        String name = this.getName();
        if (name != null && name.contains("(") && name.contains("")) {
            return name.split("\\(")[1].split("\\)")[0];
        }
        return name;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.inputFile);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FaultAnalyzerReportEditorInput other = (FaultAnalyzerReportEditorInput)obj;
        return Objects.equals(this.host, other.host) && Objects.equals(this.inputFile, other.inputFile);
    }

    public IStorage getStorage() throws CoreException {
        return this.inputFile;
    }

    public IFile getFile() {
        return this.inputFile;
    }

    public void saveState(IMemento memento) {
        FaultAnalyzerReportEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return FaultAnalyzerReportEditorInputFactory.getFactoryId();
    }

    public IFolder getFaultEntryFolder() {
        return this.inputFile.getParent().getFolder(Path.fromPortableString((String)"."));
    }
}

