/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditorInput;
import com.ibm.etools.fa.pdtclient.ui.report.OpenAddressHandler;
import com.ibm.etools.fa.pdtclient.ui.report.OpenSectionHandler;
import com.ibm.etools.fa.pdtclient.ui.report.ReportPage;
import com.ibm.etools.fa.pdtclient.ui.report.ReportProvider;
import com.ibm.etools.fa.pdtclient.ui.report.ReportSetup;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionChangeListener;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.string.StringInput;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class FaultAnalyzerReportEditor
extends MultiPageEditorPart
implements IGotoMarker {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FaultAnalyzerReportEditor.class);
    private List<String> headerList = new ArrayList<String>();
    public ReportTreeContentProvider outline_provider = new ReportTreeContentProvider();
    public ReportTreeLabelProvider label_provider = new ReportTreeLabelProvider();
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor";
    public List<ReportPage> pages = new ArrayList<ReportPage>();
    public HashSet<String> nonaddresses = new HashSet();
    private IFile input;
    private BufferedReader br;

    static {
        ConnectionUtilities.addPDConnectionChangeListener((IPDToolsConnectionChangeListener)new IPDToolsConnectionChangeListener(){

            public void deletedConnection(String hostID) {
            }

            public void newConnection(HostDetails newHostDetails) {
            }

            public void updatedConnection(HostDetails oldHostDetails, HostDetails updatedHostDetails) {
                if (oldHostDetails != null && updatedHostDetails != null && !oldHostDetails.getHostDefaultEncoding().equals(updatedHostDetails.getHostDefaultEncoding()) && Preferences.isUseCodePageFromHostEnabled()) {
                    FaultAnalyzerReportEditor.reopenAllFaultAnalyzerReportEditorsOnActivePages();
                }
            }
        });
    }

    protected void createPages() {
        IPath report_path;
        block31: {
            IContextService context_service = (IContextService)this.getSite().getService(IContextService.class);
            context_service.activateContext(ID);
            report_path = ((IFileEditorInput)this.getEditorInput()).getFile().getProjectRelativePath();
            IFile file = FACorePlugin.getRoot().getFolder(report_path.removeLastSegments(1)).getFile(report_path.removeLastSegments(1).lastSegment() + ".tmp");
            try {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStreamReader isr = new InputStreamReader(file.getContents(true), StandardCharsets.UTF_8);){
                        this.br = new BufferedReader(isr);
                        String line = "";
                        while ((line = this.br.readLine()) != null) {
                            if (!line.contains("<H1>") && !line.contains("<H2>")) continue;
                            this.headerList.add(line.replace("<H1>", "").replace("<H2>", ""));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CoreException e) {
                    logger.error((Object)"An error occurred while loading the XMLMemento from the IFile: ", e);
                    try {
                        this.br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                this.br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setPartName(Ipv6Utils.decodeAndWrap((String)report_path.segment(0)) + ":" + report_path.segment(1) + "/" + report_path.segment(2) + "(" + report_path.segment(3) + ")-" + Messages.FaultAnalyzerReportEditor_Report);
        this.input = FACorePlugin.getRoot().getFolder(report_path.removeLastSegments(1)).getFile(report_path.removeLastSegments(1).lastSegment() + ".faml");
        HashMap<String, String> links = new HashMap<String, String>();
        XMLMemento memento = MementoUtils.loadXMLMementoFromIFile((IFile)this.input, (boolean)true, (Charset)StandardCharsets.UTF_8);
        if (memento != null) {
            IMemento[] iMementoArray = memento.getChildren("link");
            int n = iMementoArray.length;
            int line = 0;
            while (line < n) {
                IMemento link = iMementoArray[line];
                links.put(link.getString("rel"), link.getString("href"));
                ++line;
            }
            this.createReportPage(report_path, links, "main", Messages.FaultAnalyzerReportEditor_Main_Report);
            this.createReportPage(report_path, links, "event", Messages.FaultAnalyzerReportEditor_Event_Details);
            String eventLink = links.get("event");
            if (eventLink != null && (memento = MementoUtils.loadXMLMementoFromIFile((IFile)FACorePlugin.getRoot().getFile(report_path.removeLastSegments(1).append(eventLink)), (boolean)true, (Charset)StandardCharsets.UTF_8)) != null) {
                IMemento[] iMementoArray2 = memento.getChildren("ul");
                int n2 = iMementoArray2.length;
                n = 0;
                while (n < n2) {
                    IMemento ul = iMementoArray2[n];
                    if (ul.getString("class") != null && ul.getString("class").equals("nonaddresses")) {
                        IMemento[] iMementoArray3 = ul.getChildren("li");
                        int n3 = iMementoArray3.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemento li = iMementoArray3[n4];
                            this.nonaddresses.add(li.getTextData());
                            ++n4;
                        }
                        break;
                    }
                    ++n;
                }
            }
            this.createReportPage(report_path, links, "abend", Messages.FaultAnalyzerReportEditor_Abend_Information);
            this.createReportPage(report_path, links, "system", Messages.FaultAnalyzerReportEditor_System_Wide_Information);
            this.createReportPage(report_path, links, "misc", Messages.FaultAnalyzerReportEditor_Miscellaneous);
            String userLink = links.get("user");
            if (userLink != null && (memento = MementoUtils.loadXMLMementoFromIFile((IFile)FACorePlugin.getRoot().getFile(report_path.removeLastSegments(1).append(userLink)), (boolean)true, (Charset)StandardCharsets.UTF_8)) != null && memento.getChildren().length > 0) {
                this.createReportPage(report_path, links, "user", Messages.FaultAnalyzerReportEditor_User);
            }
            this.outline_provider.inputChanged(null, this.input, this.input);
        } else {
            ReportPage page = new ReportPage(this);
            try {
                this.setPageText(this.addPage((IEditorPart)page, (IEditorInput)StringInput.create((String)Messages.FaultAnalyzerReportEditor_CouldNotOpenCachedFaultEntry, null)), Messages.FaultAnalyzerReportEditor_ErrorLoading);
            }
            catch (PartInitException e) {
                logger.error((Throwable)e);
            }
            this.pages.add(page);
        }
    }

    private void createReportPage(IPath report_path, HashMap<String, String> links, String pageId, String pageText) {
        Objects.requireNonNull(report_path, "Please provide a non-null report_path.");
        Objects.requireNonNull(links, "Please provide a non-null links.");
        Objects.requireNonNull(pageText, "Please provide a non-null pageText.");
        try {
            String path2 = links.get(pageId);
            if (path2 != null) {
                IPath path = report_path.removeLastSegments(1).append(path2);
                ReportPage page = new ReportPage(this);
                IPDHost host = null;
                if (this.getEditorInput() instanceof FaultAnalyzerReportEditorInput) {
                    host = ((FaultAnalyzerReportEditorInput)this.getEditorInput()).getHost();
                }
                this.setPageText(this.addPage((IEditorPart)page, (IEditorInput)new FaultAnalyzerReportEditorInput(FACorePlugin.getRoot().getFile(path), host)), pageText);
                this.pages.add(page);
            } else {
                logger.error((Object)("link for pageid " + pageId + " is null; Can not create page."));
            }
        }
        catch (PartInitException e) {
            logger.error((Object)MessageFormat.format("{0} {1} {2} ||| {3}", ((Object)((Object)e)).getClass(), e.getCause(), e.getMessage(), e.getStatus()), (Throwable)e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            return new ContentOutlinePage(){

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    TreeViewer tree = this.getTreeViewer();
                    tree.setContentProvider((IContentProvider)FaultAnalyzerReportEditor.this.outline_provider);
                    tree.setLabelProvider((IBaseLabelProvider)FaultAnalyzerReportEditor.this.label_provider);
                    tree.addOpenListener(new IOpenListener(){

                        public void open(OpenEvent event) {
                            Annotation annotation;
                            IPath path = ((IFileEditorInput)FaultAnalyzerReportEditor.this.getEditorInput()).getFile().getProjectRelativePath();
                            String address = path.segment(0);
                            String service = path.segment(1);
                            String dataset = path.segment(2);
                            String member = path.segment(3);
                            IPDHost host = null;
                            if (FaultAnalyzerReportEditor.this.getEditorInput() instanceof FaultAnalyzerReportEditorInput) {
                                host = ((FaultAnalyzerReportEditorInput)FaultAnalyzerReportEditor.this.getEditorInput()).getHost();
                            }
                            if (!(annotation = (Annotation)((TreeSelection)event.getSelection()).getFirstElement()).getType().equals("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.addr.annotation")) {
                                String linkText = annotation.getText().split(">", 2)[1];
                                String[] split = linkText.split("#");
                                OpenSectionHandler.openSection(host, address, service, dataset, member, split[0], split[1]);
                            } else {
                                OpenAddressHandler.open(host, address, service, dataset, member, "0");
                            }
                        }
                    });
                    this.getSite().setSelectionProvider((ISelectionProvider)tree);
                    tree.setInput((Object)FaultAnalyzerReportEditor.this);
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public void gotoMarker(IMarker marker) {
        for (ReportPage page : this.pages) {
            if (!FACorePlugin.getRoot().getFile(marker.getResource().getProjectRelativePath()).equals((Object)((IFileEditorInput)page.getEditorInput()).getFile())) continue;
            IGotoMarker gtm = (IGotoMarker)page.getAdapter(IGotoMarker.class);
            gtm.gotoMarker(marker);
            this.setActiveEditor((IEditorPart)page);
            break;
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void setActivePageTo(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.getPageCount()) {
            super.setActivePage(pageIndex);
        }
    }

    public static void reopenAllFaultAnalyzerReportEditorsOnActivePages() {
        HashMap<IEditorInput, Integer> openEditorsActivePages = new HashMap<IEditorInput, Integer>();
        HashMap<IEditorInput, Integer> openEditorsCaretOffsets = new HashMap<IEditorInput, Integer>();
        HashMap<IEditorInput, Integer> openEditorsTopOffset = new HashMap<IEditorInput, Integer>();
        IEditorReference[] iEditorReferenceArray = PDPlatformUIUtils.editor.getActiveEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            IEditorPart editor2 = iEditorReference.getEditor(false);
            if (editor2 instanceof FaultAnalyzerReportEditor) {
                int activePage = ((FaultAnalyzerReportEditor)editor2).getActivePage();
                IEditorInput inputFromEditorPartThreadSafe = PDPlatformUIUtils.editor.getInputFromEditorReference((IEditorReference)iEditorReference);
                openEditorsActivePages.put(inputFromEditorPartThreadSafe, activePage);
                Object selectedPage = ((FaultAnalyzerReportEditor)editor2).getSelectedPage();
                if (selectedPage instanceof ReportPage) {
                    ReportPage repPage = (ReportPage)((Object)selectedPage);
                    openEditorsCaretOffsets.put(inputFromEditorPartThreadSafe, repPage.getViewer().getTextWidget().getCaretOffset());
                    openEditorsTopOffset.put(inputFromEditorPartThreadSafe, repPage.getViewer().getTopIndex());
                }
            }
            ++n2;
        }
        for (final IEditorInput iEditorInput : openEditorsActivePages.keySet()) {
            PDPlatformUIUtils.editor.closeAllEditorsWithInput((PDPlatformUIUtils.editor.EditorInputTester)new PDPlatformUIUtils.editor.EditorInputTester(){

                public boolean test(IEditorInput input) {
                    return iEditorInput.equals(input);
                }
            });
        }
        for (Map.Entry entry : openEditorsActivePages.entrySet()) {
            Integer caretOffset;
            IEditorPart part = PDPlatformUIUtils.editor.openEditor((IEditorInput)((IEditorInput)entry.getKey()), (String)ID);
            if (!(part instanceof FaultAnalyzerReportEditor)) continue;
            ((FaultAnalyzerReportEditor)part).setActivePageTo((Integer)entry.getValue());
            Object selectedPage = ((FaultAnalyzerReportEditor)part).getSelectedPage();
            if (!(selectedPage instanceof ReportPage)) continue;
            ReportPage repPage = (ReportPage)((Object)selectedPage);
            Integer topIndex = (Integer)openEditorsTopOffset.get(entry.getKey());
            if (topIndex != null) {
                repPage.getViewer().setTopIndex(topIndex.intValue());
            }
            if ((caretOffset = (Integer)openEditorsCaretOffsets.get(entry.getKey())) == null) continue;
            repPage.getViewer().getTextWidget().setCaretOffset(caretOffset.intValue());
        }
    }

    public List<String> getHeaderList() {
        return this.headerList;
    }

    public class ReportTreeContentProvider
    implements ITreeContentProvider {
        List<Annotation> sections = new ArrayList<Annotation>();
        HashMap<Annotation, TreeMap<Integer, Annotation>> subsections = new HashMap();
        HashMap<Annotation, TreeMap<Integer, Annotation>> subsubsections = new HashMap();
        HashMap<Annotation, TreeMap<Integer, Annotation>> subsubsubsections = new HashMap();

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (this.subsections.containsKey(parentElement)) {
                return this.subsections.get(parentElement).values().toArray();
            }
            if (this.subsubsections.containsKey(parentElement)) {
                return this.subsubsections.get(parentElement).values().toArray();
            }
            if (this.subsubsubsections.containsKey(parentElement)) {
                return this.subsubsubsections.get(parentElement).values().toArray();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.sections.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (this.subsections.containsKey(element)) {
                return this.subsections.get(element).size() > 0;
            }
            if (this.subsubsections.containsKey(element)) {
                return this.subsubsections.get(element).size() > 0;
            }
            if (this.subsubsubsections.containsKey(element)) {
                return this.subsubsubsections.get(element).size() > 0;
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == FaultAnalyzerReportEditor.this.input && !FaultAnalyzerReportEditor.this.input.exists()) {
                return;
            }
            this.sections = new ArrayList<Annotation>();
            this.subsections = new HashMap();
            this.subsubsections = new HashMap();
            this.subsubsubsections = new HashMap();
            for (ReportPage page : FaultAnalyzerReportEditor.this.pages) {
                if (!(page.getEditorInput() instanceof IFileEditorInput)) break;
                IPath resource = ((IFileEditorInput)page.getEditorInput()).getFile().getProjectRelativePath();
                IMemento page_structure = ((ReportProvider)page.getDocumentProvider()).get_memento((IFileEditorInput)page.getEditorInput());
                TreeMap<Integer, Annotation> page_sections = new TreeMap<Integer, Annotation>();
                IMemento[] iMementoArray = page_structure.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.section");
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento section = iMementoArray[n2];
                    Annotation annotation = new Annotation("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.section.annotation", true, section.getString("tag") + String.valueOf(resource) + "#" + String.valueOf(section.getInteger("offset")));
                    page_sections.put(section.getInteger("offset"), annotation);
                    this.subsections.put(annotation, new TreeMap());
                    Position position = new Position(section.getInteger("offset").intValue(), section.getInteger("length").intValue());
                    IMemento[] iMementoArray2 = page_structure.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsection");
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento subsection = iMementoArray2[n4];
                        Integer suboffset = subsection.getInteger("offset");
                        if (position.includes(suboffset.intValue())) {
                            Annotation subannotation = new Annotation("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsection.annotation", true, subsection.getString("tag") + String.valueOf(resource) + "#" + String.valueOf(subsection.getInteger("offset")));
                            this.subsections.get(annotation).put(suboffset, subannotation);
                            this.subsubsections.put(subannotation, new TreeMap());
                            Position subposition = new Position(suboffset.intValue(), subsection.getInteger("length").intValue());
                            IMemento[] iMementoArray3 = page_structure.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsection");
                            int n5 = iMementoArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IMemento subsubsection = iMementoArray3[n6];
                                Integer subsuboffset = subsubsection.getInteger("offset");
                                if (subposition.includes(subsuboffset.intValue())) {
                                    Annotation h3Annotation = new Annotation("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsection.annotation", true, subsubsection.getString("tag") + String.valueOf(resource) + "#" + String.valueOf(subsubsection.getInteger("offset")));
                                    this.subsubsections.get(subannotation).put(subsuboffset, h3Annotation);
                                    this.subsubsubsections.put(h3Annotation, new TreeMap());
                                    Position h3Position = new Position(subsuboffset.intValue(), subsubsection.getInteger("length").intValue());
                                    IMemento[] iMementoArray4 = page_structure.getChildren("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsubsection");
                                    int n7 = iMementoArray4.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        IMemento h4Memento = iMementoArray4[n8];
                                        Integer h4Offset = h4Memento.getInteger("offset");
                                        if (h3Position.includes(h4Offset.intValue())) {
                                            Annotation h4Annotation = new Annotation("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.subsubsubsection.annotation", true, h4Memento.getString("tag") + String.valueOf(resource) + "#" + String.valueOf(h4Memento.getInteger("offset")));
                                            this.subsubsubsections.get(h3Annotation).put(h4Offset, h4Annotation);
                                        }
                                        ++n8;
                                    }
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
                this.sections.addAll(page_sections.values());
            }
            this.sections.add(new Annotation("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.addr.annotation", false, "<" + Messages.ReportsList_Minidump + ">"));
        }
    }

    public static class ReportTreeLabelProvider
    implements ILabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Annotation) {
                return ReportSetup.getSectionName(((Annotation)element).getText());
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

