/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class FADocumentUtils {
    private static final PDLogger logger = PDLogger.get(FADocumentUtils.class);

    static String getString(IDocument doc, int start, int length) {
        try {
            Objects.requireNonNull(doc, "Must provide a non-null document.");
            if (start < 0) {
                throw new IllegalArgumentException("length must be > 0");
            }
            if (length < 0) {
                throw new IllegalArgumentException("length must be >= 0");
            }
            return doc.get(start, length);
        }
        catch (IllegalArgumentException | NullPointerException | BadLocationException e) {
            logger.error((Object)(String.valueOf(e) + " " + Arrays.toString(e.getStackTrace())));
            return null;
        }
    }

    static boolean hasPrefix(IDocument doc, int wordStart, String prefix) {
        try {
            String leadingText;
            Objects.requireNonNull(doc, "Must provide non-null document.");
            if (wordStart < 0) {
                throw new IllegalArgumentException("Must provide a word_start >= 0");
            }
            Objects.requireNonNull(prefix, "Must provide a non-null prefix String.");
            if (wordStart - prefix.length() > 0 && (leadingText = doc.get(wordStart - prefix.length(), prefix.length())) != null && leadingText.trim().toLowerCase().contains(prefix.trim().toLowerCase())) {
                return true;
            }
        }
        catch (BadLocationException e) {
            logger.trace((Object)MessageFormat.format("Got a bad location: start: {0} prefix: {1} : {2}", new Object[]{wordStart, prefix, e}));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.error((Throwable)e);
        }
        return false;
    }

    static boolean hasSuffix(IDocument doc, int wordEnd, String suffix) {
        try {
            String followingText;
            Objects.requireNonNull(doc, "Must provide non-null document.");
            if (wordEnd < 0) {
                throw new IllegalArgumentException("Must provide a wordEnd >= 0");
            }
            Objects.requireNonNull(suffix, "Must provide a non-null suffix String.");
            if (wordEnd + suffix.length() <= doc.getLength() && (followingText = doc.get(wordEnd, suffix.length())) != null && followingText.trim().toLowerCase().contains(suffix.trim().toLowerCase())) {
                return true;
            }
        }
        catch (BadLocationException e) {
            logger.trace((Object)MessageFormat.format("Got a bad location: start: {0} suffix: {1} : {2}", new Object[]{wordEnd, suffix, e}));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.error((Throwable)e);
        }
        return false;
    }

    static int find(FindReplaceDocumentAdapter frda, int offset, String regex, boolean forwardSearch) {
        try {
            Objects.requireNonNull(frda, "Must provide a non-null FindReplaceDocumentAdapter.");
            Objects.requireNonNull(regex, "Must provide a non-null regex.");
            IRegion hexRegion = frda.find(offset, regex, forwardSearch, false, false, true);
            if (hexRegion != null) {
                return hexRegion.getOffset();
            }
        }
        catch (NullPointerException | BadLocationException e) {
            logger.trace((Object)MessageFormat.format("Got bad location for offset: {0} {1}", offset, e));
        }
        return -1;
    }

    static Region createRegion(int wordStart, int length) {
        if (wordStart < 0) {
            throw new IllegalArgumentException("wordStart must be >= 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        return new Region(wordStart, length);
    }
}

