/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class DeferredModel
extends ResourceMarkerAnnotationModel {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(DeferredModel.class);
    private final ResourceMarkerAnnotationModel backing_model;
    protected List<HashMap<String, Object>> backing_markers = new ArrayList<HashMap<String, Object>>();
    private boolean backing_initialized = false;
    private List<Long> md_pages = new ArrayList<Long>();
    private List<Long> ordered_md_pages = new ArrayList<Long>();
    private Set<ReadyListener> ready_listeners = new HashSet<ReadyListener>();

    public DeferredModel(IResource resource) {
        super(resource);
        this.backing_model = new ResourceMarkerAnnotationModel(resource);
    }

    public void add_ready_listener(ReadyListener _listener) {
        if (this.ready() && !this.ready_listeners.contains(_listener)) {
            _listener.on_ready(this);
        }
        this.ready_listeners.add(_listener);
    }

    public long get_address(int _line) {
        if (_line % 129 == 128) {
            return -1L;
        }
        return this.ordered_md_pages.get(_line / 129) + (long)(_line % 129 * 32);
    }

    public int get_line(long _address) {
        int i = 0;
        while (i < this.ordered_md_pages.size()) {
            Long page_address = this.ordered_md_pages.get(i);
            if (_address >= page_address && _address < page_address + 4096L) {
                return (int)((long)(i * 129) + (_address - page_address) / 32L);
            }
            ++i;
        }
        return -1;
    }

    public Iterator getAnnotationIterator(int offset, int length, boolean canStartBefore, boolean canEndAfter) {
        return this.getAnnotationIterator();
    }

    public Iterator<Annotation> getBackingIterator() {
        return this.backing_model.getAnnotationIterator();
    }

    public Position getBackingPosition(Annotation annotation) {
        return this.backing_model.getPosition(annotation);
    }

    private void on_ready() {
        this.backing_initialized = true;
        IDocument document = this.fDocument;
        super.reinitialize(document);
        for (ReadyListener listener : this.ready_listeners) {
            listener.on_ready(this);
        }
    }

    public boolean ready() {
        return this.backing_initialized;
    }

    public void remove_ready_listener(ReadyListener _listener) {
        this.ready_listeners.remove(_listener);
    }

    public void setup() {
        try {
            this.setup((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            logger.info((Object)Messages.DeferredModel_Cancelled);
        }
    }

    public void setup(IProgressMonitor monitor) throws InterruptedException {
        XMLMemento memento = MementoUtils.loadXMLMementoFromIFile((IFile)FACorePlugin.getRoot().getFile(this.getResource().getProjectRelativePath()), (boolean)true, (Charset)StandardCharsets.UTF_8, (IProgressMonitor)monitor);
        if (memento != null) {
            IMemento li;
            IMemento[] iMementoArray = memento.getChild("ol").getChildren("li");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                li = iMementoArray[n2];
                this.md_pages.add(Long.parseLong(li.getTextData()));
                ++n2;
            }
            this.ordered_md_pages.addAll(this.md_pages);
            Collections.sort(this.ordered_md_pages);
            iMementoArray = memento.getChild("ul").getChildren("li");
            n = iMementoArray.length;
            n2 = 0;
            while (n2 < n) {
                li = iMementoArray[n2];
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.DeferredModel_Cancelled);
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("message", li.getTextData());
                attributes.put("location", Long.toHexString(Long.parseLong(li.getString("address"))).toUpperCase());
                this.backing_markers.add(attributes);
                ++n2;
            }
            this.on_ready();
        } else {
            StatusManager.getManager().handle((IStatus)new Status(1, "com.ibm.etools.fa.pdtclient.core", Messages.DeferredModel_ErrorOccurredWhileReadingDump), 3);
        }
    }

    public void teardown() {
    }

    public void update_markers() {
        this.resetMarkers();
        try {
            IMarker[] markers = this.getResource().findMarkers("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.usernote.marker", true, 0);
            for (HashMap<String, Object> attribute : this.backing_markers) {
                try {
                    boolean exists = false;
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        Object location = marker.getAttribute("location");
                        if (location != null && location.equals(attribute.get("location"))) {
                            exists = true;
                            break;
                        }
                        ++n2;
                    }
                    if (exists) continue;
                    MarkerUtilities.createMarker((IResource)this.getResource(), attribute, (String)"com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.usernote.marker");
                }
                catch (CoreException e) {
                    logger.warn((Throwable)e);
                }
            }
        }
        catch (CoreException e) {
            logger.warn((Throwable)e);
        }
    }

    public static interface ReadyListener {
        public void on_ready(DeferredModel var1);
    }
}

