/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.statushandlers.StatusManager;

public class DeferredDocument
extends Document {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(DeferredDocument.class);
    private boolean backing_initialized = false;
    private HashSet<ReadyListener> ready_listeners = new HashSet();
    private IFileEditorInput input;
    private static final String LINE_DELIMITER = "\n";
    public static final String zero_decoded_text = "*................................*";
    public static final String zero_line = "00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000  *................................* *................................*\n";
    public static final String empty_line = "                                                                                                                                             ";
    public static final int line_length = "00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000  *................................* *................................*\n".length();
    public static final int page_length = 129 * "00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000 \n".length();
    private long current_page = 0L;
    private List<Long> md_pages = new ArrayList<Long>();
    private List<Long> ordered_md_pages = new ArrayList<Long>();
    private RandomAccessFile file = null;
    private Charset charset = FARL.CHARSET_ENGLISH;
    private String invalidCharacterPattern;
    private boolean ignoreMultibyteCharacters = false;
    private boolean persistentEBCDIC = false;
    private String host = null;

    public DeferredDocument(IFileEditorInput element) {
        this.set(Messages.DeferredDocument_Initializing);
        this.input = element;
    }

    public void add_ready_listener(ReadyListener _listener) {
        if (this.ready() && !this.ready_listeners.contains(_listener)) {
            _listener.on_ready(this);
        }
        this.ready_listeners.add(_listener);
    }

    public String get() {
        return "";
    }

    public String get(int pos, int length) {
        int toPos;
        int start_line = this.getLineOfOffset(pos);
        int end_line = this.getLineOfOffset(pos + length);
        StringBuilder text = new StringBuilder();
        int i = start_line;
        while (i <= end_line) {
            text.append(this.get_line(i));
            ++i;
        }
        int fromPos = pos % this.getLineLength();
        if (fromPos < 0) {
            fromPos = 0;
            logger.printCurrentStackTrace("position is negative?");
        }
        if (fromPos > text.length()) {
            fromPos = text.length();
        }
        if ((toPos = fromPos + length) > text.length()) {
            toPos = text.length();
        }
        return text.substring(fromPos, toPos);
    }

    public String get_line(int _line) {
        String line;
        block7: {
            if (this.file == null) {
                try {
                    this.file = new RandomAccessFile(this.input.getFile().getLocation().removeFileExtension().addFileExtension("dump").toFile(), "r");
                }
                catch (FileNotFoundException e) {
                    logger.warn((Throwable)e);
                }
            }
            try {
                int page_index = _line / 129;
                if (page_index == this.ordered_md_pages.size()) {
                    --page_index;
                }
                Long pageValue = this.ordered_md_pages.get(page_index);
                int indexOfPage = this.md_pages.indexOf(pageValue);
                int seekLength = indexOfPage * page_length + _line % 129 * 73;
                this.file.seek(seekLength);
                byte[] bytes = new byte[72];
                this.file.readFully(bytes);
                line = new String(bytes, StandardCharsets.UTF_8);
                if (!line.trim().isEmpty()) break block7;
                return empty_line;
            }
            catch (IOException iOException) {
                return "";
            }
        }
        return this.getMinidumpLine(line);
    }

    public char getChar(int pos) throws BadLocationException {
        String line = this.get_line(this.getLineOfOffset(pos)) + LINE_DELIMITER;
        return line.charAt(pos % this.getLineLength());
    }

    public String[] getLegalLineDelimiters() {
        return new String[]{LINE_DELIMITER};
    }

    public int getLength() {
        long lineLength;
        long numberOfLines = this.getNumberOfLines();
        long length = numberOfLines * (lineLength = (long)line_length) - 1L;
        if (length > Integer.MAX_VALUE) {
            logger.error((Object)MessageFormat.format("Maximum document length exceeded; ({0}) length. Truncating length to Integer.MAX_VALUE ({1})", length, Integer.MAX_VALUE));
            length = Integer.MAX_VALUE;
        }
        return (int)length;
    }

    public String getLineDelimiter() {
        return LINE_DELIMITER;
    }

    public String getLineDelimiter(int line) throws BadLocationException {
        return this.getLineDelimiter();
    }

    public IRegion getLineInformation(int line) throws BadLocationException {
        return new Region(this.getLineOffset(line), this.getLineLength() - 1);
    }

    public IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
        return this.getLineInformation(this.getLineOfOffset(offset));
    }

    public int getLineLength() {
        return line_length;
    }

    public int getLineLength(int line) throws BadLocationException {
        return this.getLineLength();
    }

    public int getLineOffset(int line) {
        return line * this.getLineLength();
    }

    public int getLineOfOffset(int pos) {
        return pos / this.getLineLength();
    }

    public int getNumberOfLines() {
        int lines = this.pages() * 129 - 1;
        return lines;
    }

    public int getNumberOfLines(int offset, int length) throws BadLocationException {
        return this.getLineOfOffset(offset + length) - this.getLineOfOffset(offset) + 1;
    }

    private void on_ready() {
        this.backing_initialized = true;
        for (ReadyListener listener : this.ready_listeners) {
            listener.on_ready(this);
        }
    }

    public int pages() {
        return this.md_pages.size();
    }

    public boolean ready() {
        return this.backing_initialized;
    }

    public void remove_ready_listener(ReadyListener _listener) {
        this.ready_listeners.remove(_listener);
    }

    public void replace(int pos, int length, String text, long modificationStamp) throws BadLocationException {
    }

    public void setup(IProgressMonitor monitor) throws InterruptedException {
        int MAX_MINI_DUMP_PAGES = Integer.MAX_VALUE / (129 * line_length);
        this.md_pages.clear();
        this.ordered_md_pages.clear();
        XMLMemento memento = MementoUtils.loadXMLMementoFromIFile((IFile)this.input.getFile(), (boolean)true, (Charset)StandardCharsets.UTF_8, (IProgressMonitor)monitor);
        if (memento != null) {
            int numPages = 0;
            IMemento[] iMementoArray = memento.getChild("ol").getChildren("li");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento li = iMementoArray[n2];
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.DeferredDocument_Cancelled);
                }
                if (this.md_pages.size() < MAX_MINI_DUMP_PAGES) {
                    this.md_pages.add(Long.parseLong(li.getTextData()));
                    ++numPages;
                } else {
                    String errorMsg = MessageFormat.format("Maximum minidump pages limit reached; This is an eclipse limitation unfortunately; the first {0} will be visible.", numPages);
                    logger.error((Object)errorMsg);
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.ibm.etools.fa.pdtclient.core", errorMsg), 3);
                    break;
                }
                ++n2;
            }
            this.ordered_md_pages.addAll(this.md_pages);
            Collections.sort(this.ordered_md_pages);
            logger.trace((Object)("Minidump pages: " + this.ordered_md_pages.size()));
        }
        this.on_ready();
    }

    public String show_next() {
        int index = this.ordered_md_pages.indexOf(this.current_page);
        if (index == this.ordered_md_pages.size() - 1) {
            return null;
        }
        return this.show_page(this.ordered_md_pages.get(index + 1));
    }

    public String show_page(long _address) {
        if (this.file == null) {
            return null;
        }
        int load = -1;
        int i = 0;
        while (i < this.md_pages.size()) {
            Long page = this.md_pages.get(i);
            if (_address >= page && _address < page + 4096L) {
                load = i;
                break;
            }
            ++i;
        }
        if (load == -1) {
            logger.debug((Object)(Messages.DeferredDocument_Adress + _address + Messages.DeferredDocument_NotFound));
            return null;
        }
        try {
            this.file.seek(load * page_length);
            byte[] bytes = new byte[page_length];
            this.file.readFully(bytes);
            String page_hex = new String(bytes, StandardCharsets.UTF_8);
            StringBuilder string = new StringBuilder();
            int i2 = 0;
            while (i2 < 128) {
                String line = page_hex.substring(i2 * 73, i2 * 73 + 72);
                string.append(this.getMinidumpLine(line));
                ++i2;
            }
            this.current_page = this.md_pages.get(load);
            return string.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String show_prev() {
        int index = this.ordered_md_pages.indexOf(this.current_page);
        if (index == 0) {
            return null;
        }
        return this.show_page(this.ordered_md_pages.get(index - 1));
    }

    public void teardown() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                logger.warn((Throwable)e);
            }
        }
    }

    public void setEncodingCharSet(Charset charset) {
        this.charset = charset;
    }

    private String getMinidumpLine(String hexLine) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(hexLine);
        if (this.persistentEBCDIC) {
            Charset oldCharset = this.charset;
            boolean oldIgnoreMultibyteCharacters = this.ignoreMultibyteCharacters;
            String oldInvalidCharacterPattern = this.invalidCharacterPattern;
            if (this.host != null) {
                Charset systemCharset = CharsetResponseHelper.getCharsetFromSystem(this.host);
                this.setEncodingCharSet(systemCharset);
            } else {
                this.setEncodingCharSet(FARL.CHARSET_ENGLISH);
            }
            this.setInvalidCharacterPattern("\\P{Print}");
            this.setIgnoreMultibyteCharacters(false);
            sb.append(" ");
            sb.append("*");
            sb.append(this.decodeHexString(hexLine));
            sb.append("*");
            this.setEncodingCharSet(oldCharset);
            this.setIgnoreMultibyteCharacters(oldIgnoreMultibyteCharacters);
            this.setInvalidCharacterPattern(oldInvalidCharacterPattern);
        }
        sb.append(" ");
        sb.append("*");
        sb.append(this.decodeHexString(hexLine));
        sb.append("*");
        int paddingLengthToAdd = this.getLineLength() - sb.length() - 1;
        int i = 0;
        while (i < paddingLengthToAdd) {
            sb.append(" ");
            ++i;
        }
        sb.append(this.getLineDelimiter());
        return sb.toString();
    }

    private String decodeHexString(String hexLine) throws UnsupportedEncodingException {
        String replacement = ".";
        String hex = hexLine.replaceAll(" ", "");
        byte[] hexBytes = new byte[32];
        int i = 0;
        while (i < hexBytes.length) {
            String hexSubstring = hex.substring(i << 1, i + 1 << 1);
            byte hexByte = (byte)Integer.parseInt(hexSubstring, 16);
            if (this.ignoreMultibyteCharacters && (hexByte < 32 || hexByte == 127)) {
                hexByte = 0;
            }
            hexBytes[i] = hexByte;
            ++i;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(hexBytes);
        CharsetDecoder decoder = this.charset.newDecoder();
        decoder.replaceWith(replacement);
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer charBuffer = null;
        try {
            charBuffer = decoder.decode(byteBuffer);
        }
        catch (CharacterCodingException e) {
            logger.warn((Object)(Messages.DeferredDocument_MinidumpHexDecodingFailed + hexLine + "'"), (Throwable)e);
            return zero_decoded_text;
        }
        String decodedString = charBuffer.toString();
        decodedString = decodedString.replaceAll("\\s", " ");
        if (this.invalidCharacterPattern == null || this.invalidCharacterPattern.isEmpty()) {
            this.setInvalidCharacterPattern("\\P{Print}");
        }
        decodedString = decodedString.replaceAll(this.invalidCharacterPattern, replacement);
        return decodedString;
    }

    public void setInvalidCharacterPattern(String invalidCharacterPattern) {
        this.invalidCharacterPattern = invalidCharacterPattern;
    }

    public void setIgnoreMultibyteCharacters(boolean b) {
        this.ignoreMultibyteCharacters = b;
    }

    public void setPersistentEBCDIC(boolean b) {
        this.persistentEBCDIC = b;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public static interface ReadyListener {
        public void on_ready(DeferredDocument var1);
    }
}

