/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.report.DeferredDocument;
import com.ibm.etools.fa.pdtclient.ui.report.DeferredModel;
import com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class AddUserNoteHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(AddUserNoteHandler.class);
    public static final String PARAM_ADDR = "com.ibm.etools.fa.pdtclient.ui.param.dumpaddr";

    protected void handle(ExecutionEvent event) {
        if ("com.ibm.etools.fa.pdtclient.ui.report.MinidumpPage".equals(HandlerUtil.getActiveEditorId((ExecutionEvent)event))) {
            MinidumpPage editor2 = (MinidumpPage)HandlerUtil.getActiveEditor((ExecutionEvent)event);
            IPath path = ((IFileEditorInput)editor2.getEditorInput()).getFile().getProjectRelativePath();
            logger.trace((Object)("Adding note to " + String.valueOf(path)));
            String address = path.segment(0);
            String service = path.segment(1);
            String dataset = path.segment(2);
            String member = path.segment(3);
            ITextSelection selection = (ITextSelection)editor2.getSelectionProvider().getSelection();
            DeferredDocument doc = (DeferredDocument)editor2.getDocumentProvider().getDocument((Object)editor2.getEditorInput());
            DeferredModel model = (DeferredModel)editor2.getDocumentProvider().getAnnotationModel((Object)editor2.getEditorInput());
            long addr = model.get_address(selection.getStartLine());
            new HashMap<String, CallSite>(event.getParameters()).put(PARAM_ADDR, (CallSite)((Object)((addr += (long)((selection.getOffset() - doc.getLineOffset(selection.getStartLine())) / 9 * 4 + (selection.getOffset() - doc.getLineOffset(selection.getStartLine())) % 9 / 2)) + ":" + selection.getLength())));
            InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.AddUserNoteHandler_AddMarker, Messages.AddUserNoteHandler_AddMarker, "", null){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setSize(500, 300);
                }

                protected Control createDialogArea(Composite parent) {
                    Control control = super.createDialogArea(parent);
                    GridData data = new GridData(256, 16, true, false);
                    data.widthHint = 500;
                    data.heightHint = 300;
                    this.getText().setLayoutData((Object)data);
                    return control;
                }

                protected int getInputTextStyle() {
                    return 2050;
                }
            };
            if (dialog.open() == 0 && !dialog.getValue().trim().isEmpty()) {
                String value = dialog.getValue().trim();
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("message", value);
                attributes.put("charStart", selection.getOffset());
                attributes.put("charEnd", selection.getOffset() + selection.getLength());
                IFile resource = FAResourceUtils.getFaultEntryMDMLFile((String)address, (String)service, (String)dataset, (String)member);
                try {
                    MarkerUtilities.createMarker((IResource)resource, attributes, (String)"org.eclipse.core.resources.bookmark");
                }
                catch (CoreException e) {
                    logger.warn((Throwable)e);
                }
            }
        }
    }
}

