/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.report;

import com.ibm.etools.fa.pdtclient.ui.report.DeferredModel;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor;
import com.ibm.etools.fa.pdtclient.ui.report.ReportHyperlink;
import com.ibm.etools.fa.pdtclient.ui.report.ReportPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class AFAReportLinkDetector
extends AbstractHyperlinkDetector {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ReportPage page;
    private final FaultAnalyzerReportEditor editor;
    private final String[] linkTypes = new String[]{"com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.code.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.line.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.evnt.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.openFile.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.psw31.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.psw64.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.stmt.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsAsync.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsTraceLinkAnalysis.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsTransactionStorageFilter.annotation", "com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.addr.annotation"};

    public AFAReportLinkDetector(ReportPage _page, FaultAnalyzerReportEditor _editor) {
        this.page = Objects.requireNonNull(_page, "Must specify non-null page.");
        this.editor = Objects.requireNonNull(_editor, "Must specify non-null editor.");
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IAnnotationModel model = this.getPageAnnotationModel();
        if (model instanceof DeferredModel && !((DeferredModel)model).ready()) {
            return null;
        }
        if (model != null) {
            Iterator annotations = model.getAnnotationIterator();
            ArrayList<ReportHyperlink> links = new ArrayList<ReportHyperlink>();
            while (annotations.hasNext()) {
                Annotation annotation = (Annotation)annotations.next();
                String[] stringArray = this.linkTypes;
                int n = this.linkTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Position position;
                    String linkType = stringArray[n2];
                    if (linkType.equals(annotation.getType()) && (position = model.getPosition(annotation)).includes(region.getOffset())) {
                        links.add(new ReportHyperlink((IRegion)new Region(position.getOffset(), position.getLength()), annotation.getText(), ((IFileEditorInput)this.editor.getEditorInput()).getFile().getProjectRelativePath().toString(), textViewer.getDocument(), model));
                    }
                    ++n2;
                }
                if (!annotation.getType().equals("com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor.link.cicsTraceLinkAnalysis.annotation")) continue;
                Position position = model.getPosition(annotation);
                StyleRange styleRange = new StyleRange();
                styleRange.start = position.getOffset();
                styleRange.length = position.getLength();
                styleRange.fontStyle = 1;
                styleRange.foreground = Display.getDefault().getSystemColor(9);
                textViewer.getTextWidget().setStyleRange(styleRange);
                if (!position.includes(region.getOffset())) continue;
                links.add(new ReportHyperlink((IRegion)new Region(position.getOffset(), position.getLength()), annotation.getText(), ((IFileEditorInput)this.editor.getEditorInput()).getFile().getProjectRelativePath().toString(), textViewer.getDocument(), model));
            }
            if (!links.isEmpty()) {
                return links.toArray(new IHyperlink[0]);
            }
        }
        return null;
    }

    protected IEditorInput getEditorInput() {
        return this.editor.getEditorInput();
    }

    protected IAnnotationModel getPageAnnotationModel() {
        return this.page.getDocumentProvider().getAnnotationModel((Object)this.page.getEditorInput());
    }

    protected boolean isStringANonAddress(String s) {
        return this.editor.nonaddresses.contains(s);
    }
}

