/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.impl.view;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.faobjects.FaultAnalyzerParameters;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.impl.system.AddSystem;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewFaultAnalyzerRootNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.XMLMemento;

public abstract class RefreshView {
    private static PDLogger logger;

    public static PDLogger getLogger() {
        if (logger == null) {
            logger = PDLogger.get(RefreshView.class);
        }
        return logger;
    }

    public static void refreshView(String address, String port, final String dataset, SystemsTreeNode target) {
        URI uri;
        RefreshView.checkParameterIsNotNullOrEmpty(address, "address");
        RefreshView.checkParameterIsNotNullOrEmpty(port, "port");
        RefreshView.checkParameterIsNotNullOrEmpty(dataset, "dataset");
        final AtomicReference isViewDataSetError = new AtomicReference();
        final ArrayList oldViewList = new ArrayList();
        final ArrayList newViewList = new ArrayList();
        final IFolder system = FAResourceUtils.getSystemFolder((String)address, (String)port);
        if (!system.exists()) {
            AddSystem.addSystem(address, port);
        }
        String hf = dataset;
        if (dataset.equals("last accessed")) {
            hf = "";
        }
        if ((uri = FARL.getFARLURI((String)address, (String)port, (String)hf)) == null) {
            return;
        }
        RefreshView.getLogger().trace((Object)("RefreshView refreshing " + String.valueOf(uri)));
        FATPJob job = new FATPJob(Messages.RefreshViewHandler_Refreshing_view_dataset, FARL.get_view((URI)uri)){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void finalize_responses(IProgressMonitor _mon) {
                var3_2 = this.responses.iterator();
                while (true) {
                    if (!var3_2.hasNext()) {
                        return;
                    }
                    request_response = (FATP[])var3_2.next();
                    var4_4 = null;
                    var5_6 = null;
                    try {
                        block34: {
                            block33: {
                                block36: {
                                    block37: {
                                        block35: {
                                            request = request_response[0];
                                            try {
                                                block32: {
                                                    response = request_response[1];
                                                    if (!response.is_successful_response()) {
                                                        if (response == null) break block32;
                                                    }
                                                    ** GOTO lbl-1000
                                                    response.close();
                                                }
                                                if (request == null) continue;
                                            }
                                            catch (Throwable var5_7) {
                                                if (var4_4 == null) {
                                                    var4_4 = var5_7;
                                                } else if (var4_4 != var5_7) {
                                                    var4_4.addSuppressed(var5_7);
                                                }
                                                if (request == null) throw var4_4;
                                                request.close();
                                                throw var4_4;
                                            }
                                            request.close();
                                            continue;
lbl-1000:
                                            // 1 sources

                                            {
                                                status_code = response.get_status_code();
                                                if (!status_code.equals("200")) break block33;
                                                content_type = response.get_entity_header("Content-Type").split(";", 2);
                                                media_type = content_type[0].trim();
                                                content_encoding = response.get_entity_header("Content-Encoding");
                                                if (!content_encoding.equals("identity") && !content_encoding.equals("") || !media_type.isEmpty() && !media_type.equals("text/xml") && !media_type.equals("text/plain")) break block34;
                                                charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.get_entity_header("Content-Type"));
                                                contents = response.get_body(charset).replaceAll("\u0000", " ");
                                                if (!contents.isEmpty()) ** GOTO lbl-1000
                                                if (response == null) break block35;
                                            }
                                            response.close();
                                        }
                                        if (request == null) continue;
                                        request.close();
                                        continue;
lbl-1000:
                                        // 1 sources

                                        {
                                            server_local = FACorePlugin.getRoot().getFolder(request.getHostOSPath());
                                            memento = MementoUtils.loadXMLMementoFromString((String)contents);
                                            if (memento != null && memento.getType().equals("ul")) break block36;
                                            if (response == null) break block37;
                                        }
                                        response.close();
                                    }
                                    if (request == null) return;
                                    request.close();
                                    return;
                                }
                                ** try [egrp 8[TRYBLOCK] [3 : 288->869)] { 
lbl60:
                                // 1 sources

                                var19_24 = memento.getChildren("li");
                                var18_23 = var19_24.length;
                                var17_21 = 0;
                                while (var17_21 < var18_23) {
                                    li = var19_24[var17_21];
                                    url = li.getString("id");
                                    if (url != null && !url.isEmpty()) {
                                        request_uri = request.get_request_uri().substring(1);
                                        view = li.getChild("ul");
                                        if (request_uri.isEmpty()) {
                                            var26_31 = view.getChildren("li");
                                            var25_30 = var26_31.length;
                                            var24_29 = 0;
                                            while (var24_29 < var25_30) {
                                                lahf = var26_31[var24_29];
                                                ul = XMLMemento.createWriteRoot((String)"ul");
                                                hist_li = ul.createChild("li");
                                                hist_li.putTextData(lahf.getTextData().trim().toUpperCase());
                                                localFile = server_local.getFile(lahf.getTextData().trim().toUpperCase() + ".hfml");
                                                if (!localFile.exists()) {
                                                    IResourceUtils.createEmptyIFile((IFile)localFile, (boolean)true, (IProgressMonitor)_mon, (boolean)false);
                                                    MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)ul, (IFile)localFile, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)_mon);
                                                }
                                                ++var24_29;
                                            }
                                            break;
                                        }
                                        history_file = server_local.getFile(request_uri + "(" + url + ").hfml");
                                        if (!history_file.exists()) {
                                            IResourceUtils.createEmptyIFile((IFile)history_file, (boolean)true, (IProgressMonitor)_mon, (boolean)false);
                                        }
                                        if (view != null && view instanceof XMLMemento) {
                                            MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)((XMLMemento)view), (IFile)history_file, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)_mon);
                                            newViewList.add(history_file.getName());
                                        }
                                    }
                                    ++var17_21;
                                }
                                for (IResource member : IResourceUtils.ls((IFolder)system, (IProgressMonitor)new NullProgressMonitor(), (boolean)false)) {
                                    oldViewList.add(member.getName());
                                }
                                oldViewList.removeIf((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)((ArrayList)newViewList));
                                for (IResource member : IResourceUtils.ls((IFolder)system, (IProgressMonitor)new NullProgressMonitor(), (boolean)false)) {
                                    for (String name : oldViewList) {
                                        if (!member.getName().startsWith(dataset + "(") || !name.equals(member.getName())) continue;
                                        IResourceUtils.deleteIResource((IResource)member, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
                                    }
                                }
                                break block34;
                            }
                            if (status_code.equals("204") && !"TRACE".equals(request.get_request_method()) && !"DEBUG".equals(request.get_request_method())) {
                                isViewDataSetError.set(response.get_status_reason_phrase());
                            }
                            break block34;
lbl116:
                            // 1 sources

                            finally {
                                if (response != null) {
                                    response.close();
                                }
                            }
                        }
                        if (request == null) continue;
                        request.close();
                    }
                    catch (Throwable var5_8) {
                        if (var4_4 == null) {
                            var4_4 = var5_8;
                            throw var4_4;
                        }
                        if (var4_4 == var5_8) throw var4_4;
                        var4_4.addSuppressed(var5_8);
                        throw var4_4;
                    }
                }
            }
        };
        try {
            job.set_user(FaultAnalyzerParameters.getUserFromHost(address, port, PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor())));
        }
        catch (InterruptedException e) {
            RefreshView.getLogger().error((Throwable)e);
            return;
        }
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (isViewDataSetError.get() == null) {
                    Activator.updateAll(SystemsViewFaultAnalyzerRootNode.class);
                } else if ("No Content".equals(isViewDataSetError.get()) && "last accessed".equals(dataset)) {
                    PDDialogs.openInfoThreadSafe((String)Messages.RefreshView_0);
                } else {
                    PDDialogs.openErrorThreadSafe((String)Messages.RefreshViewHandler_Error_response, (String)Messages.RefreshViewHandler_Not_a_view_dataset);
                }
            }
        });
        job.schedule();
    }

    protected static <T> T checkParameterIsNotNullOrEmpty(T parameter, String parameterLabel) {
        Objects.requireNonNull(parameterLabel, "Must specify a non-null parameterLabel.");
        Objects.requireNonNull(parameter, "Must specify a non-null " + parameterLabel + ".");
        if (parameter instanceof String && ((String)parameter).trim().isEmpty()) {
            throw new IllegalArgumentException("Must specify a non-empty " + parameterLabel + ".");
        }
        return parameter;
    }
}

