/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.impl.view;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.Validator;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.editor.localview.OpenLocalViewEditorHandler;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.SingleComboInputDialog;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.StringVerifiers;
import com.ibm.etools.fa.pdtclient.ui.impl.system.AddSystem;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.XMLMemento;

public abstract class CreateView {
    public static String promptForViewName(final String hostName, final String port) {
        final AtomicReference viewName = new AtomicReference();
        final SingleComboInputDialog dialog = new SingleComboInputDialog(Messages.MissingParameters_CreateViewTitle, Messages.CreateViewHandler_0, Messages.CreateViewHandler_1, CreateView.class.getCanonicalName() + ".handle", "", new IInputValidator(){

            public String isValid(String newText) {
                if (!newText.trim().isEmpty()) {
                    if (FAResourceUtils.getSpecifiedLocalViewHFMLFile((String)hostName, (String)port, (String)newText).exists()) {
                        return Messages.CreateViewHandler_2;
                    }
                    if (!Validator.validateSegment((String)newText.trim())) {
                        return Messages.CreateViewHandler_3;
                    }
                    return null;
                }
                return Messages.CreateViewHandler_4;
            }
        }, Arrays.asList(StringVerifiers.QUOTE_REMOVER, StringVerifiers.STRING_TRIM, StringVerifiers.UPPERCASER));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (dialog.open() != 1) {
                    viewName.set(dialog.getChoice());
                }
            }
        });
        return (String)viewName.get();
    }

    @Deprecated
    public static void createView(SystemsTreeNode target, String hostName, String port, String view2) {
        CreateView.createView(target, null, hostName, port, view2);
    }

    public static void createView(SystemsTreeNode target, IPDHost host, String hostName, String port, String view2) {
        Objects.requireNonNull(hostName);
        Objects.requireNonNull(port);
        Objects.requireNonNull(view2);
        AddSystem.addSystem(hostName, port);
        IFile file = FAResourceUtils.getSpecifiedLocalViewHFMLFile((String)hostName, (String)port, (String)view2);
        PDLogger.get(CreateView.class).trace((Object)("Creating view: " + String.valueOf(file)));
        if (!file.exists()) {
            IResourceUtils.createEmptyIFile((IFile)file, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
            XMLMemento memento = XMLMemento.createWriteRoot((String)"ul");
            memento.putTextData("");
            MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)memento, (IFile)file, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
            Activator.updateAll(target);
            if (target != null) {
                if (host == null) {
                    host = PDTreeHandlerUtil.getSystemFrom((Object)target);
                }
                if (host != null) {
                    OpenLocalViewEditorHandler.openLocalView(host, view2);
                }
            }
        } else {
            PDDialogs.openErrorThreadSafe((String)Messages.MissingParameters_CreateViewTitle, (String)Messages.FaSystemsView_ViewAlreadyExist);
        }
    }
}

