/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.impl.system;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.editor.localview.LocalViewEditorInput;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class RemoveSystem {
    public static boolean removeHostLocalObjects(String address, String port, IProgressMonitor monitor) {
        String formattedSystemPartName;
        String reportsListPartName;
        Objects.requireNonNull(address, "Must provide a non-null address.");
        Objects.requireNonNull(port, "Must provide a non-null port.");
        final IFolder system = FAResourceUtils.getSystemFolder((String)address, (String)port);
        PDPlatformUIUtils.editor.closeAllEditorsWithInput((PDPlatformUIUtils.editor.EditorInputTester)new PDPlatformUIUtils.editor.EditorInputTester(){

            public boolean test(IEditorInput input) {
                return input instanceof IFileEditorInput && system.getProjectRelativePath().isPrefixOf(((IFileEditorInput)input).getFile().getProjectRelativePath());
            }
        });
        ReportsList reportsList = ReportsList.getIfOpen();
        if (reportsList != null && (reportsListPartName = reportsList.getPartName()).startsWith(formattedSystemPartName = ReportsList.formatPartName(system.getProjectRelativePath().toString()))) {
            reportsList.reset();
        }
        IResourceUtils.deleteIFolder((IFolder)system, (boolean)true, (boolean)false, (IProgressMonitor)monitor, (boolean)false);
        if (system.getParent().exists() && system.getParent().getType() == 2 && IResourceUtils.ls((IContainer)system.getParent(), (IProgressMonitor)monitor, (boolean)false).isEmpty()) {
            IResourceUtils.deleteIResource((IResource)system.getParent(), (boolean)true, (boolean)false, (IProgressMonitor)monitor, (boolean)false);
        }
        PDPlatformUIUtils.editor.closeAllEditorsWithInput((PDPlatformUIUtils.editor.EditorInputTester)new PDPlatformUIUtils.editor.EditorInputTester(){

            public boolean test(IEditorInput input) {
                return input instanceof LocalViewEditorInput && system.getProjectRelativePath().isPrefixOf(((LocalViewEditorInput)input).getLocalViewFile().getProjectRelativePath());
            }
        });
        return true;
    }

    public static void remove(String address, String port, IProgressMonitor monitor) {
        IFolder system = FAResourceUtils.getSystemFolder((String)address, (String)port);
        if (system.exists() && PDDialogs.openConfirmThreadSafe((String)Messages.RemoveSystemHandler_RemovingSystem, (String)MessageFormat.format("{0} {1} {2}", address, port, Messages.RemoveSystemHandler_BookmarksAndTasksWillBeDeleted))) {
            RemoveSystem.removeHostLocalObjects(address, port, monitor);
            ReportsList reportList = ReportsList.getIfOpen();
            if (reportList != null) {
                reportList.refresh();
            }
        }
    }
}

