/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.impl.historyfile;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RefreshHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewBrowseHistoryFileNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class RemoveHistoryFile {
    private static final List<HistoryFileDeletedCallback> histroyFileDeleteCallback = new ArrayList<HistoryFileDeletedCallback>();
    private static PDLogger logger = PDLogger.get(RefreshHistoryFile.class);

    public static void removeHistoryFile(SystemsTreeNode target, String address, String port, String dataSet, String member, boolean checkWithUser) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(port);
        Objects.requireNonNull(dataSet);
        PDLogger.get(RemoveHistoryFile.class).trace((Object)MessageFormat.format("Removing history file {0} {1} {2} {3}", address, port, dataSet, member));
        IPath path = FAResourceUtils.getHistoryFileFolderRelativePath((String)address, (String)port, (String)dataSet);
        if (member != null && !member.trim().isEmpty()) {
            if (checkWithUser && !PDDialogs.openConfirm((String)"Removing View ", (String)(member + " " + Messages.RemoveHistoryFileHandler_ConfirmRemoveView))) {
                return;
            }
            path = path.removeLastSegments(1).append(dataSet + "(" + member + ")");
        } else {
            if (checkWithUser && !PDDialogs.openConfirm((String)Messages.RemoveHistoryFileHandler_RemovingHistoryFile, (String)(dataSet + " " + Messages.RemoveHistoryFileHandler_BookmarksAndTasksWillBeDeleted))) {
                return;
            }
            final IPath ref = path;
            PDPlatformUIUtils.editor.closeAllEditorsWithInput((PDPlatformUIUtils.editor.EditorInputTester)new PDPlatformUIUtils.editor.EditorInputTester(){

                public boolean test(IEditorInput input) {
                    return input instanceof IFileEditorInput && ref.isPrefixOf(((IFileEditorInput)input).getFile().getProjectRelativePath());
                }
            });
        }
        ReportsList.resetIfInputIs(path.toString() + ".hfml");
        IResourceUtils.deleteIFolder((IFolder)FACorePlugin.getRoot().getFolder(path), (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        IResourceUtils.deleteIFile((IFile)FACorePlugin.getRoot().getFile(path.addFileExtension("hfml")), (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        RemoveHistoryFile.notifyCallbacks(address, port, dataSet, member);
        if (target != null) {
            target.refreshSelf();
        } else {
            Activator.updateAll(SystemsViewBrowseHistoryFileNode.class);
        }
    }

    public static void addHistoryFileDeleteCallback(HistoryFileDeletedCallback callback) {
        if (callback != null) {
            histroyFileDeleteCallback.add(callback);
        }
    }

    public static void removeCallback(HistoryFileDeletedCallback callback) {
        if (callback != null) {
            histroyFileDeleteCallback.remove(callback);
        }
    }

    private static void notifyCallbacks(String address, String port, String dataSet, String member) {
        logger.trace((Object)MessageFormat.format("notifying observers about delete of {0} {1} {2} {3}", address, port, dataSet, member));
        for (HistoryFileDeletedCallback callback : histroyFileDeleteCallback) {
            callback.deleted(address, port, dataSet, member);
        }
    }

    public static interface HistoryFileDeletedCallback {
        public void deleted(String var1, String var2, String var3, String var4);
    }
}

