/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.impl.historyfile;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.editor.localview.OpenLocalViewEditorHandler;
import com.ibm.etools.fa.pdtclient.ui.faobjects.FaultAnalyzerParameters;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.AutomaticReportsListRefreshJob;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewBrowseHistoryFileNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class RefreshHistoryFile {
    private static PDLogger logger;

    public static PDLogger getLogger() {
        if (logger == null) {
            logger = PDLogger.get(RefreshHistoryFile.class);
        }
        return logger;
    }

    public static boolean isRefreshAlreadyRunning() {
        Job[] jobs;
        IJobManager jobManager = Job.getJobManager();
        Job[] jobArray = jobs = jobManager.find(FATPJob.class);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.getName().equals(Messages.RefreshHistoryFileHandler_Refresh_history_file)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void refresh(boolean updateScheduler) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ReportsList reportsList = ReportsList.getIfOpen();
                if (reportsList != null) {
                    String address = reportsList.getDisplayedResource().getResourceAddress();
                    String service = reportsList.getDisplayedResource().getResourceService();
                    String dataset = reportsList.getDisplayedResource().getResourceDataset();
                    String member = reportsList.getDisplayedResource().getResourceMember();
                    IPDHost host = reportsList.getDisplayedResource().getHost();
                    if (address != null && service != null && dataset != null) {
                        RefreshHistoryFile.refresh(host, address, service, dataset, member);
                    }
                } else {
                    RefreshHistoryFile.getLogger().error((Object)"Could not get reports list, so can't refresh.");
                }
            }
        });
        if (updateScheduler) {
            AutomaticReportsListRefreshJob.update();
        }
    }

    @Deprecated
    public static FATPJob refresh(String address, String service, String dataset, String member) {
        return RefreshHistoryFile.refresh(null, address, service, dataset, member);
    }

    public static FATPJob refresh(IPDHost host, String address, String service, String dataset, String member) {
        try {
            return RefreshHistoryFile.refresh(host, address, service, dataset, member, null, false);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Deprecated
    public static FATPJob refresh(String address, String service, String dataset, String member, List<JobChangeAdapter> jobChangeAdapter, boolean allowRefreshErrors) throws InterruptedException {
        return RefreshHistoryFile.refresh(null, address, service, dataset, member, jobChangeAdapter, allowRefreshErrors);
    }

    public static FATPJob refresh(IPDHost host, String address, String service, String dataset, String member, List<JobChangeAdapter> jobChangeAdapter, boolean allowRefreshErrors) throws InterruptedException {
        Objects.requireNonNull(address, "Must provide a non-null address.");
        Objects.requireNonNull(service, "Must provide a non-null service.");
        Objects.requireNonNull(dataset, "Must provide a non-null dataset.");
        if (PDLoggerJhost.isTraceEnabled()) {
            RefreshHistoryFile.getLogger().trace((Object)MessageFormat.format("Refreshing: address: {0} service: {1} dataset: {2} member: {3}", address, service, dataset, member));
        }
        try {
            AutomaticReportsListRefreshJob.cancelAnyJobs();
            FATP[] history_file_uris = new FATP[]{};
            if (member == null || member.trim().isEmpty()) {
                URI historyFileURI = FARL.getFARLURI((String)address, (String)service, (String)dataset);
                if (historyFileURI != null) {
                    history_file_uris = new FATP[]{FARL.get_history_file((URI)historyFileURI)};
                }
            } else {
                String viewFileMemberPath = String.format("%s://%s/%s/%s(%s)", "fatp", address, service, dataset, member);
                if (PDLoggerJhost.isTraceEnabled()) {
                    RefreshHistoryFile.getLogger().trace((Object)("viewFileMemberPath=" + viewFileMemberPath));
                }
                ArrayList<FATP> fatps = new ArrayList<FATP>();
                for (String index : ViewParser.parse(viewFileMemberPath.substring("fatp".length() + "://".length()) + ".hfml").getIndices()) {
                    URI uri = FARL.getFARLURI((String)address, (String)service, (String)index);
                    if (uri == null) continue;
                    fatps.add(FARL.get_history_file((URI)uri));
                }
                if (fatps.size() > 0) {
                    history_file_uris = new FATP[fatps.size()];
                    fatps.toArray(history_file_uris);
                } else if (fatps.isEmpty() && "local.views".equals(dataset)) {
                    if (PDDialogs.openQuestionThreadSafe((String)Messages.RefreshHistoryFileHandler_EmptyLocalView, (String)Messages.RefreshHistoryFile_0)) {
                        if (host == null) {
                            host = PDHost.findPDHost((String)address, (int)Integer.parseInt(service));
                        }
                        if (host != null) {
                            OpenLocalViewEditorHandler.openLocalView(host, member);
                        } else {
                            logger.error((Object)MessageFormat.format(Messages.RefreshHistoryFile_CantOpenLocalViewMissingSystem, address, service));
                        }
                    }
                    throw new InterruptedException();
                }
            }
            FATPJob fATPJob = RefreshHistoryFile.refresh(host, history_file_uris, address, service, dataset, member, jobChangeAdapter, allowRefreshErrors);
            return fATPJob;
        }
        finally {
            AutomaticReportsListRefreshJob.update();
        }
    }

    private static FATPJob refresh(final IPDHost host, FATP[] history_file_uris, final String address, final String service, final String dataset, final String member, List<JobChangeAdapter> jobChangeAdapter, final boolean allowRefreshErrors) {
        Objects.requireNonNull(address, "Must provide a non-null address.");
        final FATPJob job = new FATPJob(Messages.RefreshHistoryFileHandler_Refresh_history_file, history_file_uris, Job.create((String)Messages.RefreshHistoryFileHandler_Open_history_file, (IJobFunction)new IJobFunction(){

            public IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        })){

            @Override
            protected void finalize_responses(IProgressMonitor _mon) {
                for (FATP[] request_response : this.responses) {
                    RefreshHistoryFile.handleResponse(request_response, _mon);
                }
            }
        };
        try {
            job.set_user(FaultAnalyzerParameters.getUserFromHost(address, service, PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor())));
        }
        catch (InterruptedException e) {
            RefreshHistoryFile.getLogger().error((Throwable)e);
            return job;
        }
        if (jobChangeAdapter != null) {
            for (JobChangeAdapter jca : jobChangeAdapter) {
                if (jca == null) continue;
                job.addJobChangeListener((IJobChangeListener)jca);
            }
        }
        final StackTraceElement[] t = Thread.currentThread().getStackTrace();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (SystemsViewBrowseHistoryFileNode node : PDTreeContentHolder.getInstance().getNodesOfType(SystemsViewBrowseHistoryFileNode.class)) {
                            PDSystemsTreeUpdater.refreshAllRelatedTo((Object)((Object)node));
                        }
                        if (allowRefreshErrors || job.getResult().isOK()) {
                            ReportsList reportsList = ReportsList.getIfOpen();
                            if (reportsList != null) {
                                reportsList.refresh(host, address, service, dataset, member);
                            }
                        } else {
                            IStatus result = event.getResult();
                            if (!result.matches(8)) {
                                RefreshHistoryFile.getLogger().error((Object)("Refresh not-ok: " + String.valueOf(result)));
                                RefreshHistoryFile.getLogger().trace((Object)("Called from: " + PDLogger.filteredTrace((StackTraceElement[])t)));
                            }
                        }
                    }
                });
            }
        });
        ReportsList list = ReportsList.getIfOpen();
        if (list != null) {
            IWorkbenchSiteProgressService wsps = (IWorkbenchSiteProgressService)list.getSite().getAdapter(IWorkbenchSiteProgressService.class);
            wsps.schedule((Job)job, 0L, true);
        } else {
            job.schedule();
        }
        return job;
    }

    /*
     * Exception decompiling
     */
    private static boolean handleResponse(FATP[] request_response, IProgressMonitor _mon) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 11 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

