/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.impl.historyfile;

import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewLocalView;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewView;
import com.ibm.etools.fa.pdtclient.ui.FAVersionHolder;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RefreshHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.impl.system.AddSystem;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class OpenHistoryFile {
    private static PDLogger logger;
    private static int version;

    public static PDLogger getLogger() {
        if (logger == null) {
            logger = PDLogger.get(OpenHistoryFile.class);
        }
        return logger;
    }

    public static boolean openHistoryFile(SystemsViewHistoryFile a) {
        return OpenHistoryFile.openHistoryFile(a.getSystem(), a.getSystem().getHostName(), Integer.toString(a.getSystem().getPort()), a.getName(), null);
    }

    public static boolean openHistoryFile(SystemsViewView a) {
        return OpenHistoryFile.openView(a.getSystem(), a.getSystem().getHostName(), Integer.toString(a.getSystem().getPort()), a.getVwName(), a.getVwMemberName());
    }

    public static boolean openHistoryFile(SystemsViewLocalView a) {
        return OpenHistoryFile.openView(a.getSystem(), a.getSystem().getHostName(), Integer.toString(a.getSystem().getPort()), "local.views", a.getName());
    }

    @Deprecated
    public static FATPJob openHistoryFile(String address, String service, String dataset, String member, JobChangeAdapter refreshJobChangeAdapter, boolean allowRefreshErrors) throws InterruptedException {
        return OpenHistoryFile.openHistoryFile(null, address, service, dataset, member, refreshJobChangeAdapter, allowRefreshErrors);
    }

    public static FATPJob openHistoryFile(final IPDHost system, final String address, final String service, final String dataset, final String member, JobChangeAdapter refreshJobChangeAdapter, final boolean allowRefreshErrors) throws InterruptedException {
        Objects.requireNonNull(address, "Must provide a non-null address.");
        Objects.requireNonNull(service, "Must provide a non-null service.");
        Objects.requireNonNull(dataset, "Must provide a non-null dataset.");
        OpenHistoryFile.getLogger().trace((Object)MessageFormat.format("openHistoryFile: address: {0} service: {1} dataset:{2} member: {3}", address, service, dataset, member));
        AddSystem.addSystem(address, service);
        version = 0;
        if (system != null) {
            version = FAVersionHolder.getInstance().getVersion(system);
        } else {
            for (HostDetails hostDetail : ConnectionUtilities.getSystemInformation()) {
                if (!hostDetail.getHostname().equalsIgnoreCase(address) || hostDetail.getPortNumber() != Integer.parseInt(service)) continue;
                version = FAVersionHolder.getInstance().getVersion(hostDetail.getHostID());
            }
        }
        FATPJob job = null;
        if (ViewParser.parse(version, address, service, dataset, member).getEntryCount() == 0) {
            ArrayList<JobChangeAdapter> jobDoneAdapters = new ArrayList<JobChangeAdapter>();
            jobDoneAdapters.add(refreshJobChangeAdapter);
            jobDoneAdapters.add(new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if ((allowRefreshErrors || event.getResult().isOK()) && ReportsList.show(false) != null) {
                        ReportsList.setSource(system, address, service, dataset, member);
                        ReportsList.activate();
                    }
                }
            });
            job = RefreshHistoryFile.refresh(system, address, service, dataset, member, jobDoneAdapters, allowRefreshErrors);
        } else if (ReportsList.show(false) != null) {
            ReportsList.setSource(system, address, service, dataset, member);
            ReportsList.activate();
            if (Preferences.isExecuteRefreshOnOpenHistoryFile()) {
                RefreshHistoryFile.refresh(true);
            }
        }
        if (version != 0 && version <= 150100) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openInformation((Shell)shell, (String)"Information", (String)"SPILLED data is not available in the client UI from Fault Analyzer hosts prior to v15.1.2 \nPROGRAM data is not available in the client UI from Fault Analyzer hosts prior to v15.1.3");
        } else if (version != 0 && (version == 150101 || version == 150102)) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openInformation((Shell)shell, (String)"Information", (String)"PROGRAM data is not available in the client UI from Fault Analyzer hosts prior to v15.1.3");
        }
        return job;
    }

    @Deprecated
    public static boolean openHistoryFile(String address, String service, String dataset, String member) {
        return OpenHistoryFile.openHistoryFile(null, address, service, dataset, member);
    }

    public static boolean openHistoryFile(IPDHost system, String address, String service, String dataset, String member) {
        try {
            OpenHistoryFile.openHistoryFile(system, address, service, dataset, member, null, false);
            return true;
        }
        catch (InterruptedException e) {
            OpenHistoryFile.getLogger().trace((Object)"Interrupted.");
            return false;
        }
    }

    @Deprecated
    public static boolean openView(String address, String service, String dataset, String member) {
        return OpenHistoryFile.openView(null, address, service, dataset, member);
    }

    public static boolean openView(IPDHost system, String address, String service, String dataset, String member) {
        try {
            OpenHistoryFile.openHistoryFile(system, address, service, dataset, member, null, true);
            return true;
        }
        catch (InterruptedException e) {
            OpenHistoryFile.getLogger().trace((Object)"Interrupted.");
            return false;
        }
    }
}

