/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.impl.historyfile;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.HistoryFileAlllocationDetails;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.historyfile.HistoryFileAllocationParametersDialog;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.AddHistoryFile;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;

public class NewHistoryFile {
    private static PDLogger logger = PDLogger.get(NewHistoryFile.class);

    private static FATPJob newHistoryFile(final SystemsTreeNode target, final IPDHost system, final String address, final String port, final HistoryFileAlllocationDetails dataset) {
        Objects.requireNonNull(address, "Must specify a non-null address.");
        Objects.requireNonNull(port, "Must specify a non-null port.");
        Objects.requireNonNull(dataset, "Must specify a non-null dataset.");
        logger.trace((Object)MessageFormat.format("newHistoryFile: {0} {1} {2} {3}", target, address, port, dataset));
        String datasetCleaned = dataset.getHistoryFileName().trim().replace("'", "");
        URI hostUri = FARL.getFARLURI((String)address, (String)port, (String)datasetCleaned);
        logger.trace((Object)("Creating history file: " + String.valueOf(hostUri)));
        FATPJob job = new FATPJob(Messages.NewHistoryFile_CreatingNewHF, FARL.createNewHistoryFile((URI)hostUri, (String)dataset.serialize())){

            @Override
            protected void finalize_responses(IProgressMonitor _monitor) {
                for (FATP[] request_response : this.responses) {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (FATP response = request_response[1];){
                        if (!response.is_successful_response() || !response.get_status_code().equals("200")) continue;
                        AddHistoryFile.addHistoryFile(target, system, address, port, dataset.getHistoryFileName());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
        };
        return job;
    }

    public static FATPJob newHistoryFile(SystemsTreeNode target, IPDHost system, HistoryFileAlllocationDetails model) {
        if (system != null && model != null) {
            model.setHost(system);
            if (HistoryFileAllocationParametersDialog.open(model) == 0) {
                return NewHistoryFile.newHistoryFile(target, system, system.getHostName(), "" + system.getPort(), model);
            }
        }
        return null;
    }
}

