/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.impl.historyfile;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.OpenHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.systems.FASystemsTreeUpdater;
import com.ibm.etools.fa.pdtclient.ui.views.systems.model.SystemsViewBrowseHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewBrowseHistoryFileNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public abstract class AddHistoryFile {
    private static PDLogger logger;
    private static final String DEFAULT_AUTO_LOADED = "default_auto_loaded";

    public static PDLogger getLogger() {
        if (logger == null) {
            logger = PDLogger.get(AddHistoryFile.class);
        }
        return logger;
    }

    public static FATPJob addHistoryFile(SystemsTreeNode target, String address, String port, String dataset) {
        return AddHistoryFile.addHistoryFile(target, null, address, port, dataset);
    }

    public static FATPJob addHistoryFile(SystemsTreeNode target, IPDHost host, String address, String port, String dataset) {
        Objects.requireNonNull(address, "Must specify a non-null address.");
        Objects.requireNonNull(port, "Must specify a non-null port.");
        Objects.requireNonNull(dataset, "Must specify a non-null dataset.");
        AddHistoryFile.getLogger().trace((Object)MessageFormat.format("addHistoryFile: {0} {1} {2} {3}", target, address, port, dataset));
        String datasetCleaned = dataset.trim().replace("'", "");
        try {
            return OpenHistoryFile.openHistoryFile(host, address, port, datasetCleaned, null, AddHistoryFile.getJobDoneHandler(target, Ipv6Utils.encode((String)address), port, datasetCleaned), false);
        }
        catch (InterruptedException e) {
            AddHistoryFile.getLogger().error((Object)"Interrupted");
            return null;
        }
    }

    private static JobChangeAdapter getJobDoneHandler(final SystemsTreeNode target, final String address, final String port, final String datasetCleaned) {
        Objects.requireNonNull(address, "Must provide a non-null system address.");
        Objects.requireNonNull(port, "Must provide a non-null system port.");
        Objects.requireNonNull(datasetCleaned, "Must provide a non-null historyFile.");
        JobChangeAdapter errorHandler = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().matches(8) || event.getResult().matches(4)) {
                    AddHistoryFile.getLogger().trace((Object)event.getResult().getMessage(), event.getResult().getException());
                } else {
                    String message = event.getResult().getMessage();
                    if (message != null) {
                        if (message.contains(MessageFormat.format(Messages.AddHistoryFileHandler_0, datasetCleaned))) {
                            AddHistoryFile.getLogger().error((Object)("The specified dataset is not a history file: " + message));
                        } else {
                            IFolder historyFileFolder = FAResourceUtils.getHistoryFileFolder((String)address, (String)port, (String)datasetCleaned);
                            if (!historyFileFolder.exists()) {
                                IFile container = FAResourceUtils.getHistoryFileHFMLFile((String)address, (String)port, (String)datasetCleaned);
                                if (IResourceUtils.createEmptyIFile((IFile)container, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (boolean)false)) {
                                    XMLMemento memento = XMLMemento.createWriteRoot((String)"ul");
                                    memento.createChild("li").putTextData(datasetCleaned);
                                    MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)memento, (IFile)container, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
                                } else {
                                    logger.error((Object)"Could not create History file HFML file.");
                                }
                                IResourceUtils.mkdirs((IFolder)historyFileFolder, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
                                IResourceUtils.createIFile((IFile)FAResourceUtils.getHistoryFileIndexFile((String)address, (String)port, (String)datasetCleaned), (String)"<table class=\"history file\"></table>", (Charset)StandardCharsets.UTF_8, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
                                FASystemsTreeUpdater.refreshAllRelatedTo(target);
                            }
                        }
                    }
                }
            }
        };
        return errorHandler;
    }

    public static void loadDefaultHistoryFileIfNotLoadedYet(IPDHost pdHost) {
        IFolder systemFolder = FAResourceUtils.getSystemFolder((String)pdHost.getHostName(), (String)("" + pdHost.getPort()));
        boolean addedAlready = false;
        for (IResource child : IResourceUtils.ls((IFolder)systemFolder, (IProgressMonitor)new NullProgressMonitor(), (boolean)false)) {
            if (!child.getName().equals(DEFAULT_AUTO_LOADED)) continue;
            addedAlready = true;
        }
        if (!addedAlready) {
            AddHistoryFile.loadDefaultHistoryFile(pdHost, pdHost.getHostName(), "" + pdHost.getPort());
        }
    }

    public static void triggerReloadOfDefaultHistoryFile(String hostName, int port) {
        AddHistoryFile.triggerReloadOfDefaultHistoryFile(null, hostName, port);
    }

    public static void triggerReloadOfDefaultHistoryFile(IPDHost host, String hostName, int port) {
        IResourceUtils.deleteIFile((IFile)FAResourceUtils.getSystemFolder((String)hostName, (String)Integer.toString(port)).getFile(DEFAULT_AUTO_LOADED), (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        for (SystemsViewBrowseHistoryFileNode node : PDTreeContentHolder.getInstance().getNodesOfType(SystemsViewBrowseHistoryFileNode.class)) {
            IPDHost obj = ((SystemsViewBrowseHistoryFile)((Object)node.getDataObject())).getSystem();
            if (!obj.getHostName().equals(hostName) || obj.getPort() != port) continue;
            node.refreshSelf();
            node.getParent().refreshSelf();
        }
    }

    @Deprecated
    public static FATPJob loadDefaultHistoryFile(String address, String port) {
        return AddHistoryFile.loadDefaultHistoryFile(null, address, port);
    }

    public static FATPJob loadDefaultHistoryFile(final IPDHost host, final String address, final String port) {
        Objects.requireNonNull(address, "Must specify non-null address.");
        Objects.requireNonNull(port, "Must specify non-null port.");
        URI hostUri = FARL.getFARLURI((String)address, (String)port);
        AddHistoryFile.getLogger().trace((Object)("Getting default history file: " + String.valueOf(hostUri)));
        FATPJob job = new FATPJob(Messages.RefreshHistoryFileHandler_Get_default_history_file, FARL.get_default_history_file((URI)hostUri)){

            @Override
            protected void finalize_responses(IProgressMonitor _monitor) {
                for (FATP[] request_response : this.responses) {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (FATP response = request_response[1];){
                        Charset charset;
                        String defaultHistoryFile;
                        if (!response.is_successful_response() || !response.get_status_code().equals("200") || (defaultHistoryFile = response.get_body(charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.get_entity_header("Content-Type")))).isEmpty()) continue;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                FATPJob addJob = AddHistoryFile.addHistoryFile(null, host, address, port, defaultHistoryFile);
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    AddHistoryFile.getLogger().trace((Object)"Failed to load default history file ; preventing additional load attempts.");
                    AddHistoryFile.createMarkerFile(address, port, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    AddHistoryFile.createMarkerFile(address, port, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        });
        ReportsList list = ReportsList.show(false);
        if (list != null) {
            PDPlatformUIUtils.scheduleAndMarkPartBusy((Job)job, (IWorkbenchPartSite)list.getSite());
        } else {
            job.schedule();
        }
        return job;
    }

    private static void createMarkerFile(String address, String port, IProgressMonitor monitor) {
        IFile markerFiler = FAResourceUtils.getSystemFolder((String)Ipv6Utils.encode((String)address), (String)port).getFile(DEFAULT_AUTO_LOADED);
        IResourceUtils.refreshLocalIResource((IResource)markerFiler, (int)0, (IProgressMonitor)monitor);
        if (!IResourceUtils.existsCaseInsensitive((IResource)markerFiler, (IProgressMonitor)monitor, (boolean)false)) {
            IResourceUtils.createEmptyIFile((IFile)markerFiler, (boolean)true, (IProgressMonitor)monitor, (boolean)false);
        }
    }
}

