/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.handler.historyfile;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewLocalView;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewView;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RemoveHistoryFile;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveHistoryFileHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) {
        if (HandlerUtil.getActivePart((ExecutionEvent)event) instanceof PDSystemsView) {
            ArrayList<1> jobs = new ArrayList<1>();
            StringBuilder sb = new StringBuilder();
            for (final SystemsTreeNode systemsTreeNode : PDTreeHandlerUtil.getSelectedTreeNodes((ExecutionEvent)event)) {
                jobs.add(new Job(Messages.RemoveHistoryFileHandler_0){

                    public IStatus run(IProgressMonitor monitor) {
                        Object dataObject = systemsTreeNode.getDataObject();
                        if (dataObject instanceof SystemsViewView) {
                            SystemsViewView v = (SystemsViewView)dataObject;
                            RemoveHistoryFile.removeHistoryFile(systemsTreeNode.getParent(), v.getSystem().getHostName(), "" + v.getSystem().getPort(), v.getVwName(), v.getVwMemberName(), false);
                        } else if (dataObject instanceof SystemsViewLocalView) {
                            SystemsViewLocalView v = (SystemsViewLocalView)dataObject;
                            RemoveHistoryFile.removeHistoryFile(systemsTreeNode.getParent(), v.getSystem().getHostName(), "" + v.getSystem().getPort(), "local.views", v.getName(), false);
                        } else if (dataObject instanceof SystemsViewHistoryFile) {
                            SystemsViewHistoryFile h = (SystemsViewHistoryFile)dataObject;
                            RemoveHistoryFile.removeHistoryFile(systemsTreeNode.getParent(), h.getSystem().getHostName(), "" + h.getSystem().getPort(), h.getName(), null, false);
                        }
                        return Status.OK_STATUS;
                    }
                });
                if (systemsTreeNode.getDataObject() instanceof SystemsViewHistoryFile) {
                    sb.append(MessageFormat.format(Messages.RemoveHistoryFileHandler_1, ((SystemsViewHistoryFile)systemsTreeNode.getDataObject()).getName()));
                    sb.append(System.lineSeparator());
                    continue;
                }
                if (systemsTreeNode.getDataObject() instanceof SystemsViewLocalView) {
                    sb.append(MessageFormat.format(Messages.RemoveHistoryFileHandler_2, ((SystemsViewLocalView)systemsTreeNode.getDataObject()).getName()));
                    sb.append(System.lineSeparator());
                    continue;
                }
                if (!(systemsTreeNode.getDataObject() instanceof SystemsViewView)) continue;
                sb.append(MessageFormat.format(Messages.RemoveHistoryFileHandler_3, ((SystemsViewView)systemsTreeNode.getDataObject()).getName()));
                sb.append(System.lineSeparator());
            }
            if (PDDialogWithText.openQuestion(null, (String)Messages.RemoveHistoryFileHandler_4, (String)Messages.RemoveHistoryFileHandler_5, (String)sb.toString())) {
                for (Job job : jobs) {
                    job.schedule();
                }
            }
        }
    }
}

