/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.handler.historyfile;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RefreshHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.impl.CachedFaultEntry;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.impl.ClearCachedReport;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveCachedFaultEntriesHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) {
        if (HandlerUtil.getActivePart((ExecutionEvent)event) instanceof PDSystemsView) {
            ArrayList<1> jobs = new ArrayList<1>();
            StringBuilder sb = new StringBuilder();
            for (final SystemsTreeNode systemsTreeNode : PDTreeHandlerUtil.getSelectedTreeNodes((ExecutionEvent)event)) {
                jobs.add(new Job(Messages.RemoveHistoryFileHandler_0){

                    public IStatus run(IProgressMonitor monitor) {
                        Object dataObject = systemsTreeNode.getDataObject();
                        if (dataObject instanceof SystemsViewHistoryFile) {
                            File[] faDirEntries;
                            SystemsViewHistoryFile h = (SystemsViewHistoryFile)dataObject;
                            ArrayList<CachedFaultEntry> selected = new ArrayList<CachedFaultEntry>();
                            File faDir = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().concat("/FaultAnalyzer/").concat(h.getHFLocalPath()));
                            if (faDir.exists() && (faDirEntries = faDir.listFiles()) != null) {
                                File[] fileArray = faDirEntries;
                                int n = faDirEntries.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File file = fileArray[n2];
                                    if (!file.getName().endsWith(".hfml")) {
                                        selected.add(new CachedFaultEntry(h.getSystem().getHostName(), "" + h.getSystem().getPort(), h.getName(), file.getName()));
                                    }
                                    ++n2;
                                }
                            }
                            if (!selected.isEmpty() && ClearCachedReport.clearCachedReport(selected)) {
                                RefreshHistoryFile.refresh(h.getSystem(), h.getSystem().getHostName(), "" + h.getSystem().getPort(), h.getName(), null);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                });
                if (!(systemsTreeNode.getDataObject() instanceof SystemsViewHistoryFile)) continue;
                sb.append(MessageFormat.format(Messages.RemoveHistoryFileHandler_1, ((SystemsViewHistoryFile)systemsTreeNode.getDataObject()).getName()));
                sb.append(System.lineSeparator());
            }
            if (PDDialogWithText.openQuestion(null, (String)Messages.RemoveCachedFaultEntriesHandler_0, (String)Messages.RemoveCachedFaultEntriesHandler_1, (String)sb.toString())) {
                for (Job job : jobs) {
                    job.schedule();
                }
            }
        }
    }
}

