/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.handler.historyfile;

import com.ibm.etools.fa.pdtclient.core.model.HistoryFileAlllocationDetails;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.NewHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewHistoryFileHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) {
        if (HandlerUtil.getActivePart((ExecutionEvent)event) instanceof PDSystemsView) {
            SystemsTreeNode target = SystemsTreeNode.getTargetNode((ExecutionEvent)event);
            IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)target);
            NewHistoryFileHandler.promptForHistoryFileParameters(target, system, null, null);
        }
    }

    public static void promptForHistoryFileParameters(SystemsTreeNode target, IPDHost system, String initialHistoryFileName, JobChangeAdapter jobChangeAdapter) {
        FATPJob job;
        HistoryFileAlllocationDetails model = new HistoryFileAlllocationDetails();
        if (initialHistoryFileName != null) {
            model.setHistoryFileName(initialHistoryFileName);
        }
        if ((job = NewHistoryFile.newHistoryFile(target, system, model)) != null) {
            ReportsList list;
            if (jobChangeAdapter != null) {
                job.addJobChangeListener((IJobChangeListener)jobChangeAdapter);
            }
            if ((list = ReportsList.show(false)) != null) {
                PDPlatformUIUtils.scheduleAndMarkPartBusy((Job)job, (IWorkbenchPartSite)list.getSite());
            } else {
                job.schedule();
            }
        }
    }
}

