/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.handler.historyfile;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPAdapter;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob2;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPResponseHandler;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.HandlerUtil;

public class GetHistoryFilePropertiesHandler
extends SkeletonHandler {
    public static final String NAME = Messages.GetHistoryFilePropertiesHandler_GettingProperties;
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.command.gethistoryproperties";

    protected void handle(ExecutionEvent event) {
        GetHistoryFilePropertiesHandler.getProperties(event);
    }

    public static boolean getProperties(ExecutionEvent event) {
        if (HandlerUtil.getActivePart((ExecutionEvent)event) instanceof PDSystemsView) {
            Object o = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
            if (o == null) {
                return false;
            }
            if (o instanceof SystemsViewHistoryFile) {
                SystemsViewHistoryFile hf = (SystemsViewHistoryFile)o;
                FATPJob j = GetHistoryFilePropertiesHandler.getPropertiesFromHost(hf);
                if (j != null) {
                    j.schedule(200L);
                }
                return true;
            }
            throw new IllegalArgumentException(o.toString() + " is not a history file.");
        }
        return false;
    }

    public static FATPJob getPropertiesFromHost(final SystemsViewHistoryFile hf) {
        String port;
        String hostName = hf.getSystem().getHostName();
        URI historyFileURI = FARL.getFARLURI((String)hostName, (String)(port = Integer.toString(hf.getSystem().getPort())), (String)hf.getName());
        if (historyFileURI != null) {
            HashMap<FATP, FATPResponseHandler> requests = new HashMap<FATP, FATPResponseHandler>();
            FATP get_info = FARL.get_history_file_info((URI)historyFileURI, (String)Preferences.getNL());
            if (get_info != null) {
                requests.put(get_info, new FATPResponseHandler(){

                    @Override
                    public void handle(IProgressMonitor monitor, FATPAdapter response) {
                        Charset cs = CharsetResponseHelper.getCharsetFromResponseOrDefaultFromContentTypeHeader(response.getEntityContentType());
                        String body = response.get_body(cs);
                        if (body.trim().isEmpty()) {
                            hf.setPersistentProperty("Error", "An error occurred loading properties.");
                            return;
                        }
                        try {
                            XMLMemento root = XMLMemento.createReadRoot((Reader)new StringReader(body));
                            if (root.getType().equals("table")) {
                                IMemento[] iMementoArray = root.getChildren("tr");
                                int n = iMementoArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IMemento tr = iMementoArray[n2];
                                    IMemento[] td = tr.getChildren("td");
                                    if (td.length == 2) {
                                        String key = td[0].getTextData().trim();
                                        String value = td[1].getTextData().trim();
                                        hf.setPersistentProperty(key, value);
                                    }
                                    ++n2;
                                }
                            }
                        }
                        catch (WorkbenchException e) {
                            PDLogger.get(this.getClass()).error((Object)Messages.GetHistoryFilePropertiesHandler_ErrorParsing, (Throwable)e);
                            hf.setPersistentProperty("Error", e.getMessage());
                        }
                    }
                });
                FATPJob2 job = new FATPJob2(NAME, requests, true);
                job.setUser(true);
                return job;
            }
            PDLogger.get(GetHistoryFilePropertiesHandler.class).error((Object)Messages.GetHistoryFilePropertiesHandler_ProblemGettingProps);
        }
        return null;
    }
}

