/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.fatp;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.jhost.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.NonBlockingSocketIOJhost;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class FATPJob
extends Job {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FATPJob.class);
    private List<FATP> requests;
    private Job on_success;
    private Job on_failure;
    private String user = "";
    private Map<String, NonBlockingSocketIOJhost> open_connections = new HashMap<String, NonBlockingSocketIOJhost>();
    private Map<String, ByteArrayOutputStream> open_streams = new HashMap<String, ByteArrayOutputStream>();
    protected List<FATP[]> responses = new ArrayList<FATP[]>();
    private List<FATP[]> responsesToCleanup = new ArrayList<FATP[]>();
    private boolean processEachResponse = false;
    private static String clientVersion = null;
    private String originalThreadName;

    public FATPJob(String _name, FATP _request) {
        this(_name, new FATP[]{_request}, null);
    }

    public FATPJob(String _name, FATP _request, Job _on_success) {
        this(_name, new FATP[]{_request}, _on_success);
    }

    public FATPJob(String _name, FATP[] _requests, Job _on_success) {
        this(_name, Arrays.asList(_requests), _on_success);
    }

    public FATPJob(String _name, List<FATP> _requests, Job _on_success) {
        super(_name);
        this.setThread(new Thread());
        if (Preferences.isTraceEnabled()) {
            this.requests = new ArrayList<FATP>();
            try {
                String hostPort = _requests.get(0).getWrappedHostRequestHeader();
                this.requests.add(FARL.trace_on((URI)new URI("fatp://" + hostPort)));
                for (FATP fatp : _requests) {
                    if (!Messages.FARL_downloadZZDEBUG.equals(fatp.get_request_description())) continue;
                    this.requests.add(FARL.zzdebug_on((URI)new URI("fatp://" + hostPort)));
                    break;
                }
                this.requests.addAll(_requests);
            }
            catch (URISyntaxException e) {
                logger.warn((Object)"Error creating URI: ", (Throwable)e);
            }
        } else {
            this.requests = Objects.requireNonNull(_requests, "Must provide non-null requests.");
        }
        this.on_success = _on_success;
        if (this.requests != null && this.requests.size() > 0) {
            this.responses = new ArrayList<FATP[]>(this.requests.size());
        }
    }

    public FATPJob(String _name, FATP[] _requests, Job _on_success, Job _on_failure) {
        this(_name, _requests, _on_success);
        this.on_failure = _on_failure;
    }

    public FATPJob(String _name, List<FATP> _requests, boolean processEachResponse) {
        this(_name, _requests, null);
        this.processEachResponse = processEachResponse;
    }

    private static IStatus createOverallStatus(LinkedList<IStatus> requestStatusList) {
        Object overallStatus = requestStatusList.size() > 1 ? new MultiStatus("com.ibm.etools.fa.pdtclient.ui", 0, requestStatusList.toArray(new IStatus[requestStatusList.size()]), null, null) : (requestStatusList.size() == 1 ? requestStatusList.getFirst() : new Status(4, "com.ibm.etools.fa.pdtclient.core", com.ibm.etools.fa.pdtclient.core.Messages.FATPJob_Connection_error));
        return overallStatus;
    }

    private static IStatus createErrorStatus(LinkedList<IStatus> requestStatusList) {
        LinkedList<IStatus> errorStatusList = new LinkedList<IStatus>();
        for (IStatus status : requestStatusList) {
            if (status.isOK()) continue;
            errorStatusList.add(status);
        }
        return FATPJob.createOverallStatus(errorStatusList);
    }

    public boolean belongsTo(Object family) {
        if (family.equals(FATPJob.class)) {
            return true;
        }
        return super.belongsTo(family);
    }

    private void close_connection(NonBlockingSocketIOJhost _connection, String _host, IHowIsGoing _monitor) {
        if (!_connection.isClosed()) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FATP closer = FARL.disconnect((URI)FARL.getFARLURI((String)_host));){
                block12: {
                    try {
                        byte[] close_message = closer.toString().getBytes(FARL.CHARSET_ENGLISH);
                        _connection.writeBytes(close_message, 0, close_message.length, _monitor);
                    }
                    catch (IOException e) {
                        if (_monitor.isCanceled()) break block12;
                        logger.warn((Throwable)e);
                    }
                }
                _connection.closeConnection();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.open_connections.remove(_host);
        this.open_streams.remove(_host);
    }

    private void close_connections(IHowIsGoing _monitor) {
        _monitor.subTask(com.ibm.etools.fa.pdtclient.core.Messages.FATPJob_Closing_connections);
        for (Map.Entry<String, NonBlockingSocketIOJhost> connection : this.open_connections.entrySet()) {
            this.close_connection(connection.getValue(), connection.getKey(), _monitor);
        }
    }

    protected abstract void finalize_responses(IProgressMonitor var1);

    private NonBlockingSocketIOJhost find_server(FATP _request, IHowIsGoing _monitor) throws InterruptedException, CommunicationException {
        URI uri;
        HostDetails to_use;
        Objects.requireNonNull(_request, "Must specify a non-null request.");
        String host = _request.getWrappedHostRequestHeader();
        if (this.open_connections.containsKey(host)) {
            NonBlockingSocketIOJhost connection = this.open_connections.get(host);
            if (!connection.isClosed()) {
                return connection;
            }
            this.close_connection(connection, host, _monitor);
        }
        if ((to_use = this.getHostDetails(Ipv6Utils.bracketStrip((String)(uri = FARL.getFARLURI((String)host)).getHost()), uri.getPort(), _monitor)) != null) {
            HashMap options = new HashMap();
            NonBlockingSocketIOJhost connection = ConnectionUtilities.newConnection((HostDetails)to_use, (String)"FA", options, (IHowIsGoing)_monitor);
            this.open_connections.put(host, connection);
            return connection;
        }
        return null;
    }

    private HostDetails getHostDetails(String host, int port, IHowIsGoing _monitor) throws InterruptedException {
        HostDetails foundDetail = null;
        for (HostDetails hostDetail : ConnectionUtilities.getSystemInformation()) {
            if (!hostDetail.getHostname().equalsIgnoreCase(host) || hostDetail.getPortNumber() != port) continue;
            if (this.user != null && !this.user.isEmpty()) {
                AuthDetails authDetail = ConnectionUtilities.hasLogin((TheHost)new TheHost(hostDetail), (IHowIsGoing)_monitor);
                if (authDetail == null) {
                    foundDetail = hostDetail;
                    continue;
                }
                if (!authDetail.getUsername().equals(this.user)) continue;
            }
            foundDetail = hostDetail;
            break;
        }
        return foundDetail;
    }

    private ByteArrayOutputStream find_stream(FATP _request) {
        String host = _request.getWrappedHostRequestHeader();
        if (this.open_streams.containsKey(host)) {
            return this.open_streams.get(host);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(4096);
        this.open_streams.put(host, stream);
        return stream;
    }

    private ByteArrayOutputStream reset_in_stream(String _host, ByteArrayInputStream response_stream) throws IOException {
        int bytes_left = response_stream.available();
        byte[] body_bytes = new byte[bytes_left];
        response_stream.read(body_bytes);
        ByteArrayOutputStream in_stream = new ByteArrayOutputStream(4096);
        try {
            in_stream.write(body_bytes);
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
        }
        this.open_streams.put(_host, in_stream);
        return in_stream;
    }

    private static String convertXmlResponseToErrorMessage(String errorBodyContent) {
        StringBuilder errorMessageBuilder = new StringBuilder();
        String messageNodePath = "//tr/td[4]";
        NodeList errorMessageNodes = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(new ByteArrayInputStream(errorBodyContent.getBytes(StandardCharsets.UTF_8)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            errorMessageNodes = (NodeList)xPath.compile(messageNodePath).evaluate(xmlDocument, XPathConstants.NODESET);
            if (errorMessageNodes != null && errorMessageNodes.getLength() > 0) {
                int i = 0;
                while (i < errorMessageNodes.getLength()) {
                    Node errorMessageNode = errorMessageNodes.item(i);
                    String nodeContent = errorMessageNode.getTextContent();
                    if (nodeContent != null && !nodeContent.isEmpty()) {
                        errorMessageBuilder.append(nodeContent);
                        errorMessageBuilder.append("\n");
                    }
                    ++i;
                }
            } else {
                String logMessage = "Failed to parse error message as 4 column table, will return raw text input";
                logger.warn((Object)logMessage);
                errorMessageBuilder.append(errorBodyContent);
            }
        }
        catch (Exception e) {
            String logMessage = "Failed to parse error message as XML, will return raw text input";
            logger.warn((Object)logMessage, (Throwable)e);
            errorMessageBuilder.append(errorBodyContent);
        }
        return errorMessageBuilder.toString();
    }

    private static void reportHeapUsage(String when) {
        if (PDLogger.isTraceEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            long freeMemory = runtime.freeMemory();
            long maxMemory = runtime.maxMemory();
            long totalMemory = runtime.totalMemory();
            logger.debug(new Object[]{when, " Free: ", FATPJob.toMegabytes(freeMemory), " total: ", FATPJob.toMegabytes(totalMemory), " max: ", FATPJob.toMegabytes(maxMemory)});
        }
    }

    protected IStatus run(final IProgressMonitor monitorIn) {
        final AtomicReference status = new AtomicReference();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor arg0) throws CoreException {
                    status.set(FATPJob.this.runImpl(monitorIn));
                }
            }, (ISchedulingRule)FACorePlugin.getRoot(), 1, monitorIn);
        }
        catch (CoreException e) {
            logger.error((Throwable)e);
        }
        return (IStatus)status.get();
    }

    public static String getFAClientVersion() {
        if (clientVersion == null) {
            Version bundleVersion = FACorePlugin.getDefault().getBundle().getVersion();
            clientVersion = bundleVersion == null ? "unknown" : String.format("%02d%02d%02d", bundleVersion.getMajor(), bundleVersion.getMinor(), bundleVersion.getMicro());
        }
        return clientVersion;
    }

    /*
     * Exception decompiling
     */
    protected IStatus runImpl(IProgressMonitor monitorIn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 28[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T extends Number> long toMegabytes(T content_length) {
        int BYTES_IN_MEGABYTE = 0x100000;
        return Objects.requireNonNull(content_length, "Please provide a non-null number of bytes.").longValue() / 0x100000L;
    }

    public void set_user(String _user) {
        if (_user != null) {
            this.user = _user;
        }
    }
}

