/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.fatp;

import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.core.resources.IFile;

public class FATPAdapter {
    private static final PDLogger logger = PDLogger.get(FATPAdapter.class);
    private FATP fatp;

    public FATPAdapter(FATP fatp) {
        this.fatp = Objects.requireNonNull(fatp);
    }

    public String getEntityContentType() {
        return this.fatp.get_entity_header("Content-Type");
    }

    public boolean is_successful_response() {
        return this.fatp.is_successful_response();
    }

    public boolean isNoContentResponse() {
        return "204".equals(this.fatp.get_status_code());
    }

    public String toTrace() {
        return this.fatp.toTrace();
    }

    public String get_body(Charset charset) {
        return this.fatp.get_body(charset);
    }

    public void copy_body_to_file_utf8(IFile file, Charset bodyCharset) {
        this.copy_body_to_file_utf8(Objects.requireNonNull(file, "Must Specify a non-null file.").getRawLocation().toFile(), Objects.requireNonNull(bodyCharset, "Must specify a non-null bodyCharset"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy_body_to_file_utf8(File outFile, Charset bodyCharset) {
        File infile = this.fatp.get_temp_file();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                RandomAccessFile inraf = new RandomAccessFile(infile, "r");
                try {
                    block29: {
                        RandomAccessFile outraf = new RandomAccessFile(outFile, "rw");
                        try {
                            block28: {
                                FileChannel finc = inraf.getChannel();
                                try {
                                    try (FileChannel foutc = outraf.getChannel();){
                                        MappedByteBuffer inmbb = finc.map(FileChannel.MapMode.READ_ONLY, 0L, infile.length());
                                        CharsetDecoder decoder = bodyCharset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE).replaceWith("\ufffd");
                                        CharBuffer cb = decoder.decode(inmbb);
                                        if (CharsetResponseHelper.getLanguageCharset().equals(FARL.CHARSET_KOREAN)) {
                                            int i = 0;
                                            while (i < cb.length()) {
                                                if ('\u0085' == cb.charAt(i)) {
                                                    cb.put(i, '\n');
                                                }
                                                ++i;
                                            }
                                        }
                                        ByteBuffer outbb = StandardCharsets.UTF_8.newEncoder().encode(cb);
                                        foutc.write(outbb);
                                        foutc.close();
                                        finc.close();
                                        inmbb = null;
                                    }
                                    if (finc == null) break block28;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (finc == null) throw throwable;
                                    finc.close();
                                    throw throwable;
                                }
                                finc.close();
                            }
                            if (outraf == null) break block29;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (outraf == null) throw throwable;
                            outraf.close();
                            throw throwable;
                        }
                        outraf.close();
                    }
                    if (inraf == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (inraf == null) throw throwable;
                    inraf.close();
                    throw throwable;
                }
                inraf.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error occurred when attempting to copy file: " + String.valueOf(infile) + " to " + String.valueOf(outFile)), (Throwable)e);
        }
    }
}

