/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.faov.tree.system;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.dump.DumpsNode;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewNode;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.FAORootNode;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.Node;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.history.HistoryFileNode;
import com.ibm.etools.fa.pdtclient.ui.impl.system.AddSystem;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class SystemNode
extends Node<Node<?>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public SystemNode(String host, String port) {
        super(host, port, host + "/" + port, host + " : " + port);
    }

    @Override
    public Image getImage() {
        return Activator.getImageDescriptor("icons/host.gif").createImage();
    }

    @Override
    public String getText() {
        IFile alias = FAResourceUtils.getSystemFolder((String)this.getHost(), (String)this.getHost()).getFile(".alias");
        if (alias.exists()) {
            try {
                List<String> lines = Files.readAllLines(alias.getLocation().toFile().toPath(), StandardCharsets.UTF_8);
                if (lines != null && !lines.isEmpty()) {
                    return this.getDescription() + " [" + lines.get(0).trim() + "]";
                }
            }
            catch (IOException e) {
                logger.warn((Throwable)e);
            }
        }
        return this.getDescription();
    }

    public FAORootNode getParent() {
        return new FAORootNode();
    }

    @Override
    public boolean hasChildren() {
        IFolder system = FAResourceUtils.getSystemFolder((String)this.getHost(), (String)this.getPort());
        if (system.exists()) {
            Collection members = IResourceUtils.ls((IFolder)system, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
            for (IResource member : members) {
                if (FAResourceUtils.isFileExtension((IResource)member, (String)"hfml")) {
                    return true;
                }
                if (member.getType() != 2 || !member.getName().endsWith(".zip dump")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<Node<?>> getChildren() {
        IFolder system = FAResourceUtils.getSystemFolder((String)this.getHost(), (String)this.getPort());
        if (system.exists()) {
            ArrayList nodes = new ArrayList();
            Collection members = IResourceUtils.ls((IFolder)system, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
            for (IResource member : members) {
                if (FAResourceUtils.isFileExtension((IResource)member, (String)"hfml")) {
                    if (member.getProjectRelativePath().removeFileExtension().lastSegment().toString().split("\\(")[0].equals("local.views")) {
                        nodes.add(new ViewNode(this.getHost(), this.getPort(), Messages.Dropper_local_views));
                        continue;
                    }
                    if (member.getName().contains("(")) {
                        nodes.add(new ViewNode(this.getHost(), this.getPort(), member.getProjectRelativePath().removeFileExtension().lastSegment().toString().split("\\(")[0]));
                        continue;
                    }
                    nodes.add(new HistoryFileNode(this.getHost(), this.getPort(), member.getProjectRelativePath().toString()));
                    continue;
                }
                if (member.getType() != 2 || !member.getName().endsWith(".zip dump")) continue;
                nodes.add(new DumpsNode(this.getHost(), this.getPort(), system.getProjectRelativePath().toString()));
            }
            return nodes;
        }
        AddSystem.addSystem(this.getHost(), this.getPort());
        return Collections.emptyList();
    }
}

